/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.docker.core;

import com.spotify.docker.client.DockerClient;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.eclipse.linuxtools.docker.core.DockerConnectionManager;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerConnectionSettings;
import org.eclipse.linuxtools.docker.core.IDockerConnectionSettingsProvider;
import org.eclipse.linuxtools.docker.core.IDockerConnectionStorageManager;
import org.eclipse.linuxtools.internal.docker.core.DefaultDockerConnectionSettingsFinder;
import org.eclipse.linuxtools.internal.docker.core.DefaultDockerConnectionStorageManager;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.core.DockerContainerRefreshManager;
import org.eclipse.linuxtools.internal.docker.core.TCPConnectionSettings;
import org.eclipse.linuxtools.internal.docker.core.UnixSocketConnectionSettings;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockDockerClientFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockDockerConnectionFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockDockerConnectionStorageManagerFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.SWTUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DockerConnectionManagerTest {
    private final DockerConnectionManager dockerConnectionManager = DockerConnectionManager.getInstance();
    private final DockerContainerRefreshManager dockerContainersRefreshManager = DockerContainerRefreshManager.getInstance();

    @AfterClass
    public static void restoreDefaultConfig() {
        DockerConnectionManager.getInstance().setConnectionStorageManager((IDockerConnectionStorageManager)new DefaultDockerConnectionStorageManager());
    }

    @Before
    @After
    public void reset() {
        this.dockerContainersRefreshManager.reset();
    }

    @Test
    public void shouldRegisterConnectionOnRefreshContainersManager() {
        DockerClient client = MockDockerClientFactory.build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Test", client).withDefaultTCPConnectionSettings();
        this.dockerConnectionManager.setConnectionStorageManager(MockDockerConnectionStorageManagerFactory.providing(new IDockerConnection[]{dockerConnection}));
        SWTUtils.syncExec(() -> this.dockerConnectionManager.reloadConnections());
        dockerConnection.getContainers();
        Assertions.assertThat((Iterable)this.dockerContainersRefreshManager.getConnections()).contains((Object[])new IDockerConnection[]{dockerConnection});
    }

    @Test
    public void shouldUnregisterConnectionOnRefreshContainersManager() {
        DockerClient client = MockDockerClientFactory.build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Test", client).withDefaultTCPConnectionSettings();
        this.dockerConnectionManager.setConnectionStorageManager(MockDockerConnectionStorageManagerFactory.providing(new IDockerConnection[]{dockerConnection}));
        SWTUtils.syncExec(() -> this.dockerConnectionManager.reloadConnections());
        dockerConnection.getContainers();
        Assertions.assertThat((Iterable)this.dockerContainersRefreshManager.getConnections()).contains((Object[])new IDockerConnection[]{dockerConnection});
        SWTUtils.syncExec(() -> this.dockerConnectionManager.removeConnection((IDockerConnection)dockerConnection));
        SWTUtils.wait(1, TimeUnit.SECONDS);
        Assertions.assertThat((!this.dockerContainersRefreshManager.getConnections().contains(dockerConnection) ? 1 : 0) != 0);
    }

    @Test
    public void testExtensionPointProvidedConnections() {
        DefaultDockerConnectionSettingsFinder finder = new DefaultDockerConnectionSettingsFinder();
        List settings = finder.getKnownConnectionSettings();
        Assert.assertTrue((settings.size() > 0 ? 1 : 0) != 0);
        for (IDockerConnectionSettings s : settings) {
            TCPConnectionSettings t;
            if (s instanceof TCPConnectionSettings) {
                t = (TCPConnectionSettings)s;
                Assertions.assertThat((Comparable)t.getType()).isEqualTo((Object)IDockerConnectionSettings.BindingType.TCP_CONNECTION);
                Assertions.assertThat((String)t.getHost()).isEqualTo((Object)"https://1.2.3.4:5678");
                Assertions.assertThat((String)t.getPathToCertificates()).isEqualTo((Object)"/foo/bar/baz/certs");
                Assertions.assertThat((String)t.getName()).isEqualTo((Object)"https://1.2.3.4:5678");
                continue;
            }
            if (s instanceof UnixSocketConnectionSettings) {
                t = (UnixSocketConnectionSettings)s;
                if (t.getPath().equals("unix:///var/run/docker.sock")) continue;
                Assertions.assertThat((Comparable)t.getType()).isEqualTo((Object)IDockerConnectionSettings.BindingType.UNIX_SOCKET_CONNECTION);
                Assertions.assertThat((String)t.getPath()).isEqualTo((Object)"unix:///foo/bar/baz/docker.sock");
                Assertions.assertThat((String)t.getName()).isEqualTo((Object)"unix:///foo/bar/baz/docker.sock");
                continue;
            }
            Assert.fail((String)"Docker Connection Settings does not match a known type");
        }
    }

    public static class TCPTestConnectionProvider
    implements IDockerConnectionSettingsProvider {
        public List<IDockerConnectionSettings> getConnectionSettings() {
            String tcpHost = "https://1.2.3.4:5678";
            String tcpCertPath = "/foo/bar/baz/certs";
            TCPConnectionSettings tcp = new TCPConnectionSettings("https://1.2.3.4:5678", "/foo/bar/baz/certs");
            tcp.setName("https://1.2.3.4:5678");
            return Arrays.asList(tcp);
        }
    }

    public static class UnixTestConnectionProvider
    implements IDockerConnectionSettingsProvider {
        public List<IDockerConnectionSettings> getConnectionSettings() {
            String socketPath = "unix:///foo/bar/baz/docker.sock";
            UnixSocketConnectionSettings unix = new UnixSocketConnectionSettings("unix:///foo/bar/baz/docker.sock");
            unix.setName("unix:///foo/bar/baz/docker.sock");
            return Arrays.asList(unix);
        }
    }
}

