/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.core;

import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.messages.Image;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.core.DockerImage;
import org.eclipse.linuxtools.internal.docker.ui.testutils.DockerImageAssertions;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockDockerClientFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockDockerConnectionFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockImageFactory;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class DockerImageQualifierTestCase {
    @Parameterized.Parameter(value=0)
    public DockerImage.DockerImageQualifier qualifier;
    @Parameterized.Parameter(value=1)
    public Image[] images;

    @Parameterized.Parameters
    public static Collection<Object[]> getData() {
        ParameterizedDataset dataset = new ParameterizedDataset();
        dataset.add(DockerImage.DockerImageQualifier.TOP_LEVEL, MockImageFactory.id("foo").name("foo:latest", new String[0]).build());
        dataset.add(DockerImage.DockerImageQualifier.TOP_LEVEL, MockImageFactory.id("foo").name("foo:latest", "foo:1.0").build());
        dataset.add(DockerImage.DockerImageQualifier.TOP_LEVEL, MockImageFactory.id("foo").name("foo:<none>", new String[0]).build());
        dataset.add(DockerImage.DockerImageQualifier.INTERMEDIATE, MockImageFactory.id("foo").name("<none>:<none>", new String[0]).build(), MockImageFactory.id("bar").parentId("foo").name("bar:latest", new String[0]).build());
        dataset.add(DockerImage.DockerImageQualifier.INTERMEDIATE, MockImageFactory.id("foo").build(), MockImageFactory.id("bar").parentId("foo").name("bar:latest", new String[0]).build());
        dataset.add(DockerImage.DockerImageQualifier.DANGLING, MockImageFactory.id("foo").name("<none>:<none>", new String[0]).build());
        dataset.add(DockerImage.DockerImageQualifier.DANGLING, MockImageFactory.id("foo").build());
        return dataset.toList();
    }

    @Test
    public void verifyImageQualifier() throws DockerException {
        DockerClient client = MockDockerClientFactory.images(this.images).build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Test", client).withDefaultTCPConnectionSettings();
        dockerConnection.open(false);
        DockerImageAssertions.assertThat(dockerConnection.getImage("foo")).is(this.qualifier);
    }

    static class ParameterizedDataset {
        private final List<Object[]> data = new ArrayList<Object[]>();

        ParameterizedDataset() {
        }

        public ParameterizedDataset add(DockerImage.DockerImageQualifier qualifier, Image ... images) {
            this.data.add(new Object[]{qualifier, images});
            return this;
        }

        public List<Object[]> toList() {
            return this.data;
        }
    }
}

