/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.launch;

import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.ProgressHandler;
import com.spotify.docker.client.exceptions.DockerException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.linuxtools.docker.core.DockerConnectionManager;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.ui.jobs.JobMessages;
import org.eclipse.linuxtools.internal.docker.ui.launch.LaunchMessages;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockDockerClientFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockDockerConnectionFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.ProjectInitializationRule;
import org.eclipse.linuxtools.internal.docker.ui.testutils.RunWithProject;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.ClearConnectionManagerRule;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.ClearLaunchConfigurationsRule;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.CloseWelcomePageRule;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.DockerConnectionManagerUtils;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.ProjectExplorerViewRule;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.SWTUtils;
import org.eclipse.linuxtools.internal.docker.ui.wizards.WizardMessages;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotMenu;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class BuildDockerImageShortcutSWTBotTest {
    @ClassRule
    public static CloseWelcomePageRule closeWelcomePage = new CloseWelcomePageRule("org.eclipse.linuxtools.docker.ui.perspective");
    @Rule
    public ClearConnectionManagerRule clearConnectionManager = new ClearConnectionManagerRule();
    @Rule
    public ProjectInitializationRule projectInit = new ProjectInitializationRule();
    @Rule
    public ClearLaunchConfigurationsRule clearLaunchConfig = new ClearLaunchConfigurationsRule("org.eclipse.linuxtools.docker.ui.buildDockerImageLaunchConfigurationType");
    @Rule
    public ProjectExplorerViewRule projectExplorerViewRule = new ProjectExplorerViewRule();
    private SWTWorkbenchBot bot = new SWTWorkbenchBot();

    private SWTBotMenu getRunAsdockerImageBuildContextMenu(String projectName, String dockerFileName) {
        SWTBotTreeItem fooProjectTreeItem = SWTUtils.getTreeItem(this.projectExplorerViewRule.getProjectExplorerBotView(), projectName);
        Assertions.assertThat((Object)fooProjectTreeItem).isNotNull();
        SWTUtils.syncExec(() -> fooProjectTreeItem.expand());
        SWTBotTreeItem dockerfileTreeItem = SWTUtils.getTreeItem(fooProjectTreeItem, dockerFileName);
        Assertions.assertThat((Object)dockerfileTreeItem).isNotNull();
        SWTUtils.select(dockerfileTreeItem);
        SWTBotMenu runAsDockerImageBuildMenu = SWTUtils.getContextMenu(this.projectExplorerViewRule.getProjectExplorerBotView().bot().tree(), "Run As", "1 Docker Image Build");
        return runAsDockerImageBuildMenu;
    }

    @Test
    @RunWithProject(value="foo")
    public void shouldDisableCommandOnFirstCallWhenMissingConnection() {
        ClearConnectionManagerRule.removeAllConnections(DockerConnectionManager.getInstance());
        SWTUtils.asyncExec(() -> {
            SWTBotMenu sWTBotMenu = this.getRunAsdockerImageBuildContextMenu("foo", "Dockerfile").click();
        });
        Assertions.assertThat((Object)this.bot.shell(LaunchMessages.getString((String)"BuildDockerImageShortcut.no.connections.msg"))).isNotNull();
        SWTUtils.syncExec(() -> this.bot.button("No").click());
    }

    @Test
    @RunWithProject(value="foo")
    public void shouldPromptDialogThenBuildDockerImageOnFirstCall() throws InterruptedException, DockerException, IOException {
        DockerClient client = MockDockerClientFactory.build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Test", client).withDefaultTCPConnectionSettings();
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection});
        SWTUtils.asyncExec(() -> {
            SWTBotMenu sWTBotMenu = this.getRunAsdockerImageBuildContextMenu("foo", "Dockerfile").click();
        });
        Assertions.assertThat((Object)this.bot.shell(WizardMessages.getString((String)"ImageBuildDialog.title"))).isNotNull();
        this.bot.textWithLabel(WizardMessages.getString((String)"ImageBuildDialog.repoNameLabel")).setText("foo/bar:latest");
        SWTUtils.syncExec(() -> this.bot.button("OK").click());
        ((DockerClient)Mockito.verify((Object)client, (VerificationMode)Mockito.timeout((int)((int)TimeUnit.SECONDS.toMillis(3L))).times(1))).build((Path)Matchers.any(Path.class), (String)Matchers.any(String.class), (ProgressHandler)Matchers.any(ProgressHandler.class), (DockerClient.BuildParam[])Matchers.anyVararg());
    }

    @Test
    @RunWithProject(value="foo")
    public void shouldBuildDockerImageImmediatelyOnSecondCall() throws InterruptedException, DockerException, IOException {
        DockerClient client = MockDockerClientFactory.build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Test", client).withDefaultTCPConnectionSettings();
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection});
        SWTUtils.asyncExec(() -> {
            SWTBotMenu sWTBotMenu = this.getRunAsdockerImageBuildContextMenu("foo", "Dockerfile").click();
        });
        Assertions.assertThat((Object)this.bot.shell(WizardMessages.getString((String)"ImageBuildDialog.title"))).isNotNull();
        this.bot.textWithLabel(WizardMessages.getString((String)"ImageBuildDialog.repoNameLabel")).setText("foo/bar:latest");
        SWTUtils.syncExec(() -> this.bot.button("OK").click());
        ((DockerClient)Mockito.verify((Object)client, (VerificationMode)Mockito.timeout((int)((int)TimeUnit.SECONDS.toMillis(3L))).times(1))).build((Path)Matchers.any(Path.class), (String)Matchers.any(String.class), (ProgressHandler)Matchers.any(ProgressHandler.class), (DockerClient.BuildParam[])Matchers.anyVararg());
        SWTUtils.asyncExec(() -> {
            SWTBotMenu sWTBotMenu = this.getRunAsdockerImageBuildContextMenu("foo", "Dockerfile").click();
        });
        ((DockerClient)Mockito.verify((Object)client, (VerificationMode)Mockito.timeout((int)((int)TimeUnit.SECONDS.toMillis(3L))).times(2))).build((Path)Matchers.any(Path.class), (String)Matchers.any(String.class), (ProgressHandler)Matchers.any(ProgressHandler.class), (DockerClient.BuildParam[])Matchers.anyVararg());
    }

    @Test
    @RunWithProject(value="foo")
    public void shouldNotBuildDockerImageOnSecondCallWhenAllConnectionWereRemoved() throws InterruptedException, DockerException, IOException {
        DockerClient client = MockDockerClientFactory.build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Test", client).withDefaultTCPConnectionSettings();
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection});
        SWTUtils.asyncExec(() -> {
            SWTBotMenu sWTBotMenu = this.getRunAsdockerImageBuildContextMenu("foo", "Dockerfile").click();
        });
        Assertions.assertThat((Object)this.bot.shell(WizardMessages.getString((String)"ImageBuildDialog.title"))).isNotNull();
        this.bot.textWithLabel(WizardMessages.getString((String)"ImageBuildDialog.repoNameLabel")).setText("foo/bar:latest");
        SWTUtils.syncExec(() -> this.bot.button("OK").click());
        ((DockerClient)Mockito.verify((Object)client, (VerificationMode)Mockito.timeout((int)((int)TimeUnit.SECONDS.toMillis(30L))).times(1))).build((Path)Matchers.any(Path.class), (String)Matchers.any(String.class), (ProgressHandler)Matchers.any(ProgressHandler.class), (DockerClient.BuildParam[])Matchers.anyVararg());
        DockerConnectionManager.getInstance().removeConnection((IDockerConnection)dockerConnection);
        SWTUtils.asyncExec(() -> {
            SWTBotMenu sWTBotMenu = this.getRunAsdockerImageBuildContextMenu("foo", "Dockerfile").click();
        }, false);
        SWTBotShell shell = this.bot.shell("Edit Configuration");
        Assertions.assertThat((Object)shell).isNotNull();
        Assertions.assertThat((boolean)shell.bot().button("Run").isEnabled()).isFalse();
        SWTUtils.asyncExec(() -> shell.bot().button(IDialogConstants.CLOSE_LABEL).click(), false);
        SWTUtils.syncExec(() -> this.bot.button(IDialogConstants.NO_LABEL).click());
    }

    @RunWithProject(value="foo")
    public void shouldPromptForAnotherConnectionWhenBuildingDockerImageOnSecondCallAfterConnectionWasReplaced() throws InterruptedException, DockerException, IOException {
        DockerClient client = MockDockerClientFactory.build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Test", client).withDefaultTCPConnectionSettings();
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection});
        SWTUtils.asyncExec(() -> {
            SWTBotMenu sWTBotMenu = this.getRunAsdockerImageBuildContextMenu("foo", "Dockerfile").click();
        });
        Assertions.assertThat((Object)this.bot.shell(WizardMessages.getString((String)"ImageBuildDialog.title"))).isNotNull();
        this.bot.textWithLabel(WizardMessages.getString((String)"ImageBuildDialog.repoNameLabel")).setText("foo/bar:latest");
        SWTUtils.syncExec(() -> this.bot.button("OK").click());
        ((DockerClient)Mockito.verify((Object)client, (VerificationMode)Mockito.timeout((int)((int)TimeUnit.SECONDS.toMillis(3L))).times(1))).build((Path)Matchers.any(Path.class), (String)Matchers.any(String.class), (ProgressHandler)Matchers.any(ProgressHandler.class), (DockerClient.BuildParam[])Matchers.anyVararg());
        DockerConnection dockerConnection2 = MockDockerConnectionFactory.from("Test 2", client).withDefaultTCPConnectionSettings();
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection2});
        SWTUtils.asyncExec(() -> {
            SWTBotMenu sWTBotMenu = this.getRunAsdockerImageBuildContextMenu("foo", "Dockerfile").click();
        });
        Assertions.assertThat((Object)this.bot.shell(WizardMessages.getString((String)"ImageBuildDialog.title"))).isNotNull();
        this.bot.textWithLabel(WizardMessages.getString((String)"ImageBuildDialog.repoNameLabel")).setText("foo/bar:latest");
        SWTUtils.syncExec(() -> this.bot.button("OK").click());
        ((DockerClient)Mockito.verify((Object)client, (VerificationMode)Mockito.timeout((int)((int)TimeUnit.SECONDS.toMillis(3L))).times(2))).build((Path)Matchers.any(Path.class), (String)Matchers.any(String.class), (ProgressHandler)Matchers.any(ProgressHandler.class), (DockerClient.BuildParam[])Matchers.anyVararg());
    }

    @Test
    @RunWithProject(value="foo")
    public void shouldNotBuildDockerImageOnSecondCallWhenDockerfileWasRemoved() throws InterruptedException, DockerException, IOException, CoreException {
        DockerClient client = MockDockerClientFactory.build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Test", client).withDefaultTCPConnectionSettings();
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection});
        SWTUtils.asyncExec(() -> {
            SWTBotMenu sWTBotMenu = this.getRunAsdockerImageBuildContextMenu("foo", "Dockerfile").click();
        });
        Assertions.assertThat((Object)this.bot.shell(WizardMessages.getString((String)"ImageBuildDialog.title"))).isNotNull();
        this.bot.textWithLabel(WizardMessages.getString((String)"ImageBuildDialog.repoNameLabel")).setText("foo/bar:latest");
        SWTUtils.syncExec(() -> this.bot.button("OK").click());
        ((DockerClient)Mockito.verify((Object)client, (VerificationMode)Mockito.timeout((int)((int)TimeUnit.SECONDS.toMillis(30L))).times(1))).build((Path)Matchers.any(Path.class), (String)Matchers.any(String.class), (ProgressHandler)Matchers.any(ProgressHandler.class), (DockerClient.BuildParam[])Matchers.anyVararg());
        this.projectInit.getProject().findMember("Dockerfile").delete(true, (IProgressMonitor)new NullProgressMonitor());
        this.bot.toolbarDropDownButtonWithTooltip("Run").menuItem("1 foo_bar [latest]").click();
        SWTBotShell shell = this.bot.shell(JobMessages.getString((String)"BuildImageJob.title"));
        Assertions.assertThat((Object)shell).isNotNull();
        SWTUtils.syncExec(() -> shell.bot().button(IDialogConstants.OK_LABEL).click());
    }
}

