/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.launch;

import com.spotify.docker.client.DockerClient;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.linuxtools.docker.core.DockerConnectionManager;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.internal.docker.core.DockerCompose;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.core.ProcessLauncher;
import org.eclipse.linuxtools.internal.docker.ui.consoles.ConsoleMessages;
import org.eclipse.linuxtools.internal.docker.ui.launch.LaunchConfigurationUtils;
import org.eclipse.linuxtools.internal.docker.ui.launch.LaunchMessages;
import org.eclipse.linuxtools.internal.docker.ui.testutils.CustomMatchers;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockDockerClientFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockDockerConnectionFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.ProjectInitializationRule;
import org.eclipse.linuxtools.internal.docker.ui.testutils.RunWithProject;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.ButtonAssertions;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.ClearConnectionManagerRule;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.ClearLaunchConfigurationsRule;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.CloseShellRule;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.CloseWelcomePageRule;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.ComboAssertions;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.ConsoleViewRule;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.DockerConnectionManagerUtils;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.ProjectExplorerViewRule;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.SWTUtils;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.TextAssertions;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.ToolbarButtonAssertions;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotMenu;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotToolbarButton;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class DockerComposeSWTBotTest {
    @ClassRule
    public static CloseWelcomePageRule closeWelcomePage = new CloseWelcomePageRule("org.eclipse.linuxtools.docker.ui.perspective");
    @Rule
    public ClearConnectionManagerRule clearConnectionManager = new ClearConnectionManagerRule();
    @Rule
    public ProjectInitializationRule projectInit = new ProjectInitializationRule();
    @Rule
    public ClearLaunchConfigurationsRule clearLaunchConfig = new ClearLaunchConfigurationsRule("org.eclipse.linuxtools.docker.ui.dockerComposeUpLaunchConfigurationType");
    @Rule
    public CloseShellRule closeShell = new CloseShellRule(IDialogConstants.CLOSE_LABEL);
    @Rule
    public ConsoleViewRule consoleViewRule = new ConsoleViewRule();
    @Rule
    public ProjectExplorerViewRule projectExplorerViewRule = new ProjectExplorerViewRule();
    private SWTWorkbenchBot bot = new SWTWorkbenchBot();
    private CountDownLatch latch;

    @Before
    public void setupMockedProcessLauncher() throws DockerException, InterruptedException {
        ProcessLauncher mockProcessLauncher = (ProcessLauncher)Mockito.mock(ProcessLauncher.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        DockerCompose.getInstance().setProcessLauncher(mockProcessLauncher);
        this.setupDockerComposeUpMockProcess(mockProcessLauncher);
        this.setupDockerComposeStopMockProcess(mockProcessLauncher);
    }

    private void setupDockerComposeUpMockProcess(ProcessLauncher mockProcessLauncher) throws DockerException, InterruptedException {
        Process mockDockerComposeUpProcess = (Process)Mockito.mock(Process.class);
        Mockito.when((Object)mockDockerComposeUpProcess.getInputStream()).thenReturn((Object)new ByteArrayInputStream("up!\n".getBytes()));
        Mockito.when((Object)mockDockerComposeUpProcess.getErrorStream()).thenReturn((Object)new ByteArrayInputStream("".getBytes()));
        Mockito.when((Object)mockDockerComposeUpProcess.getOutputStream()).thenReturn((Object)new ByteArrayOutputStream());
        Mockito.when((Object)mockProcessLauncher.processBuilder(Matchers.anyString(), (String)Matchers.eq((Object)DockerCompose.getDockerComposeCommandName()), CustomMatchers.arrayContains("up")).workingDir(Matchers.anyString()).start()).thenReturn((Object)mockDockerComposeUpProcess);
        this.latch = new CountDownLatch(1);
        Mockito.when((Object)mockDockerComposeUpProcess.waitFor()).then((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                DockerComposeSWTBotTest.this.latch.await(5L, TimeUnit.SECONDS);
                return 0;
            }
        });
    }

    private void setupDockerComposeStopMockProcess(ProcessLauncher mockProcessLauncher) throws DockerException, InterruptedException {
        Process mockDockerComposeStopProcess = (Process)Mockito.mock(Process.class);
        Mockito.when((Object)mockDockerComposeStopProcess.getInputStream()).thenReturn((Object)new ByteArrayInputStream("stop\n".getBytes()));
        Mockito.when((Object)mockDockerComposeStopProcess.getErrorStream()).thenReturn((Object)new ByteArrayInputStream("".getBytes()));
        Mockito.when((Object)mockDockerComposeStopProcess.getOutputStream()).thenReturn((Object)new ByteArrayOutputStream());
        Mockito.when((Object)mockProcessLauncher.processBuilder(Matchers.anyString(), (String)Matchers.eq((Object)DockerCompose.getDockerComposeCommandName()), CustomMatchers.arrayContains("stop")).workingDir(Matchers.anyString()).start()).thenReturn((Object)mockDockerComposeStopProcess);
        Mockito.when((Object)mockDockerComposeStopProcess.waitFor()).then(invocation -> {
            this.latch.countDown();
            return 0;
        });
    }

    private SWTBotMenu getRunAsDockerComposeContextMenu(String projectName, String dockerComposeFileName) {
        SWTBotView projectExplorerBotView = this.projectExplorerViewRule.getProjectExplorerBotView();
        projectExplorerBotView.setFocus();
        SWTBotTreeItem fooProjectTreeItem = SWTUtils.getTreeItem(projectExplorerBotView, projectName);
        Assertions.assertThat((Object)fooProjectTreeItem).isNotNull();
        SWTUtils.syncExec(() -> fooProjectTreeItem.expand());
        SWTBotTreeItem dockerfileTreeItem = SWTUtils.getTreeItem(fooProjectTreeItem, dockerComposeFileName);
        Assertions.assertThat((Object)dockerfileTreeItem).isNotNull();
        SWTUtils.select(dockerfileTreeItem);
        SWTBotMenu runAsDockerComposeMenu = SWTUtils.getContextMenu(projectExplorerBotView.bot().tree(), "Run As", "1 Docker Compose");
        return runAsDockerComposeMenu;
    }

    @Test
    @RunWithProject(value="foo")
    public void shouldDisableCommandOnFirstCallWhenMissingConnection() {
        ClearConnectionManagerRule.removeAllConnections(DockerConnectionManager.getInstance());
        SWTUtils.asyncExec(() -> {
            SWTBotMenu sWTBotMenu = this.getRunAsDockerComposeContextMenu("foo", "docker-compose.yml").click();
        });
        Assertions.assertThat((Object)this.bot.shell(LaunchMessages.getString((String)"DockerComposeUpShortcut.no.connections.msg"))).isNotNull();
        SWTUtils.syncExec(() -> this.bot.button("No").click());
    }

    @Test
    @RunWithProject(value="foo")
    public void shouldStartDockerComposeFromScratch() throws CoreException {
        DockerClient client = MockDockerClientFactory.build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Test", client).withDefaultTCPConnectionSettings();
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection});
        SWTUtils.asyncExec(() -> {
            SWTBotMenu sWTBotMenu = this.getRunAsDockerComposeContextMenu("foo", "docker-compose.yml").click();
        });
        this.bot.button("OK").click();
        SWTUtils.waitForJobsToComplete();
        Assertions.assertThat((boolean)SWTUtils.isConsoleViewVisible(this.bot)).isTrue();
        SWTBotToolbarButton consoleToolbarStopButton = SWTUtils.getConsoleToolbarButtonWithTooltipText(this.bot, ConsoleMessages.getString((String)"DockerComposeStopAction.tooltip"));
        ToolbarButtonAssertions.assertThat(consoleToolbarStopButton).isEnabled();
        ILaunchConfiguration launchConfiguration = LaunchConfigurationUtils.getLaunchConfigurationByName((String)"org.eclipse.linuxtools.docker.ui.dockerComposeUpLaunchConfigurationType", (String)"Docker Compose [foo]");
        Assertions.assertThat((Object)launchConfiguration).isNotNull();
        Assertions.assertThat((long)this.latch.getCount()).isEqualTo(1L);
    }

    @Test
    @RunWithProject(value="foo")
    public void shouldStartDockerComposeWithExistingLaunchConfiguration() throws CoreException {
        DockerClient client = MockDockerClientFactory.build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Test", client).withDefaultTCPConnectionSettings();
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection});
        IFile dockerComposeScript = this.projectInit.getProject().getFile("docker-compose.yml");
        LaunchConfigurationUtils.createDockerComposeUpLaunchConfiguration((IDockerConnection)dockerConnection, (IResource)dockerComposeScript);
        SWTUtils.asyncExec(() -> {
            SWTBotMenu sWTBotMenu = this.getRunAsDockerComposeContextMenu("foo", "docker-compose.yml").click();
        });
        SWTBotToolbarButton consoleToolbarStopButton = SWTUtils.getConsoleToolbarButtonWithTooltipText(this.bot, ConsoleMessages.getString((String)"DockerComposeStopAction.tooltip"));
        ToolbarButtonAssertions.assertThat(consoleToolbarStopButton).isEnabled();
    }

    @Test
    @RunWithProject(value="foo")
    public void shouldStopDockerCompose() throws CoreException {
        this.shouldStartDockerComposeFromScratch();
        SWTBotToolbarButton consoleToolbarStopButton = SWTUtils.getConsoleToolbarButtonWithTooltipText(this.bot, ConsoleMessages.getString((String)"DockerComposeStopAction.tooltip"));
        ToolbarButtonAssertions.assertThat(consoleToolbarStopButton).isEnabled();
        consoleToolbarStopButton.click();
        Assertions.assertThat((long)this.latch.getCount()).isEqualTo(0L);
        ToolbarButtonAssertions.assertThat(consoleToolbarStopButton).isNotEnabled();
    }

    @Test
    @RunWithProject(value="foo")
    public void shouldRestartDockerCompose() throws InterruptedException, DockerException {
        DockerClient client = MockDockerClientFactory.build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Test", client).withDefaultTCPConnectionSettings();
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection});
        SWTUtils.asyncExec(() -> {
            SWTBotMenu sWTBotMenu = this.getRunAsDockerComposeContextMenu("foo", "docker-compose.yml").click();
        });
        this.bot.button("OK").click();
        SWTUtils.waitForJobsToComplete();
        SWTBotToolbarButton consoleToolbarStopButton = SWTUtils.getConsoleToolbarButtonWithTooltipText(this.bot, ConsoleMessages.getString((String)"DockerComposeStopAction.tooltip"));
        ToolbarButtonAssertions.assertThat(consoleToolbarStopButton).isEnabled();
        consoleToolbarStopButton.click();
        this.setupMockedProcessLauncher();
        SWTUtils.asyncExec(() -> {
            SWTBotMenu sWTBotMenu = this.getRunAsDockerComposeContextMenu("foo", "docker-compose.yml").click();
        });
        SWTUtils.waitForJobsToComplete();
        ToolbarButtonAssertions.assertThat(consoleToolbarStopButton).isEnabled();
    }

    @Test
    @RunWithProject(value="foo")
    @Ignore
    public void shouldValidateLaunchConfiguration() throws CoreException {
        DockerClient client = MockDockerClientFactory.build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Test", client).withDefaultTCPConnectionSettings();
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection});
        IFile dockerComposeScript = this.projectInit.getProject().getFile("docker-compose.yml");
        LaunchConfigurationUtils.createDockerComposeUpLaunchConfiguration((IDockerConnection)dockerConnection, (IResource)dockerComposeScript);
        this.bot.toolbarDropDownButtonWithTooltip("Run").menuItem("Run Configurations...").click();
        SWTBotTreeItem dockerComposeTreeItem = SWTUtils.expand(this.bot.tree(), "Docker Compose");
        SWTUtils.select(dockerComposeTreeItem, "Docker Compose [foo]");
        ((ComboAssertions)((Object)ComboAssertions.assertThat(this.bot.comboBox(0)).isEnabled())).itemSelected("Test");
        ((TextAssertions)((Object)TextAssertions.assertThat(this.bot.text(2)).isEnabled())).textEquals("/foo");
        ButtonAssertions.assertThat(this.bot.button("Run")).isEnabled();
    }
}

