/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.testutils;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.linuxtools.docker.core.IRegistryAccount;
import org.eclipse.linuxtools.internal.docker.core.RegistryAccountManager;
import org.eclipse.linuxtools.internal.docker.core.RegistryAccountStorageManager;
import org.mockito.Mockito;

public class MockRegistryAccountManagerFactory {
    public static MockRegistryAccountManagerBuilder registryAccount(IRegistryAccount registryAccount) {
        return new MockRegistryAccountManagerBuilder().registryAccount(registryAccount);
    }

    public static class MockRegistryAccountManagerBuilder {
        private final List<IRegistryAccount> registryAccounts = new ArrayList<IRegistryAccount>();

        public MockRegistryAccountManagerBuilder registryAccount(IRegistryAccount registryAccount) {
            this.registryAccounts.add(registryAccount);
            return this;
        }

        public RegistryAccountManager build() {
            RegistryAccountStorageManager mockRegistryAccountStorageManager = (RegistryAccountStorageManager)Mockito.mock(RegistryAccountStorageManager.class);
            Mockito.when((Object)mockRegistryAccountStorageManager.getAccounts()).thenReturn(this.registryAccounts);
            RegistryAccountManager registryAccountManager = RegistryAccountManager.getInstance();
            registryAccountManager.setStorageManager(mockRegistryAccountStorageManager);
            return registryAccountManager;
        }
    }
}

