/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.testutils.swt;

import org.assertj.core.api.AbstractAssert;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.linuxtools.docker.core.IDockerImageHierarchyNode;
import org.eclipse.linuxtools.internal.docker.ui.views.DockerImageHierarchyView;
import org.hamcrest.Matchers;

public class DockerImageHierarchyViewAssertions
extends AbstractAssert<DockerImageHierarchyViewAssertions, DockerImageHierarchyView> {
    protected DockerImageHierarchyViewAssertions(DockerImageHierarchyView actual) {
        super((Object)actual, DockerImageHierarchyViewAssertions.class);
    }

    public static DockerImageHierarchyViewAssertions assertThat(DockerImageHierarchyView actual) {
        return new DockerImageHierarchyViewAssertions(actual);
    }

    public DockerImageHierarchyViewAssertions isEmpty() {
        Matchers.notNullValue();
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (((DockerImageHierarchyView)this.actual).isShowingConnectionsPane()) {
            this.failWithMessage("Expected Docker Explorer View to show the explanation pane but it did not", new Object[0]);
        }
        return this;
    }

    public DockerImageHierarchyViewAssertions isNotEmpty() {
        Matchers.notNullValue();
        if (!((DockerImageHierarchyView)this.actual).isShowingConnectionsPane()) {
            this.failWithMessage("Expected Docker Explorer View to show the connections pane but it did not", new Object[0]);
        }
        return this;
    }

    public void hasSelectedElement(IDockerImage expectedSelection) {
        Object selectedElement;
        Matchers.notNullValue();
        IStructuredSelection selection = (IStructuredSelection)((DockerImageHierarchyView)this.actual).getCommonViewer().getSelection();
        if (selection.size() != 1) {
            this.failWithMessage("Expected Docker Image Hierarchy view to have <%s> selected elements, but there was <%s>", new Object[]{1, selection.size()});
        }
        if ((selectedElement = ((IDockerImageHierarchyNode)selection.getFirstElement()).getElement()) instanceof IDockerImage) {
            IDockerImage selectedImage = (IDockerImage)selectedElement;
            if (!selectedImage.id().equals(expectedSelection.id())) {
                this.failWithMessage("Expected Docker Image Hierarchy view to have a Docker images with id <%s> as the selected element, but it was <%s>", new Object[]{expectedSelection.id(), ((IDockerImage)selectedElement).id()});
            }
        } else {
            this.failWithMessage("Expected Docker Image Hierarchy view to have a Docker Image as the selected element, but it was a <%s>", new Object[]{selectedElement.getClass()});
        }
    }

    public void hasSelectedElement(Object expectedSelection) {
        Object selectedElement;
        Matchers.notNullValue();
        IStructuredSelection selection = (IStructuredSelection)((DockerImageHierarchyView)this.actual).getCommonViewer().getSelection();
        if (selection.size() != 1) {
            this.failWithMessage("Expected Docker Image Hierarchy view to have <%s> selected elements, but there was <%s>", new Object[]{1, selection.size()});
        }
        if (!(selectedElement = ((IDockerImageHierarchyNode)selection.getFirstElement()).getElement()).equals(expectedSelection)) {
            this.failWithMessage("Expected Docker Image Hierarchy view to have <%s> as the selected element, but it was <%s>", new Object[]{expectedSelection, selectedElement});
        }
    }
}

