/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.wizards;

import com.spotify.docker.client.DockerClient;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.linuxtools.docker.core.DockerConnectionManager;
import org.eclipse.linuxtools.docker.core.EnumDockerConnectionState;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerConnectionStorageManager;
import org.eclipse.linuxtools.docker.core.IDockerContainerConfig;
import org.eclipse.linuxtools.docker.core.IDockerHostConfig;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.core.DockerContainerConfig;
import org.eclipse.linuxtools.internal.docker.core.TCPConnectionSettings;
import org.eclipse.linuxtools.internal.docker.core.UnixSocketConnectionSettings;
import org.eclipse.linuxtools.internal.docker.ui.launch.LaunchConfigurationUtils;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockDockerClientFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockDockerConnectionFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockDockerConnectionStorageManagerFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockDockerContainerConfigFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockDockerHostConfigFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockDockerImageFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.ButtonAssertions;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.CheckBoxAssertions;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.CloseShellRule;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.CloseWelcomePageRule;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.DockerConnectionManagerUtils;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.RadioAssertion;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.SWTBotViewRule;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.SWTUtils;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.TextAssertions;
import org.eclipse.linuxtools.internal.docker.ui.views.DockerContainersView;
import org.eclipse.linuxtools.internal.docker.ui.views.DockerImagesView;
import org.eclipse.linuxtools.internal.docker.ui.wizards.WizardMessages;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotButton;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class EditDockerConnectionSWTBotTest {
    private SWTWorkbenchBot bot = new SWTWorkbenchBot();
    private static String PATH_TO_CERTS = System.getProperty("java.io.tmpdir");
    @ClassRule
    public static CloseWelcomePageRule closeWelcomePage = new CloseWelcomePageRule("org.eclipse.linuxtools.docker.ui.perspective");
    @Rule
    public CloseShellRule closeShell = new CloseShellRule(IDialogConstants.CANCEL_LABEL);
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();
    @Rule
    public SWTBotViewRule dockerExplorer = new SWTBotViewRule("org.eclipse.linuxtools.docker.ui.dockerExplorerView");
    @Rule
    public SWTBotViewRule dockerImages = new SWTBotViewRule("org.eclipse.linuxtools.docker.ui.dockerImagesView");
    @Rule
    public SWTBotViewRule dockerContainers = new SWTBotViewRule("org.eclipse.linuxtools.docker.ui.dockerContainersView");

    @Before
    public void setFocusOnDockerExplorerView() {
        this.dockerExplorer.bot().setFocus();
    }

    private IDockerConnection configureUnixSocketConnection() {
        return this.configureUnixSocketConnection("Test");
    }

    private IDockerConnection configureUnixSocketConnection(String connectionName) {
        DockerClient client = MockDockerClientFactory.build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from(connectionName, client).withUnixSocketConnectionSettings("/var/run/docker.sock");
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection});
        return dockerConnection;
    }

    private IDockerConnection configureTCPConnection() {
        return this.configureTCPConnection("Test");
    }

    private IDockerConnection configureTCPConnection(String connectionName) {
        DockerClient client = MockDockerClientFactory.build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from(connectionName, client).withTCPConnectionSettings("https://foo:1234", PATH_TO_CERTS);
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection});
        return dockerConnection;
    }

    private void openConnectionEditionWizard(String elementName) {
        SWTBotTreeItem connectionItem = SWTUtils.getTreeItem(this.dockerExplorer.bot(), elementName);
        SWTBotTree dockerExplorerViewTreeBot = this.dockerExplorer.bot().bot().tree();
        dockerExplorerViewTreeBot.select(new SWTBotTreeItem[]{connectionItem});
        dockerExplorerViewTreeBot.contextMenu(WizardMessages.getString((String)"ImageRunSelectionPage.editButton")).click();
    }

    private SWTBotButton getFinishButton() {
        return this.bot.button("Finish");
    }

    private String configureRunImageLaunchConfiguration(IDockerConnection connection, String networkMode) {
        IDockerImage image = MockDockerImageFactory.name("images", new String[0]).connection(connection).build();
        DockerContainerConfig containerConfig = MockDockerContainerConfigFactory.cmd("cmd").build();
        IDockerHostConfig hostConfig = MockDockerHostConfigFactory.publishAllPorts(true).networkMode(networkMode).build();
        ILaunchConfiguration runImageLaunchConfiguration = LaunchConfigurationUtils.createRunImageLaunchConfiguration((IDockerImage)image, (IDockerContainerConfig)containerConfig, (IDockerHostConfig)hostConfig, (String)"some_container", (boolean)false);
        return runImageLaunchConfiguration.getName();
    }

    private String configureBuildImageLaunchConfiguration(IDockerConnection connection) throws CoreException {
        IResource mockDockerFile = (IResource)Mockito.mock(IResource.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        IPath mockDockerFilePath = (IPath)Mockito.mock(IPath.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)mockDockerFile.getFullPath()).thenReturn((Object)mockDockerFilePath);
        Mockito.when((Object)mockDockerFilePath.removeLastSegments(Matchers.anyInt())).thenReturn((Object)mockDockerFilePath);
        Mockito.when((Object)mockDockerFilePath.toString()).thenReturn((Object)"/path/to/dockerfile");
        ILaunchConfiguration buildImageLaunchConfiguration = LaunchConfigurationUtils.createBuildImageLaunchConfiguration((IDockerConnection)connection, (String)"foo/bar:latest", (IResource)mockDockerFile);
        return buildImageLaunchConfiguration.getName();
    }

    @Test
    public void shouldShowUnixSocketConnectionSettingsWithValidConnectionAvailable() {
        this.configureUnixSocketConnection();
        this.openConnectionEditionWizard("Test");
        ((TextAssertions)((Object)TextAssertions.assertThat(this.bot.text(0)).isEnabled())).textEquals("Test");
        ((RadioAssertion)((Object)RadioAssertion.assertThat(this.bot.radio(0)).isEnabled())).isSelected();
        ((TextAssertions)((Object)TextAssertions.assertThat(this.bot.text(1)).isEnabled())).textEquals("unix:///var/run/docker.sock");
        ((RadioAssertion)((Object)RadioAssertion.assertThat(this.bot.radio(1)).isEnabled())).isNotSelected();
        ((TextAssertions)((Object)TextAssertions.assertThat(this.bot.text(2)).isNotEnabled())).isEmpty();
        ((CheckBoxAssertions)((Object)CheckBoxAssertions.assertThat(this.bot.checkBox(0)).isNotEnabled())).isNotChecked();
        ((TextAssertions)((Object)TextAssertions.assertThat(this.bot.text(3)).isNotEnabled())).isEmpty();
    }

    @Test
    public void shouldUpdateUnixSocketConnectionSettingsWithValidConnectionAvailable() {
        this.configureTCPConnection();
        this.openConnectionEditionWizard("Test");
        this.bot.text(0).setText("foo");
        this.bot.radio(1).click();
        this.bot.text(2).setText("http://foo:1234");
        this.bot.checkBox(0).select();
        this.bot.text(3).setText(PATH_TO_CERTS);
        this.getFinishButton().click();
        IDockerConnection fooConnection = DockerConnectionManager.getInstance().findConnection("foo");
        Assertions.assertThat((Object)fooConnection).isNotNull();
        Assertions.assertThat((String)fooConnection.getName()).isEqualTo((Object)"foo");
        Assertions.assertThat((Object)fooConnection.getSettings()).isInstanceOf(TCPConnectionSettings.class);
        TCPConnectionSettings connectionSettings = (TCPConnectionSettings)fooConnection.getSettings();
        Assertions.assertThat((String)connectionSettings.getHost()).isEqualTo((Object)"https://foo:1234");
        Assertions.assertThat((boolean)connectionSettings.isTlsVerify()).isEqualTo(true);
        Assertions.assertThat((String)connectionSettings.getPathToCertificates()).isEqualTo((Object)PATH_TO_CERTS);
    }

    @Test
    public void shouldUpdateTCPConnectionSettingsWithValidConnectionAvailable() {
        this.configureTCPConnection();
        this.openConnectionEditionWizard("Test");
        this.bot.text(0).setText("foo");
        this.bot.radio(0).click();
        this.bot.text(1).setText("/var/run/docker.sock");
        this.getFinishButton().click();
        IDockerConnection fooConnection = DockerConnectionManager.getInstance().findConnection("foo");
        Assertions.assertThat((Object)fooConnection).isNotNull();
        Assertions.assertThat((String)fooConnection.getName()).isEqualTo((Object)"foo");
        Assertions.assertThat((Object)fooConnection.getSettings()).isInstanceOf(UnixSocketConnectionSettings.class);
        UnixSocketConnectionSettings connectionSettings = (UnixSocketConnectionSettings)fooConnection.getSettings();
        Assertions.assertThat((String)connectionSettings.getPath()).isEqualTo((Object)"unix:///var/run/docker.sock");
    }

    @Test
    public void shouldReportProblemWhenMissingName() {
        this.configureUnixSocketConnection();
        this.openConnectionEditionWizard("Test");
        ButtonAssertions.assertThat(this.getFinishButton()).isEnabled();
        this.bot.text(0).setText("");
        ButtonAssertions.assertThat(this.getFinishButton()).isNotEnabled();
    }

    @Test
    public void shouldReportProblemWhenMissingUnixSocketPath() {
        this.configureUnixSocketConnection();
        this.openConnectionEditionWizard("Test");
        ButtonAssertions.assertThat(this.getFinishButton()).isEnabled();
        this.bot.text(1).setText("");
        ButtonAssertions.assertThat(this.getFinishButton()).isNotEnabled();
    }

    @Test
    public void shouldReportProblemWhenInvalidUnixSocketPath() {
        this.configureUnixSocketConnection();
        this.openConnectionEditionWizard("Test");
        ButtonAssertions.assertThat(this.getFinishButton()).isEnabled();
        this.bot.text(1).setText("/invalid/path");
        ButtonAssertions.assertThat(this.getFinishButton()).isNotEnabled();
    }

    @Test
    public void shouldReportProblemWhenMissingHost() {
        this.configureTCPConnection();
        this.openConnectionEditionWizard("Test");
        ButtonAssertions.assertThat(this.getFinishButton()).isEnabled();
        this.bot.text(2).setText("");
        ButtonAssertions.assertThat(this.getFinishButton()).isNotEnabled();
    }

    @Test
    public void shouldReportProblemWhenInvalidHostMissingScheme() {
        this.configureTCPConnection();
        this.openConnectionEditionWizard("Test");
        ButtonAssertions.assertThat(this.getFinishButton()).isEnabled();
        this.bot.text(2).setText("foo");
        ButtonAssertions.assertThat(this.getFinishButton()).isNotEnabled();
    }

    @Test
    public void shouldReportProblemWhenInvalidHostInvalidScheme() {
        this.configureTCPConnection();
        this.openConnectionEditionWizard("Test");
        ButtonAssertions.assertThat(this.getFinishButton()).isEnabled();
        this.bot.text(2).setText("ftp://foo");
        ButtonAssertions.assertThat(this.getFinishButton()).isNotEnabled();
    }

    @Test
    public void shouldReportProblemWhenInvalidHostMissingPort() {
        this.configureTCPConnection();
        this.openConnectionEditionWizard("Test");
        ButtonAssertions.assertThat(this.getFinishButton()).isEnabled();
        this.bot.text(2).setText("http://foo");
        ButtonAssertions.assertThat(this.getFinishButton()).isNotEnabled();
    }

    @Test
    public void shouldReportProblemWhenMissingPathToCerts() {
        this.configureTCPConnection();
        this.openConnectionEditionWizard("Test");
        ButtonAssertions.assertThat(this.getFinishButton()).isEnabled();
        this.bot.text(3).setText("");
        ButtonAssertions.assertThat(this.getFinishButton()).isNotEnabled();
    }

    @Test
    public void shouldReportProblemWhenInvalidPathToCerts() {
        this.configureTCPConnection();
        this.openConnectionEditionWizard("Test");
        ButtonAssertions.assertThat(this.getFinishButton()).isEnabled();
        this.bot.text(3).setText("/invalid/path");
        ButtonAssertions.assertThat(this.getFinishButton()).isNotEnabled();
    }

    @Test
    public void shouldUpdateLaunchConfigurationWhenConnectionNameChanged() throws CoreException {
        IDockerConnection connection = this.configureTCPConnection("Test");
        String buildImageLaunchConfigurationName = this.configureBuildImageLaunchConfiguration(connection);
        ILaunchConfiguration buildDockerImageLaunchConfig = LaunchConfigurationUtils.getLaunchConfigurationByName((String)"org.eclipse.linuxtools.docker.ui.buildDockerImageLaunchConfigurationType", (String)buildImageLaunchConfigurationName);
        Assertions.assertThat((Object)buildDockerImageLaunchConfig).isNotNull();
        Assertions.assertThat((String)buildDockerImageLaunchConfig.getAttribute("dockerConnection", "")).isEqualTo((Object)"Test");
        String runImageLaunchConfigurationName = this.configureRunImageLaunchConfiguration(connection, "bridge");
        ILaunchConfiguration runDockerImageLaunchConfig = LaunchConfigurationUtils.getLaunchConfigurationByName((String)"org.eclipse.linuxtools.docker.ui.runDockerImageLaunchConfigurationType", (String)runImageLaunchConfigurationName);
        Assertions.assertThat((Object)runDockerImageLaunchConfig).isNotNull();
        Assertions.assertThat((String)runDockerImageLaunchConfig.getAttribute("connectionName", "")).isEqualTo((Object)"Test");
        Assertions.assertThat((String)runDockerImageLaunchConfig.getAttribute("networkMode", "")).isEqualTo((Object)"bridge");
        this.openConnectionEditionWizard("Test");
        this.bot.text(0).setText("foo");
        this.getFinishButton().click();
        ILaunchConfiguration updatedBuildDockerImageLaunchConfig = LaunchConfigurationUtils.getLaunchConfigurationByName((String)"org.eclipse.linuxtools.docker.ui.buildDockerImageLaunchConfigurationType", (String)buildImageLaunchConfigurationName);
        Assertions.assertThat((Object)updatedBuildDockerImageLaunchConfig).isNotNull();
        Assertions.assertThat((String)updatedBuildDockerImageLaunchConfig.getAttribute("dockerConnection", "")).isEqualTo((Object)"foo");
        ILaunchConfiguration updatedRunDockerImageLaunchConfig = LaunchConfigurationUtils.getLaunchConfigurationByName((String)"org.eclipse.linuxtools.docker.ui.runDockerImageLaunchConfigurationType", (String)runImageLaunchConfigurationName);
        Assertions.assertThat((Object)updatedRunDockerImageLaunchConfig).isNotNull();
        Assertions.assertThat((String)updatedRunDockerImageLaunchConfig.getAttribute("connectionName", "")).isEqualTo((Object)"foo");
        Assertions.assertThat((String)updatedRunDockerImageLaunchConfig.getAttribute("networkMode", "")).isEqualTo((Object)"bridge");
    }

    @Test
    public void shouldRefreshDockerExplorerViewWhenConnectionNameChanged() {
        IDockerConnection connection = this.configureTCPConnection("Test");
        SWTBotTreeItem connectionTreeItem = SWTUtils.getTreeItem(this.dockerExplorer.bot(), "Test");
        Assertions.assertThat((Object)connectionTreeItem).isNotNull();
        this.openConnectionEditionWizard("Test");
        this.bot.text(0).setText("foo");
        this.getFinishButton().click();
        SWTUtils.wait(2, TimeUnit.SECONDS);
        SWTBotTreeItem updatedConnectionTreeItem = SWTUtils.getTreeItem(this.dockerExplorer.bot(), "foo");
        Assertions.assertThat((Object)updatedConnectionTreeItem).isNotNull();
    }

    @Test
    public void shouldRefreshDockerImagesViewWhenConnectionNameChanges() {
        this.configureTCPConnection("Test");
        SWTBotTreeItem connectionTreeItem = SWTUtils.getTreeItem(this.dockerExplorer.bot(), "Test");
        Assertions.assertThat((Object)connectionTreeItem).isNotNull();
        this.openConnectionEditionWizard("Test");
        this.bot.text(0).setText("foo");
        this.getFinishButton().click();
        SWTUtils.wait(2, TimeUnit.SECONDS);
        DockerImagesView dockerImagesView = (DockerImagesView)this.dockerImages.view();
        String formTitle = SWTUtils.syncExec(() -> dockerImagesView.getFormTitle());
        Assertions.assertThat((String)formTitle).contains(new CharSequence[]{"foo"});
    }

    @Test
    public void shouldRefreshDockerContainersViewWhenConnectionNameChanges() {
        this.configureTCPConnection("Test");
        SWTBotTreeItem connectionTreeItem = SWTUtils.getTreeItem(this.dockerExplorer.bot(), "Test");
        Assertions.assertThat((Object)connectionTreeItem).isNotNull();
        this.openConnectionEditionWizard("Test");
        this.bot.text(0).setText("foo");
        this.getFinishButton().click();
        SWTUtils.wait(2, TimeUnit.SECONDS);
        DockerContainersView dockerContainersView = (DockerContainersView)this.dockerContainers.view();
        String formTitle = SWTUtils.syncExec(() -> dockerContainersView.getFormTitle());
        Assertions.assertThat((String)formTitle).contains(new CharSequence[]{"foo"});
    }

    @Test
    public void shouldRefreshDockerExplorerViewWhenNameChangedTwice() {
        this.configureTCPConnection("Test");
        SWTBotTreeItem connectionTreeItem = SWTUtils.getTreeItem(this.dockerExplorer.bot(), "Test");
        Assertions.assertThat((Object)connectionTreeItem).isNotNull();
        this.openConnectionEditionWizard("Test");
        this.bot.text(0).setText("foo");
        this.getFinishButton().click();
        SWTUtils.wait(2, TimeUnit.SECONDS);
        this.openConnectionEditionWizard("foo");
        this.bot.text(0).setText("bar");
        this.getFinishButton().click();
        SWTUtils.wait(2, TimeUnit.SECONDS);
        SWTBotTreeItem updatedConnectionTreeItem = SWTUtils.getTreeItem(this.dockerExplorer.bot(), "bar");
        Assertions.assertThat((Object)updatedConnectionTreeItem).isNotNull();
    }

    @Test
    public void shouldRefreshDockerExplorerViewWhenUnixSockerConnectionSettingsChanged() throws IOException {
        this.dockerContainers.close();
        this.dockerImages.close();
        IDockerConnection connection = this.configureUnixSocketConnection("Test");
        SWTBotTreeItem connectionTreeItem = SWTUtils.getTreeItem(this.dockerExplorer.bot(), "Test");
        Assertions.assertThat((Object)connectionTreeItem).isNotNull();
        File tmpDockerSocketFile = this.folder.newFile("docker.sock");
        this.openConnectionEditionWizard("Test");
        this.bot.text(1).setText(tmpDockerSocketFile.getAbsolutePath());
        this.getFinishButton().click();
        SWTUtils.wait(2, TimeUnit.SECONDS);
        SWTBotTreeItem updatedConnectionTreeItem = SWTUtils.getTreeItem(this.dockerExplorer.bot(), "Test");
        Assertions.assertThat((Object)updatedConnectionTreeItem).isNotNull();
        Assertions.assertThat((String)updatedConnectionTreeItem.getText()).contains(new CharSequence[]{tmpDockerSocketFile.getAbsolutePath()});
        ((IDockerConnection)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)0))).getContainers(true);
        ((IDockerConnection)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)0))).getImages(true);
    }

    @Test
    public void shouldRefreshDockerExplorerViewWhenTCPConnectionSettingsChanged() {
        this.dockerContainers.close();
        this.dockerImages.close();
        IDockerConnection connection = this.configureTCPConnection("Test");
        SWTBotTreeItem connectionTreeItem = SWTUtils.getTreeItem(this.dockerExplorer.bot(), "Test");
        Assertions.assertThat((Object)connectionTreeItem).isNotNull();
        this.openConnectionEditionWizard("Test");
        this.bot.text(2).setText("https://foo.bar:1234");
        this.getFinishButton().click();
        SWTUtils.wait(2, TimeUnit.SECONDS);
        SWTBotTreeItem updatedConnectionTreeItem = SWTUtils.getTreeItem(this.dockerExplorer.bot(), "Test");
        Assertions.assertThat((Object)updatedConnectionTreeItem).isNotNull();
        Assertions.assertThat((String)updatedConnectionTreeItem.getText()).contains(new CharSequence[]{"https://foo.bar:1234"});
        ((IDockerConnection)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)0))).getContainers(true);
        ((IDockerConnection)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)0))).getImages(true);
    }

    @Test
    public void shouldSaveConnectionWhenNameChanged() {
        IDockerConnection connection = this.configureTCPConnection("Test");
        IDockerConnectionStorageManager connectionStorageManager = MockDockerConnectionStorageManagerFactory.providing(connection);
        DockerConnectionManagerUtils.configureConnectionManager(connectionStorageManager);
        SWTBotTreeItem connectionTreeItem = SWTUtils.getTreeItem(this.dockerExplorer.bot(), "Test");
        Assertions.assertThat((Object)connectionTreeItem).isNotNull();
        Mockito.reset((Object[])new IDockerConnectionStorageManager[]{connectionStorageManager});
        this.openConnectionEditionWizard("Test");
        this.bot.text(0).setText("foo");
        this.getFinishButton().click();
        IDockerConnection foundConnection = DockerConnectionManager.getInstance().findConnection("foo");
        Assertions.assertThat((Object)foundConnection).isNotNull();
        ((IDockerConnectionStorageManager)Mockito.verify((Object)connectionStorageManager)).saveConnections(Matchers.anyList());
    }

    @Test
    public void shouldSaveConnectionWhenUnixSocketConnectionSettingsChanged() throws IOException {
        IDockerConnection connection = this.configureUnixSocketConnection("Test");
        IDockerConnectionStorageManager connectionStorageManager = MockDockerConnectionStorageManagerFactory.providing(connection);
        DockerConnectionManagerUtils.configureConnectionManager(connectionStorageManager);
        SWTBotTreeItem connectionTreeItem = SWTUtils.getTreeItem(this.dockerExplorer.bot(), "Test");
        Assertions.assertThat((Object)connectionTreeItem).isNotNull();
        File tmpDockerSocketFile = this.folder.newFile("docker.sock");
        Mockito.reset((Object[])new IDockerConnectionStorageManager[]{connectionStorageManager});
        this.openConnectionEditionWizard("Test");
        this.bot.text(1).setText(tmpDockerSocketFile.getAbsolutePath());
        this.getFinishButton().click();
        IDockerConnection foundConnection = DockerConnectionManager.getInstance().findConnection("Test");
        Assertions.assertThat((Object)foundConnection).isNotNull();
        ((AbstractObjectAssert)Assertions.assertThat((Object)foundConnection.getSettings()).isNotNull()).isEqualTo((Object)new UnixSocketConnectionSettings(tmpDockerSocketFile.getAbsolutePath()));
        ((IDockerConnectionStorageManager)Mockito.verify((Object)connectionStorageManager)).saveConnections(Matchers.anyList());
    }

    @Test
    public void shouldSaveConnectionWhenTCPConnectionSettingsChanged() {
        IDockerConnection connection = this.configureTCPConnection("Test");
        IDockerConnectionStorageManager connectionStorageManager = MockDockerConnectionStorageManagerFactory.providing(connection);
        DockerConnectionManagerUtils.configureConnectionManager(connectionStorageManager);
        SWTBotTreeItem connectionTreeItem = SWTUtils.getTreeItem(this.dockerExplorer.bot(), "Test");
        Assertions.assertThat((Object)connectionTreeItem).isNotNull();
        Mockito.reset((Object[])new IDockerConnectionStorageManager[]{connectionStorageManager});
        this.openConnectionEditionWizard("Test");
        this.bot.text(2).setText("https://foo.bar:1234");
        this.getFinishButton().click();
        IDockerConnection foundConnection = DockerConnectionManager.getInstance().findConnection("Test");
        Assertions.assertThat((Object)foundConnection).isNotNull();
        ((AbstractObjectAssert)Assertions.assertThat((Object)foundConnection.getSettings()).isNotNull()).isEqualTo((Object)new TCPConnectionSettings("https://foo.bar:1234", PATH_TO_CERTS));
        ((IDockerConnectionStorageManager)Mockito.verify((Object)connectionStorageManager)).saveConnections(Matchers.anyList());
    }

    @Test
    public void shouldSaveConnectionWhenNameAndTCPConnectionSettingsChanged() {
        IDockerConnection connection = this.configureTCPConnection("Test");
        IDockerConnectionStorageManager connectionStorageManager = MockDockerConnectionStorageManagerFactory.providing(connection);
        DockerConnectionManagerUtils.configureConnectionManager(connectionStorageManager);
        SWTBotTreeItem connectionTreeItem = SWTUtils.getTreeItem(this.dockerExplorer.bot(), "Test");
        Assertions.assertThat((Object)connectionTreeItem).isNotNull();
        Mockito.reset((Object[])new IDockerConnectionStorageManager[]{connectionStorageManager});
        this.openConnectionEditionWizard("Test");
        this.bot.text(0).setText("foo");
        this.bot.text(2).setText("https://foo.bar:1234");
        this.getFinishButton().click();
        IDockerConnection foundConnection = DockerConnectionManager.getInstance().findConnection("foo");
        Assertions.assertThat((Object)foundConnection).isNotNull();
        ((AbstractObjectAssert)Assertions.assertThat((Object)foundConnection.getSettings()).isNotNull()).isEqualTo((Object)new TCPConnectionSettings("https://foo.bar:1234", PATH_TO_CERTS));
        ((IDockerConnectionStorageManager)Mockito.verify((Object)connectionStorageManager)).saveConnections(Matchers.anyList());
    }

    @Test
    public void shouldResetConnectionStateWhenUnixConnectionSettingsChanged() throws IOException {
        this.dockerContainers.close();
        this.dockerImages.close();
        IDockerConnection connection = this.configureUnixSocketConnection("Test");
        IDockerConnectionStorageManager connectionStorageManager = MockDockerConnectionStorageManagerFactory.providing(connection);
        DockerConnectionManagerUtils.configureConnectionManager(connectionStorageManager);
        SWTBotTreeItem connectionTreeItem = SWTUtils.getTreeItem(this.dockerExplorer.bot(), "Test");
        Assertions.assertThat((Object)connectionTreeItem).isNotNull();
        File tmpDockerSocketFile = this.folder.newFile("docker.sock");
        Assertions.assertThat((Comparable)connection.getState()).isEqualTo((Object)EnumDockerConnectionState.UNKNOWN);
        this.openConnectionEditionWizard("Test");
        this.bot.text(1).setText(tmpDockerSocketFile.getAbsolutePath());
        this.getFinishButton().click();
        IDockerConnection foundConnection = DockerConnectionManager.getInstance().findConnection("Test");
        Assertions.assertThat((Object)foundConnection).isNotNull();
        ((AbstractObjectAssert)Assertions.assertThat((Object)foundConnection.getSettings()).isNotNull()).isEqualTo((Object)new UnixSocketConnectionSettings(tmpDockerSocketFile.getAbsolutePath()));
        Assertions.assertThat((Comparable)foundConnection.getState()).isEqualTo((Object)EnumDockerConnectionState.UNKNOWN);
    }

    @Test
    public void shouldResetConnectionStateWhenTCPConnectionSettingsChanged() {
        this.dockerContainers.close();
        this.dockerImages.close();
        IDockerConnection connection = this.configureTCPConnection("Test");
        IDockerConnectionStorageManager connectionStorageManager = MockDockerConnectionStorageManagerFactory.providing(connection);
        DockerConnectionManagerUtils.configureConnectionManager(connectionStorageManager);
        SWTBotTreeItem connectionTreeItem = SWTUtils.getTreeItem(this.dockerExplorer.bot(), "Test");
        Assertions.assertThat((Object)connectionTreeItem).isNotNull();
        this.openConnectionEditionWizard("Test");
        this.bot.text(2).setText("https://foo.bar:1234");
        this.getFinishButton().click();
        IDockerConnection foundConnection = DockerConnectionManager.getInstance().findConnection("Test");
        Assertions.assertThat((Object)foundConnection).isNotNull();
        ((AbstractObjectAssert)Assertions.assertThat((Object)foundConnection.getSettings()).isNotNull()).isEqualTo((Object)new TCPConnectionSettings("https://foo.bar:1234", PATH_TO_CERTS));
        Assertions.assertThat((Comparable)foundConnection.getState()).isEqualTo((Object)EnumDockerConnectionState.UNKNOWN);
    }
}

