/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.wizards;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ImageNameValidator;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ImageNameValidatorTest {
    @Parameterized.Parameter(value=0)
    public String imageName;
    @Parameterized.Parameter(value=1)
    public int expectedSeverity;

    private static Object[] match(String imageName, int expectedSeverity) {
        return new Object[]{imageName, expectedSeverity};
    }

    @Parameterized.Parameters(name="{0} -> {1}")
    public static Object[][] data() {
        return new Object[][]{ImageNameValidatorTest.match("", 8), ImageNameValidatorTest.match("\u00a3", 2), ImageNameValidatorTest.match("wildfly", 2), ImageNameValidatorTest.match("jboss/", 2), ImageNameValidatorTest.match("jboss/wildfly", 2), ImageNameValidatorTest.match("jboss/wildfly:", 2), ImageNameValidatorTest.match("jboss/wildfly:latest", 0), ImageNameValidatorTest.match("localhost/wildfly/", 2), ImageNameValidatorTest.match("localhost/jboss/wildfly", 2), ImageNameValidatorTest.match("localhost/jboss/wildfly:", 2), ImageNameValidatorTest.match("localhost/jboss/wildfly:latest", 0), ImageNameValidatorTest.match("localhost/jboss/wildfly:9", 0), ImageNameValidatorTest.match("localhost/jboss/wildfly:9.", 2), ImageNameValidatorTest.match("localhost/jboss/wildfly:9.0.1.", 2), ImageNameValidatorTest.match("localhost/jboss/wildfly:9.0.1.Final", 0), ImageNameValidatorTest.match("localhost:", 2), ImageNameValidatorTest.match("localhost:5000", 0), ImageNameValidatorTest.match("localhost:5000/", 2), ImageNameValidatorTest.match("localhost:5000/jboss/wildfly", 2), ImageNameValidatorTest.match("localhost:5000/jboss/wildfly/", 2), ImageNameValidatorTest.match("localhost:5000/jboss/wildfly", 2), ImageNameValidatorTest.match("localhost:5000/jboss/wildfly:", 2), ImageNameValidatorTest.match("localhost:5000/jboss/wildfly:latest", 0)};
    }

    @Test
    public void verifyData() {
        IStatus status = new ImageNameValidator().validate((Object)this.imageName);
        Assert.assertEquals((long)this.expectedSeverity, (long)status.getSeverity());
    }
}

