/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.wizards;

import com.spotify.docker.client.DockerClient;
import org.assertj.core.api.Assertions;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockDockerClientFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockDockerConnectionFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockImageSearchResultFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.ClearConnectionManagerRule;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.CloseShellRule;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.CloseWelcomePageRule;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.DockerConnectionManagerUtils;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.SWTUtils;
import org.eclipse.linuxtools.internal.docker.ui.views.DockerExplorerView;
import org.eclipse.linuxtools.internal.docker.ui.wizards.WizardMessages;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class ImageSearchSWTBotTest {
    private SWTWorkbenchBot bot = new SWTWorkbenchBot();
    private DockerExplorerView dockerExplorerView;
    private SWTBotView dockerExplorerViewBot;
    @ClassRule
    public static CloseWelcomePageRule closeWelcomePage = new CloseWelcomePageRule("org.eclipse.linuxtools.docker.ui.perspective");
    @Rule
    public ClearConnectionManagerRule clearConnectionManager = new ClearConnectionManagerRule();
    @Rule
    public CloseShellRule closeShell = new CloseShellRule(IDialogConstants.CANCEL_LABEL);

    @Before
    public void lookupDockerExplorerView() {
        this.dockerExplorerViewBot = this.bot.viewById("org.eclipse.linuxtools.docker.ui.dockerExplorerView");
        this.dockerExplorerView = (DockerExplorerView)this.dockerExplorerViewBot.getViewReference().getView(true);
        this.dockerExplorerViewBot.show();
        this.dockerExplorerViewBot.setFocus();
    }

    @Test
    public void shouldTriggerSearchIfTermWasGiven() {
        DockerClient client = MockDockerClientFactory.onSearch("foo", MockImageSearchResultFactory.name("foo").build()).build();
        this.openPullWizard(client);
        this.bot.textWithLabel(WizardMessages.getString((String)"ImagePullPushPage.name.label")).setText("foo");
        this.openSearchWizard();
        Assertions.assertThat((int)this.bot.table().rowCount()).isEqualTo(1);
    }

    @Test
    public void shouldNotTriggerSearchIfNoTermWasGiven() {
        DockerClient client = MockDockerClientFactory.onSearch("foo", MockImageSearchResultFactory.name("foo").build()).build();
        this.openPullWizard(client);
        this.openSearchWizard();
        Assertions.assertThat((int)this.bot.table().rowCount()).isEqualTo(0);
    }

    @Test
    public void shouldReduceSearchResultsToExactGivenTerm() {
        DockerClient client = MockDockerClientFactory.onSearch("foo/bar", MockImageSearchResultFactory.name("foo/bar").build(), MockImageSearchResultFactory.name("other/bar").build()).build();
        this.openPullWizard(client);
        this.bot.textWithLabel(WizardMessages.getString((String)"ImagePullPushPage.name.label")).setText("foo/bar");
        this.openSearchWizard();
        Assertions.assertThat((int)this.bot.table().rowCount()).isEqualTo(1);
    }

    @Test
    public void shouldShowAllSearchResultsForGivenTerm() {
        DockerClient client = MockDockerClientFactory.onSearch("bar", MockImageSearchResultFactory.name("foo/bar").build(), MockImageSearchResultFactory.name("other/bar").build()).build();
        this.openPullWizard(client);
        this.bot.textWithLabel(WizardMessages.getString((String)"ImagePullPushPage.name.label")).setText("bar");
        this.openSearchWizard();
        Assertions.assertThat((int)this.bot.table().rowCount()).isEqualTo(2);
    }

    private void openPullWizard(DockerClient client) {
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Test", client).withDefaultTCPConnectionSettings();
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection});
        SWTBotTreeItem imagesTreeItem = SWTUtils.getTreeItem(this.dockerExplorerViewBot, "Test", "Images");
        SWTBotTree dockerExplorerViewTreeBot = this.dockerExplorerViewBot.bot().tree();
        imagesTreeItem.select();
        dockerExplorerViewTreeBot.contextMenu("Pull...").click();
    }

    private void openSearchWizard() {
        this.bot.button(WizardMessages.getString((String)"ImagePull.search.label")).click();
    }

    @Test
    public void shouldAllowForDefaultLatestTag() {
        DockerClient client = MockDockerClientFactory.onSearch("foo", MockImageSearchResultFactory.name("foo").build()).build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Test", client).withDefaultTCPConnectionSettings();
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection});
        SWTUtils.getTreeItem(this.dockerExplorerViewBot, "Test", "Images").select();
        this.dockerExplorerViewBot.bot().tree().contextMenu("Pull...").click();
        this.bot.textWithLabel(WizardMessages.getString((String)"ImagePullPushPage.name.label")).setText("foo");
        this.bot.button(WizardMessages.getString((String)"ImagePull.search.label")).click();
        Assertions.assertThat((int)this.bot.table().rowCount()).isEqualTo(1);
        Assertions.assertThat((boolean)this.bot.button("Next >").isEnabled()).isTrue();
        Assertions.assertThat((boolean)this.bot.button("Finish").isEnabled()).isTrue();
        this.bot.button("Finish").click();
        Assertions.assertThat((String)this.bot.textWithLabel(WizardMessages.getString((String)"ImagePullPushPage.name.label")).getText()).isEqualTo((Object)"foo:latest");
    }
}

