/*******************************************************************************
 * Copyright (c) 2017, 2018 Red Hat Inc. and others.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Red Hat - Initial Contribution
 *******************************************************************************/
package org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data;

import com.google.gson.annotations.SerializedName;

public class SpaceRelationships {
	
	@SerializedName("owned-by")
	private SpaceOwnedBy owned_by;

	private RelationGeneric iterations;
	
	private RelationGeneric areas;
	
	private RelationGeneric workitemlinktypes;
	
	private RelationGeneric workitemtypes;
	
	private RelationGeneric workitems;
	
	private RelationGeneric codebases;
	
	private RelationGeneric collaborators;
	
	private RelationGeneric labels;
	
	// for testing purposes only
	public SpaceRelationships (SpaceOwnedBy owned_by, RelationGeneric iterations,
			RelationGeneric areas, RelationGeneric workitemlinktypes,
			RelationGeneric workitemtypes,
			RelationGeneric workitems, RelationGeneric codebases, RelationGeneric collaborators,
			RelationGeneric labels) {
		this.owned_by = owned_by;
		this.iterations = iterations;
		this.areas = areas;
		this.workitemlinktypes = workitemlinktypes;
		this.workitemtypes = workitemtypes;
		this.workitems = workitems;
		this.codebases = codebases;
		this.collaborators = collaborators;
		this.labels = labels;
	}
	
	public SpaceOwnedBy getOwnedBy() {
		return owned_by;
	}
	
	public RelationGeneric getIterations() {
		return iterations;
	}
	
	public RelationGeneric getWorkItemLinkTypes() {
		return workitemlinktypes;
	}
	
	public RelationGeneric getWorkItemTypes() {
		return workitemtypes;
	}
	
	public RelationGeneric getWorkItems() {
		return workitems;
	}
	
	public RelationGeneric getCodebases() {
		return codebases;
	}
	
	public RelationGeneric getCollaborators() {
		return collaborators;
	}
	
	public RelationGeneric getLabels() {
		return labels;
	}
	
	public RelationGeneric getAreas() {
		return areas;
	}
}
