/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.mylyn.osio.rest.core;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;

public abstract class ListenableFutureJob<V>
extends Job
implements ListenableFuture<V> {
    List<Listener> listeners = Collections.synchronizedList(Lists.newArrayList());
    private volatile boolean done;
    private V resultObject = null;

    public ListenableFutureJob(String name) {
        super(name);
        this.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void done(IJobChangeEvent event) {
                ListenableFutureJob.this.done = true;
                List<Listener> list = ListenableFutureJob.this.listeners;
                synchronized (list) {
                    for (Listener listener : ListenableFutureJob.this.listeners) {
                        listener.run();
                    }
                }
            }
        });
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.cancel();
    }

    public V get() throws InterruptedException, ExecutionException {
        this.join();
        return this.resultObject;
    }

    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long start = System.currentTimeMillis();
        while (!this.done && System.currentTimeMillis() - start < unit.toMillis(timeout)) {
            Thread.sleep(250L);
        }
        if (!this.done) {
            throw new TimeoutException("ListenableFutureJob.get() could not get the result!");
        }
        return this.resultObject;
    }

    protected void set(V future) {
        this.resultObject = future;
    }

    public boolean isCancelled() {
        return this.getResult().getSeverity() == 8;
    }

    public boolean isDone() {
        return this.done;
    }

    public void addListener(Runnable listener, Executor executor) {
        this.listeners.add(new Listener(listener, executor));
    }

    private class Listener {
        Runnable runnable;
        Executor executor;

        public Listener(Runnable runnable, Executor executor) {
            this.runnable = runnable;
            this.executor = executor;
        }

        public void run() {
            this.executor.execute(this.runnable);
        }
    }
}

