/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.mylyn.osio.rest.core;

import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.reflect.TypeToken;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.DefaultOSIORestRequestProvider;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.IOSIORestRequestProvider;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.NullOperationMonitor;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestConfiguration;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestConnector;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestException;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestResourceMovedPermanentlyException;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestTaskSchema;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.URLQueryEncoder;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.Area;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.AreaListResponse;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.IdNamed;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.Identity;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.Iteration;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.IterationListResponse;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.Label;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.LabelListResponse;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.Named;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.RestResponse;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.Space;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.SpaceResponse;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.SpaceSingleResponse;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.User;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.UserSingleResponse;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.UsersResponse;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.WorkItemLinkTypeData;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.WorkItemLinkTypeResponse;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.WorkItemResponse;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.WorkItemTypeData;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.WorkItemTypeResponse;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.WorkItemsResponse;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.core.operations.IOperationMonitor;
import org.eclipse.mylyn.commons.repositories.core.RepositoryLocation;
import org.eclipse.mylyn.commons.repositories.http.core.CommonHttpClient;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.RepositoryResponse;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMetaData;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataCollector;
import org.eclipse.osgi.util.NLS;

public class OSIORestClient {
    private final CommonHttpClient client;
    private final RepositoryLocation location;
    private String userName;
    private Map<String, Space> cachedSpaces;
    private final OSIORestConnector connector;
    public static final int MAX_RETRIEVED_PER_QUERY = 50;
    public final IOSIORestRequestProvider restRequestProvider;

    public OSIORestClient(RepositoryLocation location, OSIORestConnector connector) {
        this(location, connector, new DefaultOSIORestRequestProvider());
    }

    public OSIORestClient(RepositoryLocation location, OSIORestConnector connector, IOSIORestRequestProvider provider) {
        this.client = new CommonHttpClient(location);
        this.location = location;
        this.userName = location.getProperty("osio.rest.userid");
        this.connector = connector;
        this.restRequestProvider = provider;
    }

    public CommonHttpClient getClient() {
        return this.client;
    }

    public IOSIORestRequestProvider getRequestProvider() {
        return this.restRequestProvider;
    }

    public boolean validate(IOperationMonitor monitor) throws OSIORestException {
        RepositoryLocation location = this.getClient().getLocation();
        if (location.getProperty("osio.rest.authtoken") != null) {
            String userName = location.getProperty("osio.rest.userid");
            Identity response = this.restRequestProvider.getAuthUser(monitor, this.client);
            if (response.getUsername().equals(userName)) {
                return true;
            }
        }
        return false;
    }

    public OSIORestConfiguration getConfiguration(TaskRepository repository, IOperationMonitor monitor) {
        try {
            OSIORestConfiguration config = new OSIORestConfiguration(repository.getUrl(), this.userName);
            Map<String, Space> spaces = this.getSpaces(monitor);
            for (Space space : spaces.values()) {
                Map<String, WorkItemTypeData> workItemTypes = this.getSpaceWorkItemTypes(new NullOperationMonitor(), space);
                space.setWorkItemTypes(workItemTypes);
                Map<String, WorkItemLinkTypeData> workItemLinkTypes = this.getSpaceWorkItemLinkTypes(new NullOperationMonitor(), space);
                space.setWorkItemLinkTypes(workItemLinkTypes);
                Map<String, Area> areas = this.getSpaceAreas(new NullOperationMonitor(), space);
                space.setAreas(areas);
                Map<String, Iteration> iterations = this.getSpaceIterations(new NullOperationMonitor(), space);
                space.setIterations(iterations);
                Map<String, Label> labels = this.getSpaceLabels(new NullOperationMonitor(), space);
                space.setLabels(labels);
                Map<String, User> users = this.getUsers(new NullOperationMonitor(), space);
                space.setUsers(users);
            }
            config.setSpaces(spaces);
            return config;
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.linuxtools.mylyn.osio.rest.core", "Could not get the Configuration", (Throwable)e));
            return null;
        }
    }

    public <R extends RestResponse<E>, E extends Named> Map<String, E> retrieveItems(IOperationMonitor monitor, String path, TypeToken<?> typeToken) throws OSIORestException {
        Object response = this.restRequestProvider.getRequest(monitor, this.client, path, typeToken);
        Named[] members = (Named[])response.getArray();
        TreeMap<String, Named> map = new TreeMap<String, Named>();
        Named[] namedArray = members;
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            Named member = namedArray[n2];
            map.put(member.getName(), member);
            ++n2;
        }
        return map;
    }

    public <R extends RestResponse<E>, E extends Named> Map<String, E> retrieveItemsAuth(IOperationMonitor monitor, String path, TypeToken<?> typeToken) throws OSIORestException {
        Object response = this.restRequestProvider.getRequest(monitor, this.client, path, typeToken, true);
        Named[] members = (Named[])response.getArray();
        TreeMap<String, Named> map = new TreeMap<String, Named>();
        Named[] namedArray = members;
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            Named member = namedArray[n2];
            map.put(member.getName(), member);
            ++n2;
        }
        return map;
    }

    public <R extends RestResponse<E>, E extends IdNamed> Map<String, E> retrieveItemsById(IOperationMonitor monitor, String path, TypeToken<?> typeToken) throws OSIORestException {
        Object response = this.restRequestProvider.getRequest(monitor, this.client, path, typeToken);
        Object[] members = (IdNamed[])response.getArray();
        return Maps.uniqueIndex((Iterable)Lists.newArrayList((Object[])members), (Function)new Function<E, String>(){

            public String apply(E input) {
                return input.getId();
            }
        });
    }

    private Map<String, Space> getCachedSpaces(IOperationMonitor monitor) throws OSIORestException {
        if (this.cachedSpaces == null) {
            this.cachedSpaces = this.getSpaces(monitor);
        }
        return this.cachedSpaces;
    }

    private Map<String, Space> getSpaces(IOperationMonitor monitor) throws OSIORestException {
        this.cachedSpaces = this.retrieveItems(monitor, "/namedspaces/" + this.userName, new TypeToken<SpaceResponse>(){});
        return this.cachedSpaces;
    }

    public Map<String, User> getUsers(IOperationMonitor monitor, Space space) throws OSIORestException {
        Map<String, User> users = this.retrieveItemsAuth(monitor, "/spaces/" + space.getId() + "/collaborators", new TypeToken<UsersResponse>(){});
        return users;
    }

    public Map<String, WorkItemTypeData> getSpaceWorkItemTypes(IOperationMonitor monitor, Space space) throws OSIORestException {
        String linkSuffix = this.connector.getURLSuffix(space.getLinks().getWorkItemTypes());
        return this.retrieveItems(monitor, linkSuffix, new TypeToken<WorkItemTypeResponse>(){});
    }

    public User getOwnedByLink(IOperationMonitor monitor, Space space) throws OSIORestException {
        String ownerSuffix = this.connector.getURLSuffix(space.getRelationships().getOwnedBy().getLinks().getRelated());
        UserSingleResponse owner = (UserSingleResponse)this.restRequestProvider.getSingleRequest(monitor, this.client, ownerSuffix, new TypeToken<UserSingleResponse>(){}, true, true);
        return owner.getData();
    }

    public Map<String, WorkItemLinkTypeData> getSpaceWorkItemLinkTypes(IOperationMonitor monitor, Space space) throws OSIORestException {
        String linkSuffix = this.connector.getURLSuffix(space.getLinks().getWorkItemLinkTypes());
        return this.retrieveItemsById(monitor, linkSuffix, new TypeToken<WorkItemLinkTypeResponse>(){});
    }

    public Map<String, Area> getSpaceAreas(IOperationMonitor monitor, Space space) throws OSIORestException {
        return this.retrieveItems(monitor, "/spaces/" + space.getId() + "/areas", new TypeToken<AreaListResponse>(){});
    }

    public Map<String, Iteration> getSpaceIterations(IOperationMonitor monitor, Space space) throws OSIORestException {
        return this.retrieveItems(monitor, "/spaces/" + space.getId() + "/iterations", new TypeToken<IterationListResponse>(){});
    }

    public Map<String, Label> getSpaceLabels(IOperationMonitor monitor, Space space) throws OSIORestException {
        return this.retrieveItems(monitor, "/spaces/" + space.getId() + "/labels", new TypeToken<LabelListResponse>(){});
    }

    public Space getSpaceById(String spaceId, TaskRepository taskRepository) throws CoreException {
        Map<String, Space> externalSpaces;
        OSIORestConfiguration config = null;
        config = this.connector.getRepositoryConfiguration(taskRepository);
        Map<String, Space> spaces = config.getSpaces();
        Space space = null;
        for (Space s : spaces.values()) {
            if (!s.getId().equals(spaceId)) continue;
            space = s;
            break;
        }
        if (space == null && (space = (externalSpaces = config.getExternalSpaces()).get(spaceId)) == null) {
            SpaceSingleResponse spaceResponse = null;
            try {
                spaceResponse = (SpaceSingleResponse)this.restRequestProvider.getSingleRequest(new NullOperationMonitor(), this.client, "/spaces/" + spaceId, new TypeToken<SpaceSingleResponse>(){});
                space = spaceResponse.getData();
                Map<String, WorkItemTypeData> workItemTypes = this.getSpaceWorkItemTypes(new NullOperationMonitor(), space);
                space.setWorkItemTypes(workItemTypes);
                Map<String, WorkItemLinkTypeData> workItemLinkTypes = this.getSpaceWorkItemLinkTypes(new NullOperationMonitor(), space);
                space.setWorkItemLinkTypes(workItemLinkTypes);
                Map<String, Area> areas = this.getSpaceAreas(new NullOperationMonitor(), space);
                space.setAreas(areas);
                Map<String, Iteration> iterations = this.getSpaceIterations(new NullOperationMonitor(), space);
                space.setIterations(iterations);
                Map<String, Label> labels = this.getSpaceLabels(new NullOperationMonitor(), space);
                space.setLabels(labels);
                Map<String, User> users = this.getUsers(new NullOperationMonitor(), space);
                space.setUsers(users);
            }
            catch (OSIORestException e) {
                Throwables.propagate((Throwable)new CoreException((IStatus)new Status(4, "org.eclipse.linuxtools.mylyn.osio.rest.core", "Can not find Space (" + spaceId + ")")));
            }
            externalSpaces.put(space.getId(), space);
        }
        return space;
    }

    public SpaceSingleResponse getSpace(IOperationMonitor monitor, String spaceId) throws OSIORestException {
        SpaceSingleResponse response = (SpaceSingleResponse)this.restRequestProvider.getSingleRequest(monitor, this.client, "/spaces/" + spaceId, new TypeToken<SpaceSingleResponse>(){});
        return response;
    }

    public Map<String, String> getSpaceLinkTypes(String spaceId, TaskRepository taskRepository) {
        Space s = null;
        LinkedHashMap<String, String> linkMap = new LinkedHashMap<String, String>();
        try {
            s = this.getSpaceById(spaceId, taskRepository);
        }
        catch (CoreException e1) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.linuxtools.mylyn.osio.rest.core", NLS.bind((String)"Unexpected error during retrieval of configuration for Task Repository {0}", (Object)taskRepository.getRepositoryUrl()), (Throwable)e1));
            return linkMap;
        }
        if (s != null) {
            Map<String, WorkItemLinkTypeData> linkTypes = s.getWorkItemLinkTypes();
            for (WorkItemLinkTypeData linkType : linkTypes.values()) {
                linkMap.put(linkType.getAttributes().getForwardName(), linkType.getId());
                linkMap.put(linkType.getAttributes().getReverseName(), linkType.getId());
            }
        }
        return linkMap;
    }

    public Map<String, WorkItemResponse> getSpaceWorkItems(String spaceId) {
        try {
            return this.retrieveItems(new NullOperationMonitor(), "/spaces/" + spaceId + "/workitems", new TypeToken<WorkItemsResponse>(){});
        }
        catch (OSIORestException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.linuxtools.mylyn.osio.rest.core", NLS.bind((String)"Unexpected error during retrieval of work items for space {0}", (Object)spaceId), (Throwable)e));
            return new HashMap<String, WorkItemResponse>();
        }
    }

    public RepositoryResponse postTaskData(TaskData taskData, Set<TaskAttribute> oldAttributes, TaskRepository repository, IOperationMonitor monitor) throws OSIORestException {
        TaskAttributeMetaData metadata;
        TaskAttribute removeLinks;
        String value;
        Space space = null;
        if (taskData.isNew()) {
            TaskAttribute spaceAttribute = taskData.getRoot().getAttribute(OSIORestTaskSchema.getDefault().SPACE.getKey());
            Map<String, Space> spaces = this.getCachedSpaces(new NullOperationMonitor());
            space = spaces.get(spaceAttribute.getValue());
            String id = null;
            try {
                id = this.restRequestProvider.postNewTask(monitor, this.client, taskData, space, this.connector, repository);
            }
            catch (CoreException e1) {
                throw new OSIORestException(e1);
            }
            return new RepositoryResponse(RepositoryResponse.ResponseKind.TASK_CREATED, id);
        }
        TaskAttribute spaceIdAttribute = taskData.getRoot().getAttribute(OSIORestTaskSchema.getDefault().SPACE_ID.getKey());
        String spaceId = spaceIdAttribute.getValue();
        try {
            space = this.getSpaceById(spaceId, repository);
        }
        catch (CoreException e1) {
            throw new OSIORestException(e1);
        }
        TaskAttribute newComment = taskData.getRoot().getAttribute(OSIORestTaskSchema.getDefault().NEW_COMMENT.getKey());
        if (newComment != null && (value = newComment.getValue()) != null && !value.isEmpty()) {
            this.restRequestProvider.postNewCommentTask(monitor, this.client, taskData, oldAttributes);
            newComment.setValue("");
        }
        if ((removeLinks = taskData.getRoot().getAttribute(OSIORestTaskSchema.getDefault().REMOVE_LINKS.getKey())) != null) {
            List links = removeLinks.getValues();
            metadata = removeLinks.getMetaData();
            TaskAttribute widAttr = taskData.getRoot().getAttribute(OSIORestTaskSchema.getDefault().UUID.getKey());
            String wid = widAttr.getValue();
            for (String link : links) {
                try {
                    String id = metadata.getValue(link);
                    this.restRequestProvider.deleteLink(monitor, this.client, wid, id);
                }
                catch (Exception e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.linuxtools.mylyn.osio.rest.core", NLS.bind((String)"Unexpected error during deletion of work item link: <{0}>", (Object)link), (Throwable)e));
                }
            }
        }
        TaskAttribute addLink = taskData.getRoot().getAttribute(OSIORestTaskSchema.getDefault().ADD_LINK.getKey());
        metadata = addLink.getMetaData();
        String linkid = metadata.getValue("linkid");
        String sourceid = taskData.getRoot().getAttribute(OSIORestTaskSchema.getDefault().UUID.getKey()).getValue();
        String targetid = metadata.getValue("targetWid");
        String direction = metadata.getValue("direction");
        boolean isForward = true;
        if (direction != null && !direction.isEmpty()) {
            isForward = direction.equals("forward");
        }
        if (linkid != null && targetid != null) {
            this.restRequestProvider.postNewLink(monitor, this.client, linkid, sourceid, targetid, isForward);
        }
        this.restRequestProvider.patchUpdateTask(monitor, this.client, taskData, oldAttributes, space);
        return new RepositoryResponse(RepositoryResponse.ResponseKind.TASK_UPDATED, taskData.getTaskId());
    }

    /*
     * Unable to fully structure code
     */
    public void getTaskData(Set<String> taskIds, TaskRepository taskRepository, TaskDataCollector collector, IOperationMonitor monitor) throws OSIORestException {
        try {
            config = this.connector.getRepositoryConfiguration(taskRepository);
        }
        catch (CoreException e1) {
            throw new OSIORestException(e1);
        }
        for (String taskId : taskIds) {
            if (taskId.isEmpty()) continue;
            user = this.userName;
            tokens = taskId.split("#");
            spaceName = tokens[0];
            spaceTokens = spaceName.split("/");
            if (spaceTokens.length > 1) {
                spaceName = spaceTokens[1];
                user = spaceTokens[0];
            }
            wiNumber = tokens[1];
            try {
                block10: {
                    user = URLQueryEncoder.transform(user);
                    query = "/namedspaces/" + user + "/" + spaceName + "/workitems/" + wiNumber;
                    wid = "";
                    try {
                        wid = this.restRequestProvider.getWID(monitor, this.client, query, taskRepository);
                        break block10;
                    }
                    catch (OSIORestResourceMovedPermanentlyException e) {
                        h = e.getHeader();
                        var21_24 = elements = h.getElements();
                        var20_23 = elements.length;
                        var19_22 = 0;
                        ** while (var19_22 < var20_23)
                    }
lbl-1000:
                    // 1 sources

                    {
                        element = var21_24[var19_22];
                        if ("Location".equals(element.getName())) {
                            index = element.getValue().indexOf("workitem/");
                            wid = element.getValue().substring(index + 9);
                        }
                        ++var19_22;
                        continue;
                    }
                }
                workitemquery = "/workitems/" + wid;
                taskData = this.restRequestProvider.getSingleTaskData(monitor, this.client, this.connector, workitemquery, taskRepository);
                space = null;
                spaceId = taskData.getRoot().getAttribute(OSIORestTaskSchema.getDefault().SPACE_ID.getKey()).getValue();
                space = this.getSpaceById(spaceId, taskRepository);
                this.restRequestProvider.getTaskComments(monitor, this.client, space, taskData);
                this.restRequestProvider.getTaskCreator(monitor, this.client, taskData);
                this.restRequestProvider.getTaskLabels(monitor, this.client, space, taskData);
                this.restRequestProvider.getTaskLinks(monitor, this.client, this, space, taskData, config);
                this.setTaskAssignees(taskData);
                config.updateSpaceOptions(taskData);
                config.addValidOperations(taskData);
                collector.accept(taskData);
            }
            catch (RuntimeException | CoreException e) {
                e.printStackTrace();
                cause = e.getCause();
                if (!(cause instanceof CoreException)) continue;
                throw new OSIORestException(cause);
            }
        }
    }

    private void setTaskAssignees(TaskData taskData) throws OSIORestException {
        TaskAttribute assigneeIDs = taskData.getRoot().getAttribute(OSIORestTaskSchema.getDefault().ASSIGNEE_IDS.getKey());
        List ids = assigneeIDs.getValues();
        for (String id : ids) {
            this.restRequestProvider.getTaskAssignee(new NullOperationMonitor(), this.getClient(), id, taskData);
        }
    }

    private String formSearchUrl(String url) throws OSIORestException {
        String searchFilter = "";
        int index = url.indexOf("?");
        if (index < 0) {
            return searchFilter;
        }
        String query = url.substring(index + 1);
        String[] settings = query.split("&");
        HashMap<String, TreeSet<String>> fieldMap = new HashMap<String, TreeSet<String>>();
        String[] stringArray = settings;
        int n = settings.length;
        int n2 = 0;
        while (n2 < n) {
            String setting = stringArray[n2];
            String[] tokens = setting.split("=");
            String name = tokens[0];
            String value = tokens[1];
            TreeSet<String> field = (TreeSet<String>)fieldMap.get(name);
            if (field == null) {
                field = new TreeSet<String>();
                fieldMap.put(name, field);
            }
            field.add(value);
            ++n2;
        }
        if (!fieldMap.isEmpty()) {
            searchFilter = String.valueOf(searchFilter) + "filter[expression]={\"$AND\":[";
            Object lastKey = null;
            String keySeparator = "";
            String itemSeparator = "";
            Map<String, Space> spaces = this.getCachedSpaces(new NullOperationMonitor());
            TreeSet<String> allSpaceNames = new TreeSet<String>(spaces.keySet());
            Space firstSpace = spaces.values().iterator().next();
            Map<String, WorkItemTypeData> workitemTypes = firstSpace.getWorkItemTypes();
            for (String key : fieldMap.keySet()) {
                Object space;
                if (!key.equals(lastKey)) {
                    searchFilter = String.valueOf(searchFilter) + keySeparator + "{\"$OR\":[";
                    keySeparator = "]},";
                    itemSeparator = "";
                }
                if ("space".equals(key)) {
                    Set spaceSet = (Set)fieldMap.get(key);
                    for (String name : spaceSet) {
                        space = null;
                        if (spaces != null) {
                            space = spaces.get(name);
                        }
                        if (space == null) continue;
                        searchFilter = String.valueOf(searchFilter) + itemSeparator + "{\"space\":\"" + ((Space)space).getId() + "\"}";
                        itemSeparator = ",";
                    }
                    continue;
                }
                if ("assignees".equals(key)) {
                    Set userSet = (Set)fieldMap.get(key);
                    TreeSet<String> spaceNames = fieldMap.get("space") != null ? (Set)fieldMap.get("space") : allSpaceNames;
                    for (String spaceName : spaceNames) {
                        Map<String, User> users;
                        Space space2 = this.cachedSpaces.get(spaceName);
                        if (space2 == null || (users = space2.getUsers()) == null) continue;
                        for (String name : userSet) {
                            User user = users.get(name);
                            if (user == null) continue;
                            searchFilter = String.valueOf(searchFilter) + itemSeparator + "{\"assignee\":\"" + user.getAttributes().getIdentityID() + "\"}";
                            itemSeparator = ",";
                        }
                    }
                    continue;
                }
                if ("baseType".equals(key)) {
                    Set workitemSet = (Set)fieldMap.get(key);
                    for (String name : workitemSet) {
                        WorkItemTypeData workitemType = null;
                        if (workitemTypes != null) {
                            workitemType = workitemTypes.get(name);
                        }
                        if (workitemType == null) continue;
                        searchFilter = String.valueOf(searchFilter) + itemSeparator + "{\"workitemtype\":\"" + workitemType.getId() + "\"}";
                        itemSeparator = ",";
                    }
                    continue;
                }
                if ("area".equals(key)) {
                    Set areaSet = (Set)fieldMap.get(key);
                    for (String spaceName : (Set)fieldMap.get("space")) {
                        Map<String, Area> areas;
                        space = this.cachedSpaces.get(spaceName);
                        if (space == null || (areas = ((Space)space).getAreas()) == null) continue;
                        for (String name : areaSet) {
                            Area area = areas.get(name);
                            if (area == null) continue;
                            searchFilter = String.valueOf(searchFilter) + itemSeparator + "{\"area\":\"" + area.getId() + "\"}";
                            itemSeparator = ",";
                        }
                    }
                    continue;
                }
                if ("iteration".equals(key)) {
                    Set iterationSet = (Set)fieldMap.get(key);
                    for (String spaceName : (Set)fieldMap.get("space")) {
                        Map<String, Iteration> iterations;
                        space = this.cachedSpaces.get(spaceName);
                        if (space == null || (iterations = ((Space)space).getIterations()) == null) continue;
                        for (String name : iterationSet) {
                            Iteration iteration = iterations.get(name);
                            if (iteration == null) continue;
                            searchFilter = String.valueOf(searchFilter) + itemSeparator + "{\"iteration\":\"" + iteration.getId() + "\"}";
                            itemSeparator = ",";
                        }
                    }
                    continue;
                }
                if (!"system.state".equals(key)) continue;
                Set stateSet = (Set)fieldMap.get(key);
                for (String name : stateSet) {
                    searchFilter = String.valueOf(searchFilter) + itemSeparator + "{\"state\":\"" + name + "\"}";
                    itemSeparator = ",";
                }
            }
            searchFilter = String.valueOf(searchFilter) + "]}]}";
        }
        searchFilter = URLQueryEncoder.transform(searchFilter);
        return String.valueOf(this.location.getUrl()) + "/search?" + searchFilter;
    }

    public IStatus performQuery(TaskRepository taskRepository, IRepositoryQuery query, final TaskDataCollector resultCollector, IOperationMonitor monitor) throws OSIORestException {
        String queryParams;
        String queryUrl = query.getUrl();
        int index = queryUrl.indexOf("?");
        if (index > 0 && !(queryParams = queryUrl.substring(index + 1)).startsWith("filter")) {
            queryUrl = this.formSearchUrl(queryUrl);
        }
        String queryUrlSuffix = this.connector.getURLSuffix(queryUrl);
        try {
            List<TaskData> taskDataArray = this.restRequestProvider.getTaskData(monitor, this.client, this.connector, queryUrlSuffix, taskRepository);
            for (final TaskData taskData : taskDataArray) {
                taskData.setPartial(true);
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() throws Exception {
                        resultCollector.accept(taskData);
                    }

                    public void handleException(Throwable exception) {
                        StatusHandler.log((IStatus)new Status(4, "org.eclipse.linuxtools.mylyn.osio.rest.core", NLS.bind((String)"Unexpected error during result collection. TaskID {0} in repository {1}", (Object)taskData.getTaskId(), (Object)taskData.getRepositoryUrl()), exception));
                    }
                });
            }
        }
        catch (CoreException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.linuxtools.mylyn.osio.rest.core", NLS.bind((String)"Unexpected error during result collection in repository {0}", (Object)taskRepository.getRepositoryUrl()), (Throwable)e));
        }
        return Status.OK_STATUS;
    }
}

