/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.mylyn.osio.rest.core;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Ordering;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestMessages;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestTaskSchema;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.IdNamed;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.Space;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.WorkItemTypeAttributes;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.WorkItemTypeData;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.WorkItemTypeField;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.WorkItemTypeFieldType;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskOperation;

public class OSIORestConfiguration
implements Serializable {
    private static final OSIORestTaskSchema SCHEMA = OSIORestTaskSchema.getDefault();
    private static final long serialVersionUID = 4173223872076958202L;
    private final String repositoryId;
    private final String userName;
    private Map<String, Space> spaces;
    private Map<String, Space> externalSpaces = new TreeMap<String, Space>();
    private static final String NEW = "new";
    private static final String OPEN = "open";
    private static final String IN_PROGRESS = "in progress";
    private static final String RESOLVED = "resolved";
    private static final String CLOSED = "closed";
    private static final List<String> statusValues = Arrays.asList("new", "open", "in progress", "resolved", "closed");
    private static final List<String> newStatusTransitions = Arrays.asList("open", "in progress", "resolved", "closed");
    private static final List<String> openStatusTransitions = Arrays.asList("in progress", "resolved", "closed");
    private static final List<String> inProgressStatusTransitions = Arrays.asList("open", "resolved", "closed");
    private static final List<String> resolvedStatusTransitions = Arrays.asList("open", "in progress", "closed");
    private static final List<String> closedStatusTransitions = Arrays.asList("open", "in progress", "resolved");
    private Map<String, List<String>> statusTransitions = new HashMap<String, List<String>>();

    public OSIORestConfiguration(String repositoryId, String userName) {
        this.repositoryId = repositoryId;
        this.userName = userName;
        this.statusTransitions.put("", statusValues);
        this.statusTransitions.put(NEW, newStatusTransitions);
        this.statusTransitions.put(OPEN, openStatusTransitions);
        this.statusTransitions.put(IN_PROGRESS, inProgressStatusTransitions);
        this.statusTransitions.put(RESOLVED, resolvedStatusTransitions);
        this.statusTransitions.put(CLOSED, closedStatusTransitions);
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setSpaces(Map<String, Space> spaces) {
        Function<Space, String> getName = new Function<Space, String>(){

            public String apply(Space item) {
                return item.getName();
            }
        };
        Function comparatorFunction = Functions.compose((Function)getName, (Function)Functions.forMap(spaces));
        Ordering comparator = Ordering.natural().onResultOf(comparatorFunction);
        this.spaces = ImmutableSortedMap.copyOf(spaces, (Comparator)comparator);
    }

    public Map<String, Space> getExternalSpaces() {
        return this.externalSpaces;
    }

    public Map<String, Space> getSpaces() {
        return this.spaces;
    }

    public Space getSpaceById(String spaceId) {
        for (Space space : this.getSpaces().values()) {
            if (!space.getId().equals(spaceId)) continue;
            return space;
        }
        this.getExternalSpaces().get(spaceId);
        return null;
    }

    public Space getSpaceWithName(String name) {
        return this.getSpaces().get(name);
    }

    public void updateInitialTaskData(TaskData data) throws CoreException {
        this.setSpaceOptions(data, this.getSpaces());
        this.updateSpaceOptions(data);
        for (String key : data.getRoot().getAttributes().keySet()) {
            String configName;
            if (key.equals(OSIORestTaskSchema.getDefault().NEW_COMMENT.getKey()) || key.equals("task.common.operation") || key.equals(OSIORestTaskSchema.getDefault().DATE_MODIFICATION.getKey())) continue;
            TaskAttribute attribute = data.getRoot().getAttribute(key);
            if (key.equals(OSIORestTaskSchema.getDefault().STATUS.getKey()) && attribute.getOptions().isEmpty()) {
                for (String status : statusValues) {
                    attribute.putOption(status, status);
                }
            }
            if (key.equals(OSIORestTaskSchema.getDefault().ASSIGNEES.getKey())) {
                if (!attribute.getOptions().isEmpty()) continue;
                attribute.putOption(this.userName, this.userName);
                continue;
            }
            if (key.equals(OSIORestConfiguration.SCHEMA.SPACE.getKey()) || !(configName = this.mapTaskAttributeKey2ConfigurationFields(key)).equals("baseType") || attribute.getOptions().size() != 1 || !attribute.getValue().isEmpty()) continue;
            attribute.setValue((String)attribute.getOptions().values().toArray()[0]);
        }
    }

    private String mapTaskAttributeKey2ConfigurationFields(String taskAttributeKey) {
        String resultString = taskAttributeKey.equals("task.common.summary") ? "system.title" : (taskAttributeKey.equals("task.common.status") ? "system.state" : (taskAttributeKey.equals("task.common.user.assigned") ? "assignees" : (taskAttributeKey.equals("task.common.description") ? "system.description" : (taskAttributeKey.equals("comment") ? "longdesc" : taskAttributeKey))));
        return resultString;
    }

    private void setAttributeOptionsForSpace(TaskAttribute taskAttribute, Space actualSpace) {
        taskAttribute.clearOptions();
        if (taskAttribute.getId().equals(OSIORestConfiguration.SCHEMA.WORKITEM_TYPE.getKey())) {
            this.internalSetAttributeOptions(taskAttribute, actualSpace.getWorkItemTypes());
        } else if (taskAttribute.getId().equals(OSIORestConfiguration.SCHEMA.AREA.getKey())) {
            this.internalSetAttributeOptions(taskAttribute, actualSpace.getAreas());
        } else if (taskAttribute.getId().equals(OSIORestConfiguration.SCHEMA.ITERATION.getKey())) {
            this.internalSetAttributeOptions(taskAttribute, actualSpace.getIterations());
        } else if (taskAttribute.getId().equals(OSIORestConfiguration.SCHEMA.ADD_ASSIGNEE.getKey())) {
            this.internalSetAttributeOptions(taskAttribute, actualSpace.getUsers());
        } else if (taskAttribute.getId().equals(OSIORestConfiguration.SCHEMA.ADD_LABEL.getKey())) {
            this.internalSetAttributeOptions(taskAttribute, actualSpace.getLabels());
        } else if (taskAttribute.getId().equals(OSIORestConfiguration.SCHEMA.STATUS.getKey())) {
            LinkedHashMap<String, String> stateMap = new LinkedHashMap<String, String>();
            Map<String, WorkItemTypeData> workItemTypes = actualSpace.getWorkItemTypes();
            for (Map.Entry<String, WorkItemTypeData> entry : workItemTypes.entrySet()) {
                WorkItemTypeField state;
                WorkItemTypeData data = entry.getValue();
                WorkItemTypeAttributes attributes = data.getWorkItemTypeAttributes();
                Map<String, WorkItemTypeField> fields = attributes.getFields();
                if (fields == null || (state = fields.get("system.state")) == null) continue;
                WorkItemTypeFieldType stateType = state.getType();
                String[] stringArray = stateType.getValues();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String value = stringArray[n2];
                    stateMap.put(value, value);
                    ++n2;
                }
            }
            this.internalSetAttributeOptions(taskAttribute, stateMap);
        }
    }

    private void internalSetAttributeOptions(TaskAttribute taskAttribute, Map spaceMap) {
        boolean found = false;
        String actualValue = taskAttribute.getValue();
        for (Object entry : spaceMap.keySet()) {
            String option;
            String name = option = (String)entry;
            Object optionValue = spaceMap.get(entry);
            if (optionValue instanceof IdNamed) {
                name = ((IdNamed)optionValue).getName();
            }
            taskAttribute.putOption(option, name);
            if (found) continue;
            found = actualValue.equals(option);
        }
        if (!found) {
            taskAttribute.setValue("");
        }
    }

    public boolean setSpaceOptions(@NonNull TaskData taskData, @NonNull Map<String, Space> spaces) {
        TaskAttribute attributeSpace = taskData.getRoot().getMappedAttribute(OSIORestConfiguration.SCHEMA.SPACE.getKey());
        if (attributeSpace != null) {
            TreeSet<String> spaceSet = new TreeSet<String>();
            for (String key : spaces.keySet()) {
                spaceSet.add(key);
            }
            attributeSpace.clearOptions();
            for (String SpaceName : spaceSet) {
                attributeSpace.putOption(SpaceName, SpaceName);
            }
            return true;
        }
        return false;
    }

    public boolean updateSpaceOptions(@NonNull TaskData taskData) {
        if (taskData == null) {
            return false;
        }
        TaskAttribute attributeSpaceId = taskData.getRoot().getMappedAttribute(OSIORestConfiguration.SCHEMA.SPACE_ID.getKey());
        TaskAttribute attributeSpace = taskData.getRoot().getMappedAttribute(OSIORestConfiguration.SCHEMA.SPACE.getKey());
        if (attributeSpaceId != null && !attributeSpaceId.getValue().isEmpty()) {
            TaskAttribute attributeState;
            TaskAttribute attributeAddLabel;
            TaskAttribute attributeAddAssignee;
            TaskAttribute attributeIteration;
            TaskAttribute attributeArea;
            Space actualSpace = this.getSpaceById(attributeSpaceId.getValue());
            if (actualSpace == null) {
                return false;
            }
            TaskAttribute attributeWorkItemType = taskData.getRoot().getMappedAttribute(OSIORestConfiguration.SCHEMA.WORKITEM_TYPE.getKey());
            if (attributeWorkItemType != null) {
                this.setAttributeOptionsForSpace(attributeWorkItemType, actualSpace);
            }
            if ((attributeArea = taskData.getRoot().getMappedAttribute(OSIORestConfiguration.SCHEMA.AREA.getKey())) != null) {
                this.setAttributeOptionsForSpace(attributeArea, actualSpace);
            }
            if ((attributeIteration = taskData.getRoot().getMappedAttribute(OSIORestConfiguration.SCHEMA.ITERATION.getKey())) != null) {
                this.setAttributeOptionsForSpace(attributeIteration, actualSpace);
            }
            if ((attributeAddAssignee = taskData.getRoot().getMappedAttribute(OSIORestConfiguration.SCHEMA.ADD_ASSIGNEE.getKey())) != null) {
                this.setAttributeOptionsForSpace(attributeAddAssignee, actualSpace);
            }
            if ((attributeAddLabel = taskData.getRoot().getMappedAttribute(OSIORestConfiguration.SCHEMA.ADD_LABEL.getKey())) != null) {
                this.setAttributeOptionsForSpace(attributeAddLabel, actualSpace);
            }
            if ((attributeState = taskData.getRoot().getMappedAttribute(OSIORestConfiguration.SCHEMA.STATUS.getKey())) != null) {
                this.setAttributeOptionsForSpace(attributeState, actualSpace);
            }
        } else {
            TaskAttribute taskAttribute;
            TreeSet<String> workItemTypes = new TreeSet<String>();
            TreeSet<String> areas = new TreeSet<String>();
            TreeSet<String> iterations = new TreeSet<String>();
            TreeSet<String> users = new TreeSet<String>();
            LinkedHashSet<String> states = new LinkedHashSet<String>();
            TaskAttribute attributeState = this.getSpaces().values().iterator();
            while (attributeState.hasNext()) {
                Space space = attributeState.next();
                if (attributeSpace != null) {
                    attributeSpace.putOption(space.getName(), space.getName());
                }
                if (space.getWorkItemTypes() != null) {
                    WorkItemTypeData workItemTypeData;
                    WorkItemTypeAttributes attributes;
                    Map<String, WorkItemTypeField> fields;
                    WorkItemTypeField state;
                    WorkItemTypeFieldType stateType;
                    String[] values;
                    if (!space.getWorkItemTypes().isEmpty() && (values = (stateType = (state = (fields = (attributes = (workItemTypeData = space.getWorkItemTypes().values().iterator().next()).getWorkItemTypeAttributes()).getFields()).get("system.state")).getType()).getValues()) != null) {
                        String[] stringArray = values;
                        int n = values.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String value = stringArray[n2];
                            states.add(value);
                            ++n2;
                        }
                    }
                    for (Map.Entry entry : space.getWorkItemTypes().entrySet()) {
                        workItemTypes.add((String)entry.getKey());
                    }
                }
                if (space.getAreas() != null) {
                    for (String string : space.getAreas().keySet()) {
                        areas.add(string);
                    }
                }
                if (space.getIterations() != null) {
                    for (String string : space.getIterations().keySet()) {
                        iterations.add(string);
                    }
                }
                if (space.getUsers() == null) continue;
                for (String string : space.getUsers().keySet()) {
                    users.add(string);
                }
            }
            TaskAttribute attributeWorkItemType = taskData.getRoot().getMappedAttribute(OSIORestConfiguration.SCHEMA.WORKITEM_TYPE.getKey());
            if (attributeWorkItemType != null) {
                this.setAllAttributeOptions(attributeWorkItemType, workItemTypes);
            }
            if ((attributeState = taskData.getRoot().getMappedAttribute(OSIORestConfiguration.SCHEMA.STATUS.getKey())) != null) {
                this.setAllAttributeOptions(attributeState, states);
            }
            if ((taskAttribute = taskData.getRoot().getMappedAttribute(OSIORestConfiguration.SCHEMA.ASSIGNEES.getKey())) != null && taskAttribute.getOptions().size() == 0) {
                taskAttribute.putOption(this.userName, this.userName);
            }
        }
        return true;
    }

    private void setAllAttributeOptions(TaskAttribute updateAttribute, Set<String> values) {
        for (String value : values) {
            updateAttribute.putOption(value, value);
        }
    }

    public void addValidOperations(TaskData workItem) {
        TaskAttribute attributeStatus = workItem.getRoot().getMappedAttribute("task.common.status");
        String attributeStatusValue = attributeStatus.getValue();
        TaskAttribute operationAttribute = workItem.getRoot().getAttribute("task.common.operation");
        if (operationAttribute == null) {
            operationAttribute = workItem.getRoot().createAttribute("task.common.operation");
        }
        TaskAttribute attribute = workItem.getRoot().createAttribute("task.common.operation-" + attributeStatusValue);
        TaskOperation.applyTo((TaskAttribute)attribute, (String)attributeStatusValue, (String)OSIORestMessages.getFormattedString("KeepStateOperation", attributeStatusValue));
        TaskOperation.applyTo((TaskAttribute)operationAttribute, (String)attributeStatusValue, (String)OSIORestMessages.getFormattedString("KeepStateOperation", attributeStatusValue));
        for (String statusValue : statusValues) {
            if (attributeStatusValue != null && (attributeStatusValue == null || !attributeStatusValue.equals(statusValue))) continue;
            if (attributeStatusValue == null) {
                attributeStatusValue = "";
            }
            for (String transition : this.statusTransitions.get(statusValue)) {
                attribute = workItem.getRoot().createAttribute("task.common.operation-" + transition);
                TaskOperation.applyTo((TaskAttribute)attribute, (String)transition, (String)OSIORestMessages.getFormattedString("StateChangeOperation", transition));
            }
        }
    }
}

