/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.mylyn.osio.rest.core;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.Duration;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.IOSIORestRequestProvider;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.ListenableFutureJob;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestClient;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestConfiguration;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestException;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestMessages;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestTaskDataHandler;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestTaskSchema;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.RepositoryKey;
import org.eclipse.mylyn.commons.core.operations.IOperationMonitor;
import org.eclipse.mylyn.commons.core.operations.OperationUtil;
import org.eclipse.mylyn.commons.net.Policy;
import org.eclipse.mylyn.commons.repositories.core.RepositoryLocation;
import org.eclipse.mylyn.internal.commons.core.operations.NullOperationMonitor;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.RepositoryInfo;
import org.eclipse.mylyn.tasks.core.RepositoryVersion;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataCollector;
import org.eclipse.mylyn.tasks.core.data.TaskMapper;
import org.eclipse.mylyn.tasks.core.sync.ISynchronizationSession;

public class OSIORestConnector
extends AbstractRepositoryConnector {
    public static final String CONNECTOR_LABEL = "Connector.label";
    public static final Duration CLIENT_CACHE_DURATION = new Duration(24L, TimeUnit.HOURS);
    public static final Duration CONFIGURATION_CACHE_EXPIRE_DURATION = new Duration(7L, TimeUnit.DAYS);
    public static final Duration CONFIGURATION_CACHE_REFRESH_AFTER_WRITE_DURATION = new Duration(1L, TimeUnit.DAYS);
    private static final ThreadLocal<IOperationMonitor> context = new ThreadLocal();
    private final PropertyChangeListener repositoryChangeListener4ClientCache = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (OSIORestConnector.this.ignoredProperty(evt.getPropertyName())) {
                return;
            }
            TaskRepository taskRepository = (TaskRepository)evt.getSource();
            OSIORestConnector.this.clientCache.invalidate((Object)new RepositoryKey(taskRepository));
        }
    };
    private final PropertyChangeListener repositoryChangeListener4ConfigurationCache = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (OSIORestConnector.this.ignoredProperty(evt.getPropertyName()) || evt.getPropertyName().equals("org.eclipse.mylyn.tasklist.repositories.password")) {
                return;
            }
            TaskRepository taskRepository = (TaskRepository)evt.getSource();
            OSIORestConnector.this.configurationCache.invalidate((Object)new RepositoryKey(taskRepository));
        }
    };
    private final LoadingCache<RepositoryKey, OSIORestClient> clientCache = CacheBuilder.newBuilder().expireAfterAccess(CLIENT_CACHE_DURATION.getValue(), CLIENT_CACHE_DURATION.getUnit()).build((CacheLoader)new CacheLoader<RepositoryKey, OSIORestClient>(){

        public OSIORestClient load(RepositoryKey key) throws Exception {
            TaskRepository repository = key.getRepository();
            repository.addChangeListener(OSIORestConnector.this.repositoryChangeListener4ClientCache);
            return OSIORestConnector.this.createClient(repository);
        }
    });
    private final LoadingCache<RepositoryKey, Optional<OSIORestConfiguration>> configurationCache;

    private boolean ignoredProperty(String propertyName) {
        return propertyName.equals("label") || propertyName.equals("org.eclipse.mylyn.tasklist.repositories.offline") || propertyName.equals("encoding") || propertyName.equals("org.eclipse.mylyn.tasklist.repositories.proxy.hostname") || propertyName.equals("org.eclipse.mylyn.tasklist.repositories.proxy.port") || propertyName.equals("org.eclipse.mylyn.tasklist.repositories.savePassword") || propertyName.equals("org.eclipse.mylyn.tasklist.repositories.proxy.usedefault") || propertyName.equals("org.eclipse.mylyn.tasklist.repositories.proxy.savePassword") || propertyName.equals("org.eclipse.mylyn.tasklist.repositories.proxy.username") || propertyName.equals("org.eclipse.mylyn.tasklist.repositories.proxy.password") || propertyName.equals("org.eclipse.mylyn.tasklist.repositories.proxy.enabled");
    }

    public OSIORestConnector() {
        this(CONFIGURATION_CACHE_REFRESH_AFTER_WRITE_DURATION);
    }

    public OSIORestConnector(Duration refreshAfterWriteDuration) {
        this.configurationCache = this.createCacheBuilder(CONFIGURATION_CACHE_EXPIRE_DURATION, refreshAfterWriteDuration).build((CacheLoader)new CacheLoader<RepositoryKey, Optional<OSIORestConfiguration>>(){

            public Optional<OSIORestConfiguration> load(RepositoryKey key) throws Exception {
                OSIORestClient client = (OSIORestClient)OSIORestConnector.this.clientCache.get((Object)key);
                TaskRepository repository = key.getRepository();
                repository.addChangeListener(OSIORestConnector.this.repositoryChangeListener4ConfigurationCache);
                return Optional.fromNullable((Object)client.getConfiguration(key.getRepository(), (IOperationMonitor)context.get()));
            }

            public ListenableFuture<Optional<OSIORestConfiguration>> reload(final RepositoryKey key, Optional<OSIORestConfiguration> oldValue) throws Exception {
                ListenableFutureJob<Optional<OSIORestConfiguration>> job = new ListenableFutureJob<Optional<OSIORestConfiguration>>(""){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            OSIORestClient client = (OSIORestClient)OSIORestConnector.this.clientCache.get((Object)key);
                            this.set(Optional.fromNullable((Object)client.getConfiguration(key.getRepository(), (IOperationMonitor)context.get())));
                        }
                        catch (ExecutionException e) {
                            e.printStackTrace();
                            return new Status(4, "org.eclipse.linuxtools.mylyn.osio.rest.core", "OSIORestConnector reload Configuration", (Throwable)e);
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.schedule();
                return job;
            }
        });
    }

    protected CacheBuilder<Object, Object> createCacheBuilder(Duration expireAfterWriteDuration, Duration refreshAfterWriteDuration) {
        return CacheBuilder.newBuilder().expireAfterWrite(expireAfterWriteDuration.getValue(), expireAfterWriteDuration.getUnit()).refreshAfterWrite(refreshAfterWriteDuration.getValue(), refreshAfterWriteDuration.getUnit());
    }

    private OSIORestClient createClient(TaskRepository repository) {
        RepositoryLocation location = new RepositoryLocation(this.convertProperties(repository));
        OSIORestClient client = new OSIORestClient(location, this);
        return client;
    }

    private Map<String, String> convertProperties(TaskRepository repository) {
        return repository.getProperties().entrySet().stream().collect(Collectors.toMap(e -> this.convertProperty((String)e.getKey()), Map.Entry::getValue));
    }

    private String convertProperty(String key) {
        if ("org.eclipse.mylyn.tasklist.repositories.proxy.usedefault".equals(key)) {
            return "org.eclipse.mylyn.repositories.proxy.usedefault";
        }
        if ("org.eclipse.mylyn.tasklist.repositories.proxy.hostname".equals(key)) {
            return "org.eclipse.mylyn.repositories.proxy.host";
        }
        if ("org.eclipse.mylyn.tasklist.repositories.proxy.port".equals(key)) {
            return "org.eclipse.mylyn.repositories.proxy.port";
        }
        return key;
    }

    public OSIORestClient getClient(TaskRepository repository) throws CoreException {
        try {
            return (OSIORestClient)this.clientCache.get((Object)new RepositoryKey(repository));
        }
        catch (ExecutionException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.linuxtools.mylyn.osio.rest.core", "TaskRepositoryManager is null"));
        }
    }

    public OSIORestClient getClient(TaskRepository repository, IOSIORestRequestProvider provider) throws CoreException {
        try {
            RepositoryLocation location = new RepositoryLocation(this.convertProperties(repository));
            OSIORestClient newClient = new OSIORestClient(location, this, provider);
            this.clientCache.put((Object)new RepositoryKey(repository), (Object)newClient);
            return newClient;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean canCreateNewTask(TaskRepository repository) {
        return true;
    }

    public boolean canCreateTaskFromKey(TaskRepository repository) {
        return false;
    }

    public String getConnectorKind() {
        return "org.eclipse.linuxtools.mylyn.osio.rest";
    }

    public String getLabel() {
        return OSIORestMessages.getString(CONNECTOR_LABEL);
    }

    public String getRepositoryUrlFromTaskUrl(String taskUrl) {
        if (taskUrl == null) {
            return null;
        }
        int index = taskUrl.indexOf("/api/");
        return index == -1 ? null : taskUrl.substring(0, index);
    }

    public AbstractTaskDataHandler getTaskDataHandler() {
        return new OSIORestTaskDataHandler(this);
    }

    public TaskData getTaskData(TaskRepository repository, String taskIdOrKey, IProgressMonitor monitor) throws CoreException {
        return ((OSIORestTaskDataHandler)this.getTaskDataHandler()).getTaskData(repository, taskIdOrKey, monitor);
    }

    public String getTaskIdFromTaskUrl(String taskUrl) {
        return null;
    }

    public String getURLSuffix(String url) {
        int index = url.indexOf("/api/");
        return index == -1 ? null : url.substring(index + 4);
    }

    public String getTaskUrl(String repositoryUrl, String taskIdOrKey) {
        return String.valueOf(repositoryUrl) + "/api/workitems/" + taskIdOrKey;
    }

    public boolean hasTaskChanged(TaskRepository taskRepository, ITask task, TaskData taskData) {
        String lastKnownLocalModValue = task.getAttribute(OSIORestTaskSchema.getDefault().DATE_MODIFICATION.getKey());
        TaskAttribute latestRemoteModAttribute = taskData.getRoot().getMappedAttribute("task.common.date.modified");
        String latestRemoteModValue = latestRemoteModAttribute != null ? latestRemoteModAttribute.getValue() : null;
        return !Objects.equal((Object)latestRemoteModValue, (Object)lastKnownLocalModValue);
    }

    public IStatus performQuery(TaskRepository repository, IRepositoryQuery query, TaskDataCollector collector, ISynchronizationSession session, IProgressMonitor monitor) {
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        try {
            monitor.beginTask("performQuery", -1);
            OSIORestClient client = this.getClient(repository);
            IOperationMonitor progress = OperationUtil.convert((IProgressMonitor)monitor, (String)"performQuery", (int)3);
            IStatus iStatus = client.performQuery(repository, query, collector, progress);
            return iStatus;
        }
        catch (CoreException e) {
            Status status = new Status(4, "org.eclipse.linuxtools.mylyn.osio.rest.core", 1, "CoreException from performQuery", (Throwable)e);
            return status;
        }
        catch (OSIORestException e) {
            Status status = new Status(4, "org.eclipse.linuxtools.mylyn.osio.rest.core", 1, "OSIORestException from performQuery", (Throwable)e);
            return status;
        }
        finally {
            monitor.done();
        }
    }

    public void updateRepositoryConfiguration(TaskRepository taskRepository, IProgressMonitor monitor) throws CoreException {
        context.set((IOperationMonitor)(monitor != null ? OperationUtil.convert((IProgressMonitor)monitor) : new NullOperationMonitor()));
        this.configurationCache.refresh((Object)new RepositoryKey(taskRepository));
        context.remove();
    }

    public void updateTaskFromTaskData(TaskRepository taskRepository, ITask task, TaskData taskData) {
        TaskMapper scheme = this.getTaskMapping(taskData);
        scheme.applyTo(task);
        task.setUrl(taskData.getRoot().getAttribute(OSIORestTaskSchema.getDefault().TASK_URL.getKey()).getValue());
        boolean isComplete = false;
        TaskAttribute attributeStatus = taskData.getRoot().getMappedAttribute("task.common.status");
        if (attributeStatus != null) {
            String statusValue = attributeStatus.getValue();
            boolean bl = isComplete = statusValue.equals("resolved") || statusValue.equals("closed");
        }
        if (taskData.isPartial()) {
            if (isComplete) {
                if (task.getCompletionDate() == null) {
                    task.setCompletionDate(new Date(0L));
                }
            } else {
                task.setCompletionDate(null);
            }
        } else {
            this.inferCompletionDate(task, taskData, scheme, isComplete);
        }
    }

    private void inferCompletionDate(ITask task, TaskData taskData, TaskMapper scheme, boolean isComplete) {
        if (isComplete) {
            TaskAttribute attributeLastModified;
            TaskAttribute attributeCommentDate;
            TaskAttribute lastComment;
            Date completionDate = null;
            List taskComments = taskData.getAttributeMapper().getAttributesByType(taskData, "comment");
            if (taskComments != null && taskComments.size() > 0 && (lastComment = (TaskAttribute)taskComments.get(0)) != null && (attributeCommentDate = lastComment.getMappedAttribute("task.common.comment.date")) != null) {
                completionDate = new Date(Long.parseLong(attributeCommentDate.getValue()));
            }
            if (completionDate == null && (attributeLastModified = taskData.getRoot().getMappedAttribute("task.common.date.modified")) != null && attributeLastModified.getValue().length() > 0) {
                completionDate = taskData.getAttributeMapper().getDateValue(attributeLastModified);
            }
            task.setCompletionDate(completionDate);
        } else {
            task.setCompletionDate(null);
        }
        TaskAttribute attrDelta = taskData.getRoot().getAttribute(OSIORestTaskSchema.getDefault().SPACE.getKey());
        if (attrDelta != null && !attrDelta.getValue().equals("")) {
            task.setAttribute(OSIORestTaskSchema.getDefault().SPACE.getKey(), attrDelta.getValue());
        }
        if ((attrDelta = taskData.getRoot().getAttribute(OSIORestTaskSchema.getDefault().DATE_MODIFICATION.getKey())) != null && !attrDelta.getValue().equals("")) {
            task.setAttribute(OSIORestTaskSchema.getDefault().DATE_MODIFICATION.getKey(), attrDelta.getValue());
        }
    }

    public RepositoryInfo validateRepository(TaskRepository repository, IProgressMonitor monitor) throws CoreException {
        try {
            OSIORestClient client = this.createClient(repository);
            if (!client.validate(OperationUtil.convert((IProgressMonitor)monitor))) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.linuxtools.mylyn.osio.rest.core", "repository is invalid"));
            }
            String version = "1.0.0";
            return new RepositoryInfo(new RepositoryVersion(version));
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.linuxtools.mylyn.osio.rest.core", e.getMessage(), (Throwable)e));
        }
    }

    public OSIORestConfiguration getRepositoryConfiguration(TaskRepository repository) throws CoreException {
        if (this.clientCache.getIfPresent((Object)new RepositoryKey(repository)) == null) {
            this.getClient(repository);
        }
        try {
            Optional configurationOptional = (Optional)this.configurationCache.get((Object)new RepositoryKey(repository));
            return configurationOptional.isPresent() ? (OSIORestConfiguration)configurationOptional.get() : null;
        }
        catch (UncheckedExecutionException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.linuxtools.mylyn.osio.rest.core", e.getMessage(), (Throwable)e));
        }
        catch (ExecutionException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.linuxtools.mylyn.osio.rest.core", e.getMessage(), (Throwable)e));
        }
    }

    public void clearClientCache() {
        this.clientCache.invalidateAll();
    }

    public void clearConfigurationCache() {
        this.configurationCache.invalidateAll();
    }

    public void clearAllCaches() {
        this.clearClientCache();
        this.clearConfigurationCache();
    }

    public boolean isRepositoryConfigurationStale(TaskRepository repository, IProgressMonitor monitor) throws CoreException {
        return false;
    }

    public TaskMapper getTaskMapping(final TaskData taskData) {
        return new TaskMapper(taskData){

            public String getTaskKey() {
                TaskAttribute attribute = this.getTaskData().getRoot().getAttribute(OSIORestTaskSchema.getDefault().ID.getKey());
                if (attribute != null) {
                    return attribute.getValue();
                }
                return super.getTaskKey();
            }

            public String getTaskKind() {
                return taskData.getConnectorKind();
            }

            public String getTaskUrl() {
                TaskAttribute attribute = this.getTaskData().getRoot().getAttribute(OSIORestTaskSchema.getDefault().TASK_URL.getKey());
                if (attribute != null) {
                    return attribute.getValue();
                }
                return super.getTaskUrl();
            }
        };
    }
}

