/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.mylyn.osio.rest.core;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestGetRequest;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestTaskSchema;
import org.eclipse.mylyn.commons.repositories.http.core.CommonHttpClient;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;

public class OSIORestGetTaskAssignee
extends OSIORestGetRequest<TaskAttribute> {
    private final TaskData taskData;
    OSIORestTaskSchema taskSchema = OSIORestTaskSchema.getDefault();

    public OSIORestGetTaskAssignee(CommonHttpClient client, String id, TaskData taskData) {
        super(client, "/users/" + id, null);
        this.taskData = taskData;
    }

    public TaskAttribute testParseFromJson(InputStreamReader in) {
        return this.parseFromJson(in);
    }

    @Override
    protected TaskAttribute parseFromJson(InputStreamReader in) {
        TypeToken<ArrayList<TaskAttribute>> type = new TypeToken<ArrayList<TaskAttribute>>(){};
        return (TaskAttribute)new GsonBuilder().registerTypeAdapter(type.getType(), (Object)new JSonTaskDataDeserializer()).create().fromJson((Reader)in, type.getType());
    }

    private class JSonTaskDataDeserializer
    implements JsonDeserializer<TaskAttribute> {
        private JSonTaskDataDeserializer() {
        }

        public TaskAttribute deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            TaskAttribute assignee = OSIORestGetTaskAssignee.this.taskData.getRoot().getAttribute(OSIORestGetTaskAssignee.this.taskSchema.ASSIGNEES.getKey());
            if (json.getAsJsonObject().get("data") != null) {
                JsonObject data = json.getAsJsonObject().get("data").getAsJsonObject();
                JsonObject attributes = data.get("attributes").getAsJsonObject();
                String username = attributes.get("username").getAsString();
                assignee.addValue(username);
            }
            return assignee;
        }
    }
}

