/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.mylyn.osio.rest.core;

import com.google.common.base.Throwables;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.NullOperationMonitor;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestException;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestGetRequest;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestGetUser;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestTaskSchema;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.Identity;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.Space;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.User;
import org.eclipse.mylyn.commons.repositories.http.core.CommonHttpClient;
import org.eclipse.mylyn.tasks.core.IRepositoryPerson;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskCommentMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;

public class OSIORestGetTaskComments
extends OSIORestGetRequest<ArrayList<TaskAttribute>> {
    private final TaskData taskData;
    private final Space space;
    private final CommonHttpClient client;
    OSIORestTaskSchema taskSchema = OSIORestTaskSchema.getDefault();

    public OSIORestGetTaskComments(CommonHttpClient client, Space space, TaskData taskData) {
        super(client, "/workitems/" + taskData.getRoot().getAttribute(OSIORestTaskSchema.getDefault().UUID.getKey()).getValue() + "/comments", null);
        this.taskData = taskData;
        this.space = space;
        this.client = client;
    }

    public ArrayList<TaskAttribute> testParseFromJson(InputStreamReader in) {
        return this.parseFromJson(in);
    }

    @Override
    protected ArrayList<TaskAttribute> parseFromJson(InputStreamReader in) {
        TypeToken<ArrayList<TaskAttribute>> type = new TypeToken<ArrayList<TaskAttribute>>(){};
        return (ArrayList)new GsonBuilder().registerTypeAdapter(type.getType(), (Object)new JSonTaskDataDeserializer()).create().fromJson((Reader)in, type.getType());
    }

    private class JSonTaskDataDeserializer
    implements JsonDeserializer<ArrayList<TaskAttribute>> {
        private JSonTaskDataDeserializer() {
        }

        public ArrayList<TaskAttribute> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject comment;
            ArrayList<TaskAttribute> response = new ArrayList<TaskAttribute>();
            int i = 0;
            Map<String, User> users = OSIORestGetTaskComments.this.space.getUsers();
            for (JsonElement commentEntry : json.getAsJsonObject().get("data").getAsJsonArray()) {
                comment = commentEntry.getAsJsonObject();
                JsonObject attributes = comment.get("attributes").getAsJsonObject();
                JsonObject relationships = comment.get("relationships").getAsJsonObject();
                JsonObject creator = relationships.get("creator").getAsJsonObject();
                JsonObject creatorData = creator.get("data").getAsJsonObject();
                JsonObject commentLinks = comment.get("links").getAsJsonObject();
                TaskAttribute attribute = OSIORestGetTaskComments.this.taskData.getRoot().createAttribute("task.common.comment-" + i++);
                TaskAttribute numComments = OSIORestGetTaskComments.this.taskData.getRoot().getAttribute(OSIORestTaskSchema.getDefault().COMMENT_COUNT.getKey());
                numComments.setValue(Integer.toString(i));
                TaskCommentMapper taskComment = TaskCommentMapper.createFrom((TaskAttribute)attribute);
                taskComment.setCommentId(comment.get("id").getAsString());
                taskComment.setNumber(Integer.valueOf(i));
                taskComment.setUrl(commentLinks.get("self").getAsString());
                String id = creatorData.get("id").getAsString();
                String email = "??????";
                String fullName = "???";
                try {
                    for (Map.Entry<String, User> entry : users.entrySet()) {
                        User user = entry.getValue();
                        if (!user.getId().equals(id)) continue;
                        email = user.getAttributes().getEmail();
                        fullName = user.getAttributes().getFullName();
                        break;
                    }
                    if (email.startsWith("?")) {
                        Identity user = (Identity)new OSIORestGetUser(OSIORestGetTaskComments.this.client, id).run(new NullOperationMonitor());
                        email = user.getEmail();
                        fullName = user.getFullName();
                    }
                }
                catch (OSIORestException e1) {
                    e1.printStackTrace();
                }
                IRepositoryPerson author = OSIORestGetTaskComments.this.taskData.getAttributeMapper().getTaskRepository().createPerson(email);
                author.setName(fullName);
                taskComment.setAuthor(author);
                taskComment.setIsPrivate(null);
                try {
                    SimpleDateFormat iso8601Format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSS'Z'", Locale.US);
                    iso8601Format.setTimeZone(TimeZone.getTimeZone("UTC"));
                    Date tempDate = iso8601Format.parse(attributes.get("created-at").getAsString());
                    taskComment.setCreationDate(tempDate);
                }
                catch (ParseException e) {
                    Throwables.propagate((Throwable)new CoreException((IStatus)new Status(4, "org.eclipse.linuxtools.mylyn.osio.rest.core", "Can not parse Date (" + attributes.get("created-at").getAsString() + ")")));
                }
                if (attributes.get("body").getAsString() != null) {
                    String commentText = attributes.get("body").getAsString().trim();
                    taskComment.setText(commentText);
                }
                taskComment.applyTo(attribute);
                response.add(attribute);
            }
            int numComments = response.size();
            i = 0;
            while (i < numComments) {
                TaskAttribute attribute = response.get(i);
                comment = TaskCommentMapper.createFrom((TaskAttribute)attribute);
                comment.setNumber(Integer.valueOf(numComments - i));
                comment.applyTo(attribute);
                ++i;
            }
            return response;
        }
    }
}

