/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.mylyn.osio.rest.core;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestGetRequest;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestTaskSchema;
import org.eclipse.mylyn.commons.repositories.http.core.CommonHttpClient;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMetaData;
import org.eclipse.mylyn.tasks.core.data.TaskData;

public class OSIORestGetTaskCreator
extends OSIORestGetRequest<TaskAttribute> {
    private final TaskData taskData;
    private final String id;
    OSIORestTaskSchema taskSchema = OSIORestTaskSchema.getDefault();

    public OSIORestGetTaskCreator(CommonHttpClient client, TaskData taskData) {
        super(client, "/users/" + taskData.getRoot().getAttribute(OSIORestTaskSchema.getDefault().CREATOR_ID.getKey()).getValue(), null, true);
        this.taskData = taskData;
        this.id = taskData.getRoot().getAttribute(OSIORestTaskSchema.getDefault().CREATOR_ID.getKey()).getValue();
    }

    public TaskAttribute testParseFromJson(InputStreamReader in) {
        return this.parseFromJson(in);
    }

    @Override
    protected TaskAttribute parseFromJson(InputStreamReader in) {
        TypeToken<ArrayList<TaskAttribute>> type = new TypeToken<ArrayList<TaskAttribute>>(){};
        return (TaskAttribute)new GsonBuilder().registerTypeAdapter(type.getType(), (Object)new JSonTaskDataDeserializer()).create().fromJson((Reader)in, type.getType());
    }

    private class JSonTaskDataDeserializer
    implements JsonDeserializer<TaskAttribute> {
        private JSonTaskDataDeserializer() {
        }

        public TaskAttribute deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            TaskAttribute creator = OSIORestGetTaskCreator.this.taskData.getRoot().getAttribute(OSIORestGetTaskCreator.this.taskSchema.CREATOR.getKey());
            TaskAttributeMetaData creatorMeta = creator.getMetaData();
            if (json.getAsJsonObject().get("data") == null) {
                return creator;
            }
            JsonObject data = json.getAsJsonObject().get("data").getAsJsonObject();
            JsonObject attributes = data.getAsJsonObject().get("attributes").getAsJsonObject();
            String fullname = attributes.get("fullName").getAsString();
            creator.setValue(fullname);
            String email = attributes.get("email").getAsString();
            creatorMeta.putValue("email", email);
            String username = attributes.get("username").getAsString();
            creatorMeta.putValue("username", username);
            creatorMeta.putValue("id", OSIORestGetTaskCreator.this.id);
            return creator;
        }
    }
}

