/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.mylyn.osio.rest.core;

import com.google.common.base.Throwables;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.NullOperationMonitor;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestClient;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestConfiguration;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestConnector;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestException;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestGetRequest;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestResourceNotFoundException;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestTaskDataHandler;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestTaskSchema;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.Area;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.IdNamed;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.Iteration;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.Label;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.Space;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.SpaceSingleResponse;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.User;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.WorkItemLinkTypeData;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.WorkItemTypeData;
import org.eclipse.mylyn.commons.core.operations.IOperationMonitor;
import org.eclipse.mylyn.commons.repositories.http.core.CommonHttpClient;
import org.eclipse.mylyn.commons.repositories.http.core.CommonHttpResponse;
import org.eclipse.mylyn.commons.repositories.http.core.HttpUtil;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.osgi.util.NLS;

public class OSIORestGetTaskData
extends OSIORestGetRequest<List<TaskData>> {
    private final TaskRepository taskRepository;
    private final OSIORestConfiguration taskConfiguration;
    private final CommonHttpClient client;
    private final OSIORestConnector connector;
    OSIORestTaskSchema taskSchema = OSIORestTaskSchema.getDefault();

    public OSIORestGetTaskData(CommonHttpClient client, OSIORestConnector connector, String urlSuffix, TaskRepository taskRepository) throws CoreException {
        super(client, urlSuffix, null);
        this.client = client;
        this.taskRepository = taskRepository;
        this.taskConfiguration = connector.getRepositoryConfiguration(taskRepository);
        this.connector = connector;
    }

    public List<TaskData> testParseFromJson(InputStreamReader in) throws OSIORestException {
        return this.parseFromJson(in);
    }

    @Override
    protected List<TaskData> parseFromJson(InputStreamReader in) throws OSIORestException {
        TypeToken<List<TaskData>> type = new TypeToken<List<TaskData>>(){};
        return (List)new GsonBuilder().registerTypeAdapter(type.getType(), (Object)new JSonTaskDataDeserializer()).create().fromJson((Reader)in, type.getType());
    }

    @Override
    protected List<TaskData> doProcess(CommonHttpResponse response, IOperationMonitor monitor) throws IOException, OSIORestException {
        InputStream is = response.getResponseEntityAsStream();
        InputStreamReader in = new InputStreamReader(is);
        return this.parseFromJson(in);
    }

    @Override
    protected void doValidate(CommonHttpResponse response, IOperationMonitor monitor) throws IOException, OSIORestException {
        int statusCode = response.getStatusCode();
        if (statusCode != 400 && statusCode != 200) {
            if (statusCode == 404) {
                throw new OSIORestResourceNotFoundException(NLS.bind((String)"Requested resource ''{0}'' does not exist", (Object)response.getRequestPath()));
            }
            throw new OSIORestException(NLS.bind((String)"Unexpected response from OSIO REST server for ''{0}'': {1}", (Object)response.getRequestPath(), (Object)HttpUtil.getStatusText((int)statusCode)));
        }
    }

    private class JSonTaskDataDeserializer
    implements JsonDeserializer<ArrayList<TaskData>> {
        private JSonTaskDataDeserializer() {
        }

        public ArrayList<TaskData> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            ArrayList<TaskData> response = new ArrayList<TaskData>();
            OSIORestTaskDataHandler dataHandler = (OSIORestTaskDataHandler)OSIORestGetTaskData.this.connector.getTaskDataHandler();
            TaskAttributeMapper mapper = dataHandler.getAttributeMapper(OSIORestGetTaskData.this.taskRepository);
            if (json.getAsJsonObject().get("data") == null) {
                return response;
            }
            for (JsonElement workitem : json.getAsJsonObject().get("data").getAsJsonArray()) {
                Iterator entryObject;
                TaskAttribute attribute;
                String attributeId;
                Map<String, Space> externalSpaces;
                JsonObject workitemdata = workitem.getAsJsonObject();
                JsonObject attributes = workitemdata.get("attributes").getAsJsonObject();
                JsonObject relationships = workitemdata.get("relationships").getAsJsonObject();
                JsonObject space = relationships.get("space").getAsJsonObject();
                JsonObject spaceData = space.get("data").getAsJsonObject();
                String spaceId = spaceData.get("id").getAsString();
                Map<String, Space> spaces = OSIORestGetTaskData.this.taskConfiguration.getSpaces();
                Space actualSpace = null;
                for (Space entry : spaces.values()) {
                    if (!entry.getId().equals(spaceId)) continue;
                    actualSpace = entry;
                    break;
                }
                OSIORestClient restClient = null;
                try {
                    restClient = OSIORestGetTaskData.this.connector.getClient(OSIORestGetTaskData.this.taskRepository);
                }
                catch (CoreException e2) {
                    Throwables.propagate((Throwable)new CoreException((IStatus)new Status(4, "org.eclipse.linuxtools.mylyn.osio.rest.core", "Can not get OSIORestClient")));
                }
                if (actualSpace == null && (actualSpace = (externalSpaces = OSIORestGetTaskData.this.taskConfiguration.getExternalSpaces()).get(spaceId)) == null) {
                    SpaceSingleResponse spaceResponse = null;
                    try {
                        spaceResponse = (SpaceSingleResponse)new OSIORestGetRequest(OSIORestGetTaskData.this.client, "/spaces/" + spaceId, new TypeToken<SpaceSingleResponse>(){}, true).run(new NullOperationMonitor());
                        actualSpace = spaceResponse.getData();
                    }
                    catch (OSIORestException e) {
                        continue;
                    }
                    try {
                        Map<String, WorkItemTypeData> workItemTypes = restClient.getSpaceWorkItemTypes(new NullOperationMonitor(), actualSpace);
                        actualSpace.setWorkItemTypes(workItemTypes);
                        Map<String, WorkItemLinkTypeData> workItemLinkTypes = restClient.getSpaceWorkItemLinkTypes(new NullOperationMonitor(), actualSpace);
                        actualSpace.setWorkItemLinkTypes(workItemLinkTypes);
                        Map<String, Area> areas = restClient.getSpaceAreas(new NullOperationMonitor(), actualSpace);
                        actualSpace.setAreas(areas);
                        Map<String, Iteration> iterations = restClient.getSpaceIterations(new NullOperationMonitor(), actualSpace);
                        actualSpace.setIterations(iterations);
                        Map<String, Label> labels = restClient.getSpaceLabels(new NullOperationMonitor(), actualSpace);
                        actualSpace.setLabels(labels);
                        Map<String, User> users = restClient.getUsers(new NullOperationMonitor(), actualSpace);
                        actualSpace.setUsers(users);
                    }
                    catch (OSIORestException e) {
                        e.printStackTrace();
                        continue;
                    }
                    externalSpaces.put(actualSpace.getId(), actualSpace);
                }
                String spaceName = actualSpace.getName();
                User owner = null;
                try {
                    owner = restClient.getOwnedByLink(new NullOperationMonitor(), actualSpace);
                }
                catch (OSIORestException e1) {
                    Throwables.propagate((Throwable)new CoreException((IStatus)new Status(4, "org.eclipse.linuxtools.mylyn.osio.rest.core", "Can not get owner of Space (" + spaceId + ")")));
                }
                int number = attributes.get("system.number").getAsInt();
                String taskId = String.valueOf(owner.getName()) + "/" + spaceName + "#" + number;
                TaskData taskData = null;
                taskData = new TaskData(mapper, OSIORestGetTaskData.this.connector.getConnectorKind(), OSIORestGetTaskData.this.taskRepository.getRepositoryUrl(), taskId);
                try {
                    dataHandler.initializeTaskData(OSIORestGetTaskData.this.taskRepository, taskData, null, null);
                }
                catch (CoreException e) {
                    Throwables.propagate((Throwable)e);
                }
                response.add(taskData);
                TaskAttribute spaceIdAttribute = taskData.getRoot().getAttribute(OSIORestGetTaskData.this.taskSchema.SPACE_ID.getKey());
                spaceIdAttribute.setValue(spaceId);
                TaskAttribute idAttribute = taskData.getRoot().getAttribute(OSIORestGetTaskData.this.taskSchema.ID.getKey());
                idAttribute.setValue(taskId);
                TaskAttribute uuidAttribute = taskData.getRoot().getAttribute(OSIORestGetTaskData.this.taskSchema.UUID.getKey());
                String uuid = workitemdata.get("id").getAsString();
                uuidAttribute.setValue(uuid);
                TaskAttribute spaceAttribute = taskData.getRoot().getAttribute(OSIORestGetTaskData.this.taskSchema.SPACE.getKey());
                spaceAttribute.setValue(spaceName);
                TaskAttribute addLinkAttribute = taskData.getRoot().getAttribute(OSIORestGetTaskData.this.taskSchema.ADD_LINK.getKey());
                addLinkAttribute.putOption("space", actualSpace.getId());
                for (Map.Entry entry : attributes.entrySet()) {
                    Date tempDate;
                    SimpleDateFormat iso8601Format;
                    JsonElement value;
                    attributeId = OSIORestTaskSchema.getAttributeNameFromFieldName((String)entry.getKey());
                    if (((String)entry.getKey()).equals("system.updated_at")) {
                        attribute = taskData.getRoot().getAttribute(OSIORestGetTaskData.this.taskSchema.DATE_MODIFICATION.getKey());
                        value = (JsonElement)entry.getValue();
                        if (attribute != null) {
                            try {
                                iso8601Format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSS'Z'", Locale.US);
                                iso8601Format.setTimeZone(TimeZone.getTimeZone("UTC"));
                                tempDate = iso8601Format.parse(value.getAsString());
                                attribute.setValue(Long.toString(tempDate.getTime()));
                                continue;
                            }
                            catch (ParseException e) {
                                Throwables.propagate((Throwable)new CoreException((IStatus)new Status(4, "org.eclipse.linuxtools.mylyn.osio.rest.core", "Can not parse Date (" + value.getAsString() + ")")));
                            }
                        }
                    } else if (((String)entry.getKey()).equals("system.created_at")) {
                        attribute = taskData.getRoot().getAttribute(OSIORestGetTaskData.this.taskSchema.DATE_CREATION.getKey());
                        value = (JsonElement)entry.getValue();
                        if (attribute != null) {
                            try {
                                iso8601Format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSS'Z'", Locale.US);
                                iso8601Format.setTimeZone(TimeZone.getTimeZone("UTC"));
                                tempDate = iso8601Format.parse(value.getAsString());
                                attribute.setValue(Long.toString(tempDate.getTime()));
                                continue;
                            }
                            catch (ParseException e) {
                                Throwables.propagate((Throwable)new CoreException((IStatus)new Status(4, "org.eclipse.linuxtools.mylyn.osio.rest.core", "Can not parse Date (" + value.getAsString() + ")")));
                            }
                        }
                    }
                    if ((attribute = taskData.getRoot().getAttribute(attributeId)) == null || (value = (JsonElement)entry.getValue()).isJsonNull()) continue;
                    if (value.isJsonArray()) {
                        JsonArray valueArray = value.getAsJsonArray();
                        attribute.clearValues();
                        for (JsonElement jsonElement : valueArray) {
                            attribute.addValue(jsonElement.getAsString());
                        }
                        continue;
                    }
                    attribute.setValue(((JsonElement)entry.getValue()).getAsString());
                }
                block20: for (Map.Entry entry : relationships.entrySet()) {
                    attributeId = OSIORestTaskSchema.getAttributeNameFromFieldName((String)entry.getKey());
                    if (attributeId.equals("space") || attributeId.equals("assignees") || attributeId.equals("creator") || attributeId.equals("labels") || attributeId.equals("children") || (attribute = taskData.getRoot().getAttribute(attributeId)) == null || !(entryObject = ((JsonElement)entry.getValue()).getAsJsonObject()).has("data")) continue;
                    JsonObject entryData = entryObject.get("data").getAsJsonObject();
                    String entryId = entryData.get("id").getAsString();
                    Map<String, IdNamed> itemMap = actualSpace.getMapFor((String)entry.getKey());
                    if (itemMap == null) continue;
                    for (Map.Entry<String, IdNamed> itemEntry : itemMap.entrySet()) {
                        if (!itemEntry.getValue().getId().equals(entryId)) continue;
                        attribute.setValue(itemEntry.getKey());
                        continue block20;
                    }
                }
                TaskAttribute assigneeIDs = taskData.getRoot().getAttribute(OSIORestGetTaskData.this.taskSchema.ASSIGNEE_IDS.getKey());
                JsonObject assigneeObject = relationships.get("assignees").getAsJsonObject();
                if (assigneeObject.get("data") != null) {
                    JsonArray assigneeArray = assigneeObject.get("data").getAsJsonArray();
                    entryObject = assigneeArray.iterator();
                    while (entryObject.hasNext()) {
                        JsonElement entry = (JsonElement)entryObject.next();
                        JsonObject entryObject2 = entry.getAsJsonObject();
                        String id = entryObject2.get("id").getAsString();
                        assigneeIDs.addValue(id);
                    }
                }
                TaskAttribute creatorID = taskData.getRoot().getAttribute(OSIORestGetTaskData.this.taskSchema.CREATOR_ID.getKey());
                JsonObject creatorObject = relationships.get("creator").getAsJsonObject();
                JsonObject creatorData = creatorObject.get("data").getAsJsonObject();
                creatorID.setValue(creatorData.get("id").getAsString());
                TaskAttribute labelsLink = taskData.getRoot().getAttribute(OSIORestGetTaskData.this.taskSchema.LABELS_LINK.getKey());
                JsonObject labelsObject = relationships.get("labels").getAsJsonObject();
                JsonObject labelsData = labelsObject.get("links").getAsJsonObject();
                labelsLink.setValue(labelsData.get("related").getAsString());
                TaskAttribute workitemURL = taskData.getRoot().getAttribute(OSIORestGetTaskData.this.taskSchema.TASK_URL.getKey());
                JsonObject linksObject = workitemdata.get("links").getAsJsonObject();
                String workitemself = linksObject.get("self").getAsString();
                workitemURL.setValue(workitemself);
                try {
                    OSIORestConfiguration config = OSIORestGetTaskData.this.connector.getRepositoryConfiguration(OSIORestGetTaskData.this.taskRepository);
                    if (config == null) continue;
                    config.addValidOperations(taskData);
                }
                catch (CoreException e) {
                    Throwables.propagate((Throwable)e);
                }
            }
            return response;
        }
    }
}

