/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.mylyn.osio.rest.core;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestGetRequest;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestTaskSchema;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.Space;
import org.eclipse.mylyn.commons.repositories.http.core.CommonHttpClient;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;

public class OSIORestGetTaskLabels
extends OSIORestGetRequest<TaskAttribute> {
    private final TaskData taskData;
    OSIORestTaskSchema taskSchema = OSIORestTaskSchema.getDefault();

    public OSIORestGetTaskLabels(CommonHttpClient client, Space space, TaskData taskData) {
        super(client, "/workitems/" + taskData.getRoot().getAttribute(OSIORestTaskSchema.getDefault().UUID.getKey()).getValue() + "/labels", null);
        this.taskData = taskData;
        taskData.getRoot().getAttribute(OSIORestTaskSchema.getDefault().UUID.getKey()).getValue();
    }

    public TaskAttribute testParseFromJson(InputStreamReader in) {
        return this.parseFromJson(in);
    }

    @Override
    protected TaskAttribute parseFromJson(InputStreamReader in) {
        TypeToken<TaskAttribute> type = new TypeToken<TaskAttribute>(){};
        return (TaskAttribute)new GsonBuilder().registerTypeAdapter(type.getType(), (Object)new JSonTaskDataDeserializer()).create().fromJson((Reader)in, type.getType());
    }

    private class JSonTaskDataDeserializer
    implements JsonDeserializer<TaskAttribute> {
        private JSonTaskDataDeserializer() {
        }

        public TaskAttribute deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            TaskAttribute response = OSIORestGetTaskLabels.this.taskData.getRoot().getAttribute(OSIORestGetTaskLabels.this.taskSchema.LABELS.getKey());
            response.clearValues();
            if (json.getAsJsonObject().get("data") != null) {
                for (JsonElement entry : json.getAsJsonObject().get("data").getAsJsonArray()) {
                    JsonObject entryObject = entry.getAsJsonObject();
                    JsonObject attributes = entryObject.get("attributes").getAsJsonObject();
                    String name = attributes.getAsJsonObject().get("name").getAsString();
                    response.addValue(name);
                }
            }
            return response;
        }
    }
}

