/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.mylyn.osio.rest.core;

import com.google.common.base.Throwables;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.NullOperationMonitor;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestClient;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestConfiguration;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestException;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestGetRequest;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestMessages;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestTaskSchema;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.Space;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.User;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.WorkItem;
import org.eclipse.mylyn.commons.repositories.http.core.CommonHttpClient;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMetaData;
import org.eclipse.mylyn.tasks.core.data.TaskData;

public class OSIORestGetTaskLinks
extends OSIORestGetRequest<TaskAttribute> {
    private final TaskData taskData;
    private final Space space;
    private final String wid;
    private final OSIORestConfiguration config;
    private final OSIORestClient osioClient;
    private final CommonHttpClient client;
    OSIORestTaskSchema taskSchema = OSIORestTaskSchema.getDefault();

    public OSIORestGetTaskLinks(CommonHttpClient client, OSIORestClient osioClient, Space space, TaskData taskData, OSIORestConfiguration config) {
        super(client, "/workitems/" + taskData.getRoot().getAttribute(OSIORestTaskSchema.getDefault().UUID.getKey()).getValue() + "/relationships/links", null);
        this.taskData = taskData;
        this.space = space;
        this.wid = taskData.getRoot().getAttribute(OSIORestTaskSchema.getDefault().UUID.getKey()).getValue();
        this.client = client;
        this.osioClient = osioClient;
        this.config = config;
    }

    public TaskAttribute testParseFromJson(InputStreamReader in) {
        return this.parseFromJson(in);
    }

    @Override
    protected TaskAttribute parseFromJson(InputStreamReader in) {
        TypeToken<TaskAttribute> type = new TypeToken<TaskAttribute>(){};
        return (TaskAttribute)new GsonBuilder().registerTypeAdapter(type.getType(), (Object)new JSonTaskDataDeserializer()).create().fromJson((Reader)in, type.getType());
    }

    private class JSonTaskDataDeserializer
    implements JsonDeserializer<TaskAttribute> {
        private JSonTaskDataDeserializer() {
        }

        public TaskAttribute deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            TaskAttribute response = OSIORestGetTaskLinks.this.taskData.getRoot().getAttribute(OSIORestTaskSchema.getDefault().LINKS.getKey());
            response.clearValues();
            for (JsonElement entry : json.getAsJsonObject().get("data").getAsJsonArray()) {
                JsonObject entryObject = entry.getAsJsonObject();
                String id = entryObject.get("id").getAsString();
                JsonObject relationships = entryObject.get("relationships").getAsJsonObject();
                JsonObject source = relationships.get("source").getAsJsonObject();
                JsonObject sourceData = source.get("data").getAsJsonObject();
                String sourceId = sourceData.get("id").getAsString();
                JsonObject target = relationships.get("target").getAsJsonObject();
                JsonObject targetData = target.get("data").getAsJsonObject();
                String targetId = targetData.get("id").getAsString();
                JsonObject linkType = (JsonObject)relationships.get("link_type");
                JsonObject linkTypeData = linkType.get("data").getAsJsonObject();
                String linkTypeId = linkTypeData.get("id").getAsString();
                String link = "";
                String otherId = targetId;
                if (sourceId.equals(OSIORestGetTaskLinks.this.wid)) {
                    link = OSIORestGetTaskLinks.this.space.getWorkItemLinkTypes().get(linkTypeId).getAttributes().getForwardName();
                } else {
                    link = OSIORestGetTaskLinks.this.space.getWorkItemLinkTypes().get(linkTypeId).getAttributes().getReverseName();
                    otherId = sourceId;
                }
                WorkItem workitem = null;
                try {
                    workitem = OSIORestGetTaskLinks.this.osioClient.getRequestProvider().getWorkItem(new NullOperationMonitor(), OSIORestGetTaskLinks.this.client, otherId);
                }
                catch (OSIORestException e1) {
                    e1.printStackTrace();
                }
                String otherWorkItem = OSIORestMessages.getString("UnknownName.msg");
                boolean haveOtherWorkItemName = false;
                if (workitem != null) {
                    Map<String, Space> externalSpaces;
                    Space s;
                    int number;
                    User owner;
                    String spaceId = workitem.getSpaceId();
                    Map<String, Space> spaces = OSIORestGetTaskLinks.this.config.getSpaces();
                    if (spaces != null) {
                        for (Space s2 : spaces.values()) {
                            if (!s2.getId().equals(spaceId)) continue;
                            owner = null;
                            try {
                                owner = OSIORestGetTaskLinks.this.osioClient.getOwnedByLink(new NullOperationMonitor(), s2);
                            }
                            catch (OSIORestException e1) {
                                Throwables.propagate((Throwable)new CoreException((IStatus)new Status(4, "org.eclipse.linuxtools.mylyn.osio.rest.core", "Can not get owner of Space (" + spaceId + ")")));
                            }
                            number = Integer.parseInt(workitem.getNumber());
                            otherWorkItem = String.valueOf(owner.getName()) + "/" + s2.getName() + "#" + number;
                            haveOtherWorkItemName = true;
                            break;
                        }
                    }
                    if (!haveOtherWorkItemName && (s = (externalSpaces = OSIORestGetTaskLinks.this.config.getExternalSpaces()).get(spaceId)) != null) {
                        owner = null;
                        try {
                            owner = OSIORestGetTaskLinks.this.osioClient.getOwnedByLink(new NullOperationMonitor(), s);
                        }
                        catch (OSIORestException e1) {
                            Throwables.propagate((Throwable)new CoreException((IStatus)new Status(4, "org.eclipse.linuxtools.mylyn.osio.rest.core", "Can not get owner of Space (" + spaceId + ")")));
                        }
                        number = Integer.parseInt(workitem.getNumber());
                        otherWorkItem = String.valueOf(owner.getName()) + "/" + s.getName() + "#" + number;
                    }
                }
                link = String.valueOf(link) + " " + workitem.getTitle() + " [" + otherWorkItem + "]";
                response.addValue(link);
                TaskAttributeMetaData metadata = response.getMetaData();
                metadata.putValue(link, id);
            }
            return response;
        }
    }
}

