/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.mylyn.osio.rest.core;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestGetRequest;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.Identity;
import org.eclipse.mylyn.commons.repositories.http.core.CommonHttpClient;

public class OSIORestGetUser
extends OSIORestGetRequest<Identity> {
    public OSIORestGetUser(CommonHttpClient client, String id) {
        super(client, "/users/" + id, null, true, true);
    }

    public Identity testParseFromJson(InputStreamReader in) {
        return this.parseFromJson(in);
    }

    @Override
    protected Identity parseFromJson(InputStreamReader in) {
        TypeToken<Identity> type = new TypeToken<Identity>(){};
        return (Identity)new GsonBuilder().registerTypeAdapter(type.getType(), (Object)new JSonTaskDataDeserializer()).create().fromJson((Reader)in, type.getType());
    }

    private class JSonTaskDataDeserializer
    implements JsonDeserializer<Identity> {
        private JSonTaskDataDeserializer() {
        }

        public Identity deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            Identity response = new Identity();
            JsonObject data = (JsonObject)json.getAsJsonObject().get("data");
            JsonObject attributes = (JsonObject)data.get("attributes");
            String userId = attributes.get("userID").getAsString();
            response.setUserID(userId);
            String identityId = attributes.get("identityID").getAsString();
            response.setIdentityID(identityId);
            String fullName = attributes.get("fullName").getAsString();
            response.setFullName(fullName);
            String email = attributes.get("email").getAsString();
            response.setEmail(email);
            String imageURL = attributes.get("imageURL").getAsString();
            response.setImageURL(imageURL);
            String company = attributes.get("company").getAsString();
            response.setCompany(company);
            String username = attributes.get("username").getAsString();
            response.setUsername(username);
            String bio = attributes.get("bio").getAsString();
            response.setBio(bio);
            String providerType = attributes.get("providerType").getAsString();
            response.setProviderType(providerType);
            Boolean registrationCompleted = attributes.get("registrationCompleted").getAsBoolean();
            response.setRegistrationCompleted(registrationCompleted);
            String created_at = attributes.get("created-at").getAsString();
            response.setCreated_at(created_at);
            String updated_at = attributes.get("updated-at").getAsString();
            response.setUpdated_at(updated_at);
            return response;
        }
    }
}

