/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.mylyn.osio.rest.core;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestGetRequest;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.WorkItem;
import org.eclipse.mylyn.commons.repositories.http.core.CommonHttpClient;

public class OSIORestGetWorkItem
extends OSIORestGetRequest<WorkItem> {
    public OSIORestGetWorkItem(CommonHttpClient client, String id) {
        super(client, "/workitems/" + id, null);
    }

    public WorkItem testParseFromJson(InputStreamReader in) {
        return this.parseFromJson(in);
    }

    @Override
    protected WorkItem parseFromJson(InputStreamReader in) {
        TypeToken<WorkItem> type = new TypeToken<WorkItem>(){};
        return (WorkItem)new GsonBuilder().registerTypeAdapter(type.getType(), (Object)new JSonTaskDataDeserializer()).create().fromJson((Reader)in, type.getType());
    }

    private class JSonTaskDataDeserializer
    implements JsonDeserializer<WorkItem> {
        private JSonTaskDataDeserializer() {
        }

        public WorkItem deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            WorkItem response = new WorkItem();
            JsonObject data = (JsonObject)json.getAsJsonObject().get("data");
            String id = data.get("id").getAsString();
            response.setId(id);
            JsonObject attributes = (JsonObject)data.get("attributes");
            JsonObject relationships = (JsonObject)data.get("relationships");
            String title = attributes.get("system.title").getAsString();
            response.setTitle(title);
            String description = attributes.get("system.description.rendered").getAsString();
            response.setDescription(description);
            String number = attributes.get("system.number").getAsString();
            response.setNumber(number);
            JsonObject space = relationships.get("space").getAsJsonObject();
            JsonObject spaceData = space.get("data").getAsJsonObject();
            String spaceId = spaceData.get("id").getAsString();
            response.setSpaceId(spaceId);
            return response;
        }
    }
}

