/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.mylyn.osio.rest.core;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class OSIORestGsonUtil {
    private static Gson gson = new Gson();
    private static OSIORestGsonUtil instance;
    private final Function<String, Integer> convert2Integer = new Function<String, Integer>(){

        public Integer apply(String input) {
            if ("".equals(input)) {
                return null;
            }
            return Integer.parseInt(input);
        }
    };

    public static String convertString2GSonString(String str) {
        str = str.replace("\"", "\\\"").replace("\n", "\\\n");
        StringBuffer ostr = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            if (ch >= ' ' && ch <= '~') {
                ostr.append(ch);
            } else {
                ostr.append("\\u");
                String hex = Integer.toHexString(str.charAt(i) & 0xFFFF);
                int j = 0;
                while (j < 4 - hex.length()) {
                    ostr.append("0");
                    ++j;
                }
                ostr.append(hex.toLowerCase());
            }
            ++i;
        }
        return new String(ostr);
    }

    public static OSIORestGsonUtil getDefault() {
        if (instance == null) {
            instance = new OSIORestGsonUtil();
        }
        return instance;
    }

    public static void buildArrayFromHash(JsonWriter out, String id, Set<String> setNew, boolean asInteger) throws IOException {
        if (!setNew.isEmpty()) {
            out.name(id).beginArray();
            for (String string : setNew) {
                if ("".equals(string)) continue;
                if (asInteger) {
                    out.value((long)Integer.parseInt(string));
                    continue;
                }
                out.value(string);
            }
            out.endArray();
        }
    }

    public void buildAddRemoveHash(JsonWriter out, String id, Set<String> setOld, Set<String> setNew) throws IOException {
        RemoveAddStringHelper test = new RemoveAddStringHelper(setOld, setNew);
        out.name(id);
        gson.toJson((Object)test, RemoveAddStringHelper.class, out);
    }

    public void buildAddRemoveIntegerHash(JsonWriter out, String id, Set<String> setOld, Set<String> setNew) throws IOException {
        RemoveAddIntegerHelper test = new RemoveAddIntegerHelper(Sets.newHashSet((Iterable)Iterables.transform(setOld, this.convert2Integer)), Sets.newHashSet((Iterable)Iterables.transform(setNew, this.convert2Integer)));
        out.name(id);
        gson.toJson((Object)test, RemoveAddIntegerHelper.class, out);
    }

    private class RemoveAddIntegerHelper {
        Set<Integer> add;
        Set<Integer> remove;

        public RemoveAddIntegerHelper(Set<Integer> removeSet, Set<Integer> addSet) {
            this.add = new HashSet<Integer>(addSet);
            this.remove = new HashSet<Integer>(removeSet);
            if (this.remove.contains(null)) {
                this.remove.remove(null);
            }
            if (this.add.contains(null)) {
                this.add.remove(null);
            }
            Sets.SetView intersection = Sets.intersection(addSet, removeSet);
            this.remove.removeAll((Collection<?>)intersection);
            this.add.removeAll((Collection<?>)intersection);
            if (this.remove.isEmpty()) {
                this.remove = null;
            }
            if (this.add.isEmpty()) {
                this.add = null;
            }
        }
    }

    private class RemoveAddStringHelper {
        Set<String> add;
        Set<String> remove;

        public RemoveAddStringHelper(Set<String> removeSet, Set<String> addSet) {
            this.add = new HashSet<String>(addSet);
            this.remove = new HashSet<String>(removeSet);
            if (this.remove.contains("")) {
                this.remove.remove("");
            }
            if (this.add.contains("")) {
                this.add.remove("");
            }
            Sets.SetView intersection = Sets.intersection(addSet, removeSet);
            this.remove.removeAll((Collection<?>)intersection);
            this.add.removeAll((Collection<?>)intersection);
            if (this.remove.isEmpty()) {
                this.remove = null;
            }
            if (this.add.isEmpty()) {
                this.add = null;
            }
        }
    }
}

