/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.mylyn.osio.rest.core;

import com.google.common.base.Throwables;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.NullOperationMonitor;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestException;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestMessages;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestPatchRequest;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestPostNewLabelTask;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestTaskSchema;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.Area;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.Iteration;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.Label;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.LabelResponse;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.Space;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.User;
import org.eclipse.mylyn.commons.repositories.core.RepositoryLocation;
import org.eclipse.mylyn.commons.repositories.http.core.CommonHttpClient;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;

public class OSIORestPatchUpdateTask
extends OSIORestPatchRequest<TaskData> {
    private final TaskData taskData;
    private final OSIORestTaskSchema taskSchema;
    private final Space space;
    private final CommonHttpClient client;
    OldAttributes oldAttributes;
    List<NameValuePair> requestParameters;

    public OSIORestPatchUpdateTask(CommonHttpClient client, TaskData taskData, Set<TaskAttribute> oldAttributes, Space space) {
        super(client, "/workitems/" + taskData.getRoot().getAttribute(OSIORestTaskSchema.getDefault().UUID.getKey()).getValue(), true);
        this.taskData = taskData;
        this.taskSchema = OSIORestTaskSchema.getDefault();
        this.space = space;
        this.client = client;
        this.oldAttributes = new OldAttributes(oldAttributes);
    }

    @Override
    protected void addHttpRequestEntities(HttpRequestBase request) throws OSIORestException {
        super.addHttpRequestEntities(request);
        try {
            Gson gson = new GsonBuilder().registerTypeAdapter(OldAttributes.class, (Object)new TaskAttributeTypeAdapter(this.getClient().getLocation())).create();
            StringEntity requestEntity = new StringEntity(gson.toJson((Object)this.oldAttributes));
            ((HttpPatch)request).setEntity((HttpEntity)requestEntity);
        }
        catch (UnsupportedEncodingException e) {
            Throwables.propagate((Throwable)new CoreException((IStatus)new Status(4, "org.eclipse.linuxtools.mylyn.osio.rest.core", "Can not build HttpRequest", (Throwable)e)));
        }
    }

    public static String convert(String str) {
        str = str.replace("\"", "\\\"").replace("\n", "\\\n");
        StringBuffer ostr = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            if (ch >= ' ' && ch <= '~') {
                ostr.append(ch);
            } else {
                ostr.append("\\u");
                String hex = Integer.toHexString(str.charAt(i) & 0xFFFF);
                int j = 0;
                while (j < 4 - hex.length()) {
                    ostr.append("0");
                    ++j;
                }
                ostr.append(hex.toLowerCase());
            }
            ++i;
        }
        return new String(ostr);
    }

    @Override
    protected TaskData parseFromJson(InputStreamReader in) {
        TypeToken<TaskData> type = new TypeToken<TaskData>(){};
        return (TaskData)new GsonBuilder().registerTypeAdapter(type.getType(), (Object)new JSonTaskDataDeserializer()).create().fromJson((Reader)in, type.getType());
    }

    private class JSonTaskDataDeserializer
    implements JsonDeserializer<TaskData> {
        private JSonTaskDataDeserializer() {
        }

        public TaskData deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject workitemdata = json.getAsJsonObject().get("data").getAsJsonObject();
            JsonObject attributes = workitemdata.get("attributes").getAsJsonObject();
            String version = attributes.get("version").getAsString();
            TaskAttribute versionAttr = OSIORestPatchUpdateTask.this.taskData.getRoot().getAttribute(((OSIORestPatchUpdateTask)OSIORestPatchUpdateTask.this).taskSchema.VERSION.getKey());
            versionAttr.setValue(version);
            String updateString = attributes.get("system.updated_at").getAsString();
            TaskAttribute updatedAt = OSIORestPatchUpdateTask.this.taskData.getRoot().getAttribute(((OSIORestPatchUpdateTask)OSIORestPatchUpdateTask.this).taskSchema.DATE_MODIFICATION.getKey());
            try {
                SimpleDateFormat iso8601Format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSS'Z'", Locale.US);
                iso8601Format.setTimeZone(TimeZone.getTimeZone("UTC"));
                Date tempDate = iso8601Format.parse(updateString);
                updatedAt.setValue(Long.toString(tempDate.getTime()));
            }
            catch (ParseException e) {
                Throwables.propagate((Throwable)new CoreException((IStatus)new Status(4, "org.eclipse.linuxtools.mylyn.osio.rest.core", "Can not parse Date (" + updateString + ")")));
            }
            return OSIORestPatchUpdateTask.this.taskData;
        }
    }

    public class OldAttributes {
        private final Set<TaskAttribute> oldAttributes;

        public OldAttributes(Set<TaskAttribute> oldAttributes) {
            this.oldAttributes = oldAttributes;
        }

        public Set<TaskAttribute> getOldAttributes() {
            return this.oldAttributes;
        }
    }

    public class TaskAttributeTypeAdapter
    extends TypeAdapter<OldAttributes> {
        RepositoryLocation location;

        public TaskAttributeTypeAdapter(RepositoryLocation location) {
            this.location = location;
        }

        public void write(JsonWriter out, OldAttributes oldValues) throws IOException {
            List labelAdditions;
            List additions;
            String iterationName;
            out.beginObject();
            out.name("data");
            out.beginObject();
            out.name("attributes");
            out.beginObject();
            TaskAttribute attribute = OSIORestPatchUpdateTask.this.taskData.getRoot().getAttribute(((OSIORestPatchUpdateTask)OSIORestPatchUpdateTask.this).taskSchema.DESCRIPTION.getKey());
            String attValue = attribute.getValue() == null ? "" : attribute.getValue();
            out.name("system.description").value(attValue);
            attribute = OSIORestPatchUpdateTask.this.taskData.getRoot().getAttribute("task.common.operation") != null ? OSIORestPatchUpdateTask.this.taskData.getRoot().getAttribute("task.common.operation") : OSIORestPatchUpdateTask.this.taskData.getRoot().getAttribute(((OSIORestPatchUpdateTask)OSIORestPatchUpdateTask.this).taskSchema.STATUS.getKey());
            attValue = attribute.getValue();
            out.name("system.state").value(attValue);
            attribute = OSIORestPatchUpdateTask.this.taskData.getRoot().getAttribute(((OSIORestPatchUpdateTask)OSIORestPatchUpdateTask.this).taskSchema.SUMMARY.getKey());
            attValue = attribute.getValue();
            out.name("system.title").value(attValue);
            attribute = OSIORestPatchUpdateTask.this.taskData.getRoot().getAttribute(((OSIORestPatchUpdateTask)OSIORestPatchUpdateTask.this).taskSchema.VERSION.getKey());
            attValue = attribute.getValue();
            out.name("version").value(attValue);
            out.endObject();
            attribute = OSIORestPatchUpdateTask.this.taskData.getRoot().getAttribute(((OSIORestPatchUpdateTask)OSIORestPatchUpdateTask.this).taskSchema.UUID.getKey());
            attValue = attribute.getValue();
            out.name("id").value(attValue);
            out.name("relationships");
            out.beginObject();
            out.name("space");
            out.beginObject();
            out.name("data");
            out.beginObject();
            attribute = OSIORestPatchUpdateTask.this.taskData.getRoot().getAttribute(((OSIORestPatchUpdateTask)OSIORestPatchUpdateTask.this).taskSchema.SPACE.getKey());
            out.name("id").value(OSIORestPatchUpdateTask.this.space.getId());
            out.name("type").value("spaces");
            out.endObject();
            out.endObject();
            attribute = OSIORestPatchUpdateTask.this.taskData.getRoot().getAttribute(((OSIORestPatchUpdateTask)OSIORestPatchUpdateTask.this).taskSchema.AREA.getKey());
            String areaName = attribute.getValue();
            if (areaName != null && !areaName.trim().isEmpty()) {
                out.name("area");
                out.beginObject();
                out.name("data");
                out.beginObject();
                Area area = OSIORestPatchUpdateTask.this.space.getAreas().get(areaName);
                out.name("id").value(area.getId());
                out.name("type").value("areas");
                out.endObject();
                out.endObject();
            }
            if ((iterationName = (attribute = OSIORestPatchUpdateTask.this.taskData.getRoot().getAttribute(((OSIORestPatchUpdateTask)OSIORestPatchUpdateTask.this).taskSchema.ITERATION.getKey())).getValue()) != null && !iterationName.trim().isEmpty()) {
                out.name("iteration");
                out.beginObject();
                out.name("data");
                out.beginObject();
                Iteration iteration = OSIORestPatchUpdateTask.this.space.getIterations().get(iterationName);
                out.name("id").value(iteration.getId());
                out.name("type").value("iterations");
                out.endObject();
                out.endObject();
            }
            out.name("assignees");
            out.beginObject();
            attribute = OSIORestPatchUpdateTask.this.taskData.getRoot().getAttribute(((OSIORestPatchUpdateTask)OSIORestPatchUpdateTask.this).taskSchema.ASSIGNEES.getKey());
            ArrayList<String> assignees = attribute.getValues();
            assignees = assignees == null ? new ArrayList<String>() : new ArrayList(assignees);
            attribute = OSIORestPatchUpdateTask.this.taskData.getRoot().getAttribute(((OSIORestPatchUpdateTask)OSIORestPatchUpdateTask.this).taskSchema.REMOVE_ASSIGNEE.getKey());
            List removals = attribute.getValues();
            if (removals != null) {
                for (String removal : removals) {
                    int index = assignees.indexOf(removal);
                    if (index < 0) continue;
                    assignees.remove(index);
                }
            }
            if ((additions = (attribute = OSIORestPatchUpdateTask.this.taskData.getRoot().getAttribute(((OSIORestPatchUpdateTask)OSIORestPatchUpdateTask.this).taskSchema.ADD_ASSIGNEE.getKey())).getValues()) != null) {
                for (String addition : additions) {
                    int index = assignees.indexOf(addition);
                    if (index >= 0) continue;
                    assignees.add(addition);
                }
            }
            if (assignees.size() > 0 && !((String)assignees.get(0)).isEmpty()) {
                Map<String, User> users = OSIORestPatchUpdateTask.this.space.getUsers();
                out.name("data");
                out.beginArray();
                for (String assignee : assignees) {
                    if (assignee == null || assignee.isEmpty()) continue;
                    User user = users.get(assignee);
                    if (user == null) {
                        throw new UnsupportedOperationException(OSIORestMessages.getFormattedString("UnknownAssignee.msg", assignee));
                    }
                    String userid = user.getId();
                    out.beginObject();
                    out.name("id").value(userid);
                    out.name("type").value("users");
                    out.endObject();
                }
                out.endArray();
            }
            out.endObject();
            attribute = OSIORestPatchUpdateTask.this.taskData.getRoot().getAttribute(((OSIORestPatchUpdateTask)OSIORestPatchUpdateTask.this).taskSchema.LABELS.getKey());
            ArrayList<String> labels = attribute.getValues();
            labels = labels == null ? new ArrayList<String>() : new ArrayList(labels);
            attribute = OSIORestPatchUpdateTask.this.taskData.getRoot().getAttribute(((OSIORestPatchUpdateTask)OSIORestPatchUpdateTask.this).taskSchema.REMOVE_LABEL.getKey());
            List labelRemovals = attribute.getValues();
            if (labelRemovals != null) {
                for (String removal : labelRemovals) {
                    int index = labels.indexOf(removal);
                    if (index < 0) continue;
                    labels.remove(index);
                }
            }
            if ((labelAdditions = (attribute = OSIORestPatchUpdateTask.this.taskData.getRoot().getAttribute(((OSIORestPatchUpdateTask)OSIORestPatchUpdateTask.this).taskSchema.ADD_LABEL.getKey())).getValues()) != null) {
                for (String addition : labelAdditions) {
                    int index = labels.indexOf(addition);
                    if (index >= 0) continue;
                    labels.add(addition);
                }
            }
            out.name("labels");
            out.beginObject();
            out.name("data");
            out.beginArray();
            if (labels.size() > 0 && !((String)labels.get(0)).isEmpty()) {
                Map<String, Label> spaceLabels = OSIORestPatchUpdateTask.this.space.getLabels();
                for (String label : labels) {
                    Label l = spaceLabels.get(label);
                    if (l == null && !label.trim().isEmpty()) {
                        try {
                            LabelResponse response = (LabelResponse)new OSIORestPostNewLabelTask(OSIORestPatchUpdateTask.this.client, OSIORestPatchUpdateTask.this.space, label).run(new NullOperationMonitor());
                            Label newLabel = response.getData();
                            spaceLabels.put(label, newLabel);
                        }
                        catch (OSIORestException e) {
                            e.printStackTrace();
                        }
                    }
                    if ((l = spaceLabels.get(label)) == null) continue;
                    String labelid = l.getId();
                    out.beginObject();
                    out.name("id").value(labelid);
                    out.name("type").value("labels");
                    out.endObject();
                }
            }
            out.endArray();
            out.endObject();
            out.endObject();
            out.name("type").value("workitems");
            out.endObject();
            out.name("included");
            out.beginArray();
            out.value(true);
            out.endArray();
            out.endObject();
        }

        public OldAttributes read(JsonReader in) throws IOException {
            throw new UnsupportedOperationException("TaskAttributeTypeAdapter in OSIORestPatchUpdateTask only supports write");
        }
    }
}

