/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.mylyn.osio.rest.core;

import com.google.common.base.Throwables;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.NullOperationMonitor;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestException;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestGetUser;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestGsonUtil;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestPostRequest;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestTaskSchema;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.Identity;
import org.eclipse.mylyn.commons.repositories.core.RepositoryLocation;
import org.eclipse.mylyn.commons.repositories.http.core.CommonHttpClient;
import org.eclipse.mylyn.tasks.core.IRepositoryPerson;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskCommentMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;

public class OSIORestPostNewCommentTask
extends OSIORestPostRequest<TaskAttribute> {
    private final TaskData taskData;
    private final CommonHttpClient client;
    OldAttributes oldAttributes;
    List<NameValuePair> requestParameters;
    OSIORestTaskSchema taskSchema = OSIORestTaskSchema.getDefault();

    public OSIORestPostNewCommentTask(CommonHttpClient client, TaskData taskData, Set<TaskAttribute> oldAttributes) {
        super(client, "/workitems/" + taskData.getRoot().getAttribute(OSIORestTaskSchema.getDefault().UUID.getKey()).getValue() + "/comments", true);
        this.taskData = taskData;
        this.client = client;
        this.oldAttributes = new OldAttributes(oldAttributes);
    }

    @Override
    protected void addHttpRequestEntities(HttpRequestBase request) throws OSIORestException {
        super.addHttpRequestEntities(request);
        try {
            Gson gson = new GsonBuilder().registerTypeAdapter(OldAttributes.class, (Object)new TaskAttributeTypeAdapter(this.getClient().getLocation())).create();
            StringEntity requestEntity = new StringEntity(gson.toJson((Object)this.oldAttributes));
            ((HttpPost)request).setEntity((HttpEntity)requestEntity);
        }
        catch (UnsupportedEncodingException e) {
            Throwables.propagate((Throwable)new CoreException((IStatus)new Status(4, "org.eclipse.linuxtools.mylyn.osio.rest.core", "Can not build HttpRequest", (Throwable)e)));
        }
    }

    public static String convert(String str) {
        str = str.replace("\"", "\\\"").replace("\n", "\\\n");
        StringBuffer ostr = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            if (ch >= ' ' && ch <= '~') {
                ostr.append(ch);
            } else {
                ostr.append("\\u");
                String hex = Integer.toHexString(str.charAt(i) & 0xFFFF);
                int j = 0;
                while (j < 4 - hex.length()) {
                    ostr.append("0");
                    ++j;
                }
                ostr.append(hex.toLowerCase());
            }
            ++i;
        }
        return new String(ostr);
    }

    @Override
    protected TaskAttribute parseFromJson(InputStreamReader in) {
        TypeToken<TaskAttribute> type = new TypeToken<TaskAttribute>(){};
        return (TaskAttribute)new GsonBuilder().registerTypeAdapter(type.getType(), (Object)new JSonTaskDataDeserializer()).create().fromJson((Reader)in, type.getType());
    }

    private class JSonTaskDataDeserializer
    implements JsonDeserializer<TaskAttribute> {
        private JSonTaskDataDeserializer() {
        }

        public TaskAttribute deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            int i = 0;
            JsonObject commentEntry = (JsonObject)json.getAsJsonObject().get("data");
            JsonObject comment = commentEntry.getAsJsonObject();
            JsonObject attributes = comment.get("attributes").getAsJsonObject();
            JsonObject relationships = comment.get("relationships").getAsJsonObject();
            JsonObject creator = relationships.get("creator").getAsJsonObject();
            JsonObject creatorData = creator.get("data").getAsJsonObject();
            JsonObject commentLinks = comment.get("links").getAsJsonObject();
            TaskAttribute attribute = OSIORestPostNewCommentTask.this.taskData.getRoot().createAttribute("task.common.comment-" + i);
            TaskAttribute numComments = OSIORestPostNewCommentTask.this.taskData.getRoot().getAttribute(OSIORestTaskSchema.getDefault().COMMENT_COUNT.getKey());
            numComments.setValue(Integer.toString(i));
            TaskCommentMapper taskComment = TaskCommentMapper.createFrom((TaskAttribute)attribute);
            taskComment.setCommentId(comment.get("id").getAsString());
            taskComment.setNumber(Integer.valueOf(i));
            taskComment.setUrl(commentLinks.get("self").getAsString());
            String id = creatorData.get("id").getAsString();
            Identity user = null;
            String email = "??????";
            String fullName = "???";
            try {
                user = (Identity)new OSIORestGetUser(OSIORestPostNewCommentTask.this.client, id).run(new NullOperationMonitor());
                email = user.getEmail();
                fullName = user.getFullName();
            }
            catch (OSIORestException e1) {
                e1.printStackTrace();
            }
            IRepositoryPerson author = OSIORestPostNewCommentTask.this.taskData.getAttributeMapper().getTaskRepository().createPerson(email);
            author.setName(fullName);
            taskComment.setAuthor(author);
            taskComment.setIsPrivate(null);
            try {
                SimpleDateFormat iso8601Format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSS'Z'", Locale.US);
                iso8601Format.setTimeZone(TimeZone.getTimeZone("UTC"));
                Date tempDate = iso8601Format.parse(attributes.get("created-at").getAsString());
                taskComment.setCreationDate(tempDate);
            }
            catch (ParseException e) {
                Throwables.propagate((Throwable)new CoreException((IStatus)new Status(4, "org.eclipse.linuxtools.mylyn.osio.rest.core", "Can not parse Date (" + attributes.get("created-at").getAsString() + ")")));
            }
            if (attributes.get("body.rendered").getAsString() != null) {
                String commentText = attributes.get("body.rendered").getAsString().trim();
                taskComment.setText(commentText);
            }
            taskComment.applyTo(attribute);
            return attribute;
        }
    }

    public class OldAttributes {
        private final Set<TaskAttribute> oldAttributes;

        public OldAttributes(Set<TaskAttribute> oldAttributes) {
            this.oldAttributes = oldAttributes;
        }
    }

    public class TaskAttributeTypeAdapter
    extends TypeAdapter<OldAttributes> {
        RepositoryLocation location;

        public TaskAttributeTypeAdapter(RepositoryLocation location) {
            this.location = location;
        }

        public void write(JsonWriter out, OldAttributes oldValues) throws IOException {
            out.beginObject();
            out.name("data");
            out.beginObject();
            for (TaskAttribute element : oldValues.oldAttributes) {
                TaskAttribute taskAttribute = OSIORestPostNewCommentTask.this.taskData.getRoot().getAttribute(element.getId());
                String id = taskAttribute.getId();
                String value = OSIORestGsonUtil.convertString2GSonString(taskAttribute.getValue());
                if (!(id = OSIORestTaskSchema.getFieldNameFromAttributeName(id)).equals(OSIORestTaskSchema.getDefault().NEW_COMMENT.getKey())) continue;
                out.name("attributes");
                out.beginObject();
                out.name("body").value(value);
                out.name("markup").value("Markdown");
                out.endObject();
            }
            out.name("type").value("comments");
            out.endObject();
            out.name("included").beginArray();
            out.endArray();
            out.endObject();
        }

        public OldAttributes read(JsonReader in) throws IOException {
            throw new UnsupportedOperationException("TaskAttributeTypeAdapter in OSIORestPatchUpdateTask only supports write");
        }
    }
}

