/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.mylyn.osio.rest.core;

import com.google.common.base.Throwables;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestException;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestPostRequest;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.LinkResponse;
import org.eclipse.mylyn.commons.core.operations.IOperationMonitor;
import org.eclipse.mylyn.commons.repositories.http.core.CommonHttpClient;
import org.eclipse.mylyn.commons.repositories.http.core.CommonHttpResponse;

public class OSIORestPostNewLink
extends OSIORestPostRequest<LinkResponse> {
    private final String linkid;
    private final String sourceid;
    private final String targetid;
    private final boolean isForward;
    List<NameValuePair> requestParameters;

    public OSIORestPostNewLink(CommonHttpClient client, String linkid, String sourceid, String targetid, boolean isForward) {
        super(client, "/workitems/" + (isForward ? sourceid : targetid) + "/relationships/links", true);
        this.linkid = linkid;
        this.sourceid = sourceid;
        this.targetid = targetid;
        this.isForward = isForward;
    }

    @Override
    protected void addHttpRequestEntities(HttpRequestBase request) throws OSIORestException {
        super.addHttpRequestEntities(request);
        try {
            Gson gson = new GsonBuilder().registerTypeAdapter(String.class, (Object)new TaskAttributeTypeAdapter()).create();
            StringEntity requestEntity = new StringEntity(gson.toJson((Object)"unused"));
            ((HttpPost)request).setEntity((HttpEntity)requestEntity);
        }
        catch (UnsupportedEncodingException e) {
            Throwables.propagate((Throwable)new CoreException((IStatus)new Status(4, "org.eclipse.linuxtools.mylyn.osio.rest.core", "Can not build HttpRequest", (Throwable)e)));
        }
    }

    public static String convert(String str) {
        str = str.replace("\"", "\\\"").replace("\n", "\\\n");
        StringBuffer ostr = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            if (ch >= ' ' && ch <= '~') {
                ostr.append(ch);
            } else {
                ostr.append("\\u");
                String hex = Integer.toHexString(str.charAt(i) & 0xFFFF);
                int j = 0;
                while (j < 4 - hex.length()) {
                    ostr.append("0");
                    ++j;
                }
                ostr.append(hex.toLowerCase());
            }
            ++i;
        }
        return new String(ostr);
    }

    @Override
    protected void doValidate(CommonHttpResponse response, IOperationMonitor monitor) throws IOException, OSIORestException {
        this.validate(response, 201, monitor);
    }

    @Override
    protected LinkResponse parseFromJson(InputStreamReader in) throws OSIORestException {
        return (LinkResponse)new Gson().fromJson((Reader)in, new TypeToken<LinkResponse>(){}.getType());
    }

    public class TaskAttributeTypeAdapter
    extends TypeAdapter<String> {
        public void write(JsonWriter out, String requestEntity) throws IOException {
            out.beginObject();
            out.name("data");
            out.beginObject();
            out.name("relationships");
            out.beginObject();
            out.name("link_type");
            out.beginObject();
            out.name("data");
            out.beginObject();
            out.name("id").value(OSIORestPostNewLink.this.linkid);
            out.name("type").value("workitemlinktypes");
            out.endObject();
            out.endObject();
            out.name("source");
            out.beginObject();
            out.name("data");
            out.beginObject();
            if (OSIORestPostNewLink.this.isForward) {
                out.name("id").value(OSIORestPostNewLink.this.sourceid);
            } else {
                out.name("id").value(OSIORestPostNewLink.this.targetid);
            }
            out.name("type").value("workitems");
            out.endObject();
            out.endObject();
            out.name("target");
            out.beginObject();
            out.name("data");
            out.beginObject();
            if (OSIORestPostNewLink.this.isForward) {
                out.name("id").value(OSIORestPostNewLink.this.targetid);
            } else {
                out.name("id").value(OSIORestPostNewLink.this.sourceid);
            }
            out.name("type").value("workitems");
            out.endObject();
            out.endObject();
            out.endObject();
            out.name("type").value("workitemlinks");
            out.endObject();
            out.name("included").beginArray();
            out.value(false);
            out.value(false);
            out.value(false);
            out.endArray();
            out.endObject();
        }

        public String read(JsonReader in) throws IOException {
            throw new UnsupportedOperationException("TaskAttributeTypeAdapter in OSIORestNewLabelTask only supports write");
        }
    }
}

