/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.mylyn.osio.rest.core;

import com.google.common.base.Throwables;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestConfiguration;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestConnector;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestException;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestPostRequest;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestTaskDataHandler;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestTaskSchema;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.Space;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.WorkItemTypeData;
import org.eclipse.mylyn.commons.core.operations.IOperationMonitor;
import org.eclipse.mylyn.commons.repositories.core.RepositoryLocation;
import org.eclipse.mylyn.commons.repositories.http.core.CommonHttpClient;
import org.eclipse.mylyn.commons.repositories.http.core.CommonHttpResponse;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;

public class OSIORestPostNewTask
extends OSIORestPostRequest<String> {
    private final TaskData taskData;
    private final Space space;
    private final TaskRepository taskRepository;
    private final OSIORestConnector connector;
    private final OSIORestConfiguration taskConfiguration;
    List<NameValuePair> requestParameters;
    OSIORestTaskSchema taskSchema = OSIORestTaskSchema.getDefault();

    public OSIORestPostNewTask(CommonHttpClient client, TaskData taskData, Space space, OSIORestConnector connector, TaskRepository taskRepository) throws CoreException {
        super(client, "/spaces/" + space.getId() + "/workitems", true);
        this.space = space;
        this.connector = connector;
        this.taskRepository = taskRepository;
        this.taskConfiguration = connector.getRepositoryConfiguration(taskRepository);
        this.taskData = taskData;
    }

    @Override
    protected void addHttpRequestEntities(HttpRequestBase request) throws OSIORestException {
        super.addHttpRequestEntities(request);
        try {
            Gson gson = new GsonBuilder().registerTypeAdapter(TaskData.class, (Object)new TaskAttributeTypeAdapter(this.getClient().getLocation())).create();
            StringEntity requestEntity = new StringEntity(gson.toJson((Object)this.taskData));
            ((HttpPost)request).setEntity((HttpEntity)requestEntity);
        }
        catch (UnsupportedEncodingException e) {
            Throwables.propagate((Throwable)new CoreException((IStatus)new Status(4, "org.eclipse.linuxtools.mylyn.osio.rest.core", "Can not build HttpRequest", (Throwable)e)));
        }
    }

    @Override
    protected void doValidate(CommonHttpResponse response, IOperationMonitor monitor) throws IOException, OSIORestException {
        this.validate(response, 201, monitor);
    }

    public static String convert(String str) {
        str = str.replace("\"", "\\\"").replace("\n", "\\\n");
        StringBuffer ostr = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            if (ch >= ' ' && ch <= '~') {
                ostr.append(ch);
            } else {
                ostr.append("\\u");
                String hex = Integer.toHexString(str.charAt(i) & 0xFFFF);
                int j = 0;
                while (j < 4 - hex.length()) {
                    ostr.append("0");
                    ++j;
                }
                ostr.append(hex.toLowerCase());
            }
            ++i;
        }
        return new String(ostr);
    }

    @Override
    protected String parseFromJson(InputStreamReader in) {
        TypeToken<String> type = new TypeToken<String>(){};
        return (String)new GsonBuilder().registerTypeAdapter(type.getType(), (Object)new JSonTaskDataDeserializer()).create().fromJson((Reader)in, type.getType());
    }

    private class JSonTaskDataDeserializer
    implements JsonDeserializer<String> {
        private JSonTaskDataDeserializer() {
        }

        public String deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            OSIORestTaskDataHandler dataHandler = (OSIORestTaskDataHandler)OSIORestPostNewTask.this.connector.getTaskDataHandler();
            dataHandler.getAttributeMapper(OSIORestPostNewTask.this.taskRepository);
            JsonObject workitemdata = json.getAsJsonObject().get("data").getAsJsonObject();
            JsonObject attributes = workitemdata.get("attributes").getAsJsonObject();
            JsonObject relationships = workitemdata.get("relationships").getAsJsonObject();
            JsonObject space = relationships.get("space").getAsJsonObject();
            JsonObject spaceData = space.get("data").getAsJsonObject();
            String spaceId = spaceData.get("id").getAsString();
            Map<String, Space> spaces = OSIORestPostNewTask.this.taskConfiguration.getSpaces();
            Space actualSpace = null;
            for (Space entry : spaces.values()) {
                if (!entry.getId().equals(spaceId)) continue;
                actualSpace = entry;
                break;
            }
            String spaceName = actualSpace.getName();
            int number = attributes.get("system.number").getAsInt();
            String taskId = String.valueOf(spaceName) + "#" + number;
            return taskId;
        }
    }

    public class TaskAttributeTypeAdapter
    extends TypeAdapter<TaskData> {
        RepositoryLocation location;

        public TaskAttributeTypeAdapter(RepositoryLocation location) {
            this.location = location;
        }

        public void write(JsonWriter out, TaskData taskData) throws IOException {
            String description;
            out.beginObject();
            out.name("data");
            out.beginObject();
            out.name("attributes");
            out.beginObject();
            out.name("system.state").value("new");
            TaskAttribute titleAttribute = taskData.getRoot().getAttribute(OSIORestPostNewTask.this.taskSchema.SUMMARY.getKey());
            out.name("system.title").value(titleAttribute.getValue());
            out.name("version").value("1");
            TaskAttribute descAttribute = taskData.getRoot().getAttribute(OSIORestPostNewTask.this.taskSchema.DESCRIPTION.getKey());
            if (descAttribute != null && (description = descAttribute.getValue()) != null && !description.isEmpty()) {
                out.name("system.description").value(description);
            }
            out.endObject();
            out.name("relationships");
            out.beginObject();
            out.name("baseType");
            out.beginObject();
            out.name("data");
            out.beginObject();
            TaskAttribute taskType = taskData.getRoot().getAttribute(OSIORestPostNewTask.this.taskSchema.WORKITEM_TYPE.getKey());
            WorkItemTypeData taskTypeData = OSIORestPostNewTask.this.space.getWorkItemTypes().get(taskType.getValue());
            out.name("id").value(taskTypeData.getId());
            out.name("type").value("workitemtypes");
            out.endObject();
            out.endObject();
            out.name("space");
            out.beginObject();
            out.name("data");
            out.beginObject();
            out.name("id").value(OSIORestPostNewTask.this.space.getId());
            out.name("type").value("spaces");
            out.endObject();
            out.endObject();
            out.endObject();
            out.name("type").value("workitems");
            out.endObject();
            out.name("included");
            out.beginArray();
            out.value(true);
            out.endArray();
            out.endObject();
        }

        public TaskData read(JsonReader in) throws IOException {
            throw new UnsupportedOperationException("TaskAttributeTypeAdapter in OSIORestPatchUpdateTask only supports write");
        }
    }
}

