/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.mylyn.osio.rest.core;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.function.Function;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestException;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestMessages;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestResourceMovedPermanentlyException;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestResourceNotFoundException;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.ErrorResponse;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.core.operations.IOperationMonitor;
import org.eclipse.mylyn.commons.repositories.core.auth.AuthenticationException;
import org.eclipse.mylyn.commons.repositories.core.auth.AuthenticationRequest;
import org.eclipse.mylyn.commons.repositories.core.auth.AuthenticationType;
import org.eclipse.mylyn.commons.repositories.core.auth.UserCredentials;
import org.eclipse.mylyn.commons.repositories.http.core.CommonHttpClient;
import org.eclipse.mylyn.commons.repositories.http.core.CommonHttpOperation;
import org.eclipse.mylyn.commons.repositories.http.core.CommonHttpResponse;
import org.eclipse.mylyn.commons.repositories.http.core.HttpUtil;
import org.eclipse.osgi.util.NLS;

public abstract class OSIORestRequest<T>
extends CommonHttpOperation<T> {
    protected static final String ACCEPT = "Accept";
    protected static final String CONTENT_TYPE = "Content-Type";
    protected static final String APPLICATION_VND_JSON = "application/vnd.jsonapierrors+json";
    protected static final String AUTHORIZATION = "Authorization";
    protected static final String TEXT_XML_CHARSET_UTF_8 = "text/xml; charset=UTF-8";
    private final boolean authenticationRequired;
    private final boolean needsAuthURL;
    private final String urlSuffix;

    public OSIORestRequest(CommonHttpClient client, String urlSuffix, boolean authenticationRequired, boolean needsAuthURL) {
        super(client);
        this.authenticationRequired = authenticationRequired;
        this.needsAuthURL = needsAuthURL;
        this.urlSuffix = urlSuffix;
    }

    protected T execute(IOperationMonitor monitor) throws IOException, OSIORestException {
        HttpRequestBase request = this.createHttpRequestBase();
        this.addHttpRequestEntities(request);
        CommonHttpResponse response = this.execute(request, monitor);
        return this.processAndRelease(response, monitor);
    }

    protected abstract T parseFromJson(InputStreamReader var1) throws OSIORestException;

    protected abstract HttpRequestBase createHttpRequestBase(String var1);

    protected HttpRequestBase createHttpRequestBase() {
        HttpRequestBase request = this.createHttpRequestBase(this.createHttpRequestURL());
        return request;
    }

    protected String baseUrl() {
        String url = this.getClient().getLocation().getUrl();
        if (this.needsAuthURL) {
            url = url.replace("https://", "https://auth.");
        } else if (this.needsAuthentication()) {
            url = url.replace("https://", "https://api.");
        }
        if (!url.endsWith("/api")) {
            url = String.valueOf(url) + "/api";
        }
        return url;
    }

    protected String getUrlSuffix() {
        return this.urlSuffix;
    }

    protected String createHttpRequestURL() {
        String urlSuffix = this.getUrlSuffix();
        return String.valueOf(this.baseUrl()) + urlSuffix;
    }

    private Function<IResource, String> getProvider() {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.jboss.tools.openshift.io.core.tokenProvider");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                return (Function)element.createExecutableExtension("class");
            }
            catch (CoreException e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.linuxtools.mylyn.osio.rest.core", OSIORestMessages.getString("TokenProviderFetchError.msg"), (Throwable)e));
                ++n2;
            }
        }
        return null;
    }

    private String getToken() {
        String auth_token = null;
        Function<IResource, String> provider = this.getProvider();
        if (provider != null) {
            auth_token = provider.apply(null);
        }
        if (auth_token != null) {
            return auth_token;
        }
        auth_token = this.getClient().getLocation().getProperty("osio.rest.authtoken");
        if (auth_token != null) {
            return auth_token;
        }
        return "";
    }

    private String getBearer() {
        return "Bearer " + this.getToken();
    }

    protected void addHttpRequestEntities(HttpRequestBase request) throws OSIORestException {
        request.setHeader(ACCEPT, APPLICATION_VND_JSON);
        if (this.authenticationRequired) {
            request.addHeader(AUTHORIZATION, this.getBearer());
        }
    }

    public T run(IOperationMonitor monitor) throws OSIORestException {
        try {
            return this.execute(monitor);
        }
        catch (IOException e) {
            throw new OSIORestException(e);
        }
    }

    protected T doProcess(CommonHttpResponse response, IOperationMonitor monitor) throws IOException, OSIORestException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedInputStream is = new BufferedInputStream(response.getResponseEntityAsStream());){
            InputStreamReader in = new InputStreamReader(is);
            this.throwExceptionIfRestError(is, in);
            return this.parseFromJson(in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected void doValidate(CommonHttpResponse response, IOperationMonitor monitor) throws IOException, OSIORestException {
        this.validate(response, 200, monitor);
    }

    protected void validate(CommonHttpResponse response, int expected, IOperationMonitor monitor) throws OSIORestException {
        int statusCode = response.getStatusCode();
        if (statusCode != expected && statusCode != 400) {
            if (statusCode == 404) {
                throw new OSIORestResourceNotFoundException(NLS.bind((String)"Requested resource ''{0}'' does not exist", (Object)response.getRequestPath()));
            }
            if (statusCode == 301) {
                throw new OSIORestResourceMovedPermanentlyException(response.getResponse().getAllHeaders()[0], NLS.bind((String)"Requested resource ''{0}'' has been moved permanently", (Object)response.getRequestPath()));
            }
            throw new OSIORestException(NLS.bind((String)"Unexpected response from OSIO REST server for ''{0}'': {1}", (Object)response.getRequestPath(), (Object)HttpUtil.getStatusText((int)statusCode)));
        }
    }

    protected T processAndRelease(CommonHttpResponse response, IOperationMonitor monitor) throws IOException, OSIORestException {
        try {
            this.doValidate(response, monitor);
            T t = this.doProcess(response, monitor);
            return t;
        }
        finally {
            response.release();
        }
    }

    protected void validate(HttpResponse response, IOperationMonitor monitor) throws AuthenticationException {
        super.validate(response, monitor);
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == 403) {
            AuthenticationRequest request = new AuthenticationRequest(this.getClient().getLocation(), AuthenticationType.REPOSITORY);
            throw new AuthenticationException(HttpUtil.getStatusText((int)statusCode), request, true);
        }
    }

    protected boolean needsAuthentication() {
        return this.authenticationRequired;
    }

    protected UserCredentials getCredentials() {
        UserCredentials credentials = (UserCredentials)this.getClient().getLocation().getCredentials(AuthenticationType.REPOSITORY);
        Preconditions.checkState((credentials != null ? 1 : 0) != 0, (Object)"Authentication requested without valid credentials");
        return credentials;
    }

    protected ErrorResponse parseErrorResponseFromJson(InputStreamReader in) throws OSIORestException {
        TypeToken<ErrorResponse> a = new TypeToken<ErrorResponse>(){};
        return (ErrorResponse)new Gson().fromJson((Reader)in, a.getType());
    }

    protected void throwExceptionIfRestError(InputStream is, InputStreamReader in) throws IOException, OSIORestException {
        try {
            is.mark(18);
            byte[] b = new byte[17];
            is.read(b);
            String str = new String(b);
            if (str.startsWith("{\"code\":") || str.startsWith("{\"message\":") || str.startsWith("{\"error\":") || str.startsWith("{\"documentation\":")) {
                is.reset();
                ErrorResponse resp = this.parseErrorResponseFromJson(in);
                throw new OSIORestResourceNotFoundException(NLS.bind((String)"Error {1}: {0}", (Object[])new Object[]{resp.getMessage(), resp.getCode()}));
            }
        }
        finally {
            is.reset();
        }
    }
}

