/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.mylyn.osio.rest.core;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestConfiguration;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestConnector;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestCreateTaskSchema;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestTaskSchema;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.IdNamed;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.Space;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.RepositoryStatus;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;

public class OSIORestTaskAttributeMapper
extends TaskAttributeMapper {
    private final OSIORestConnector connector;

    public OSIORestTaskAttributeMapper(TaskRepository taskRepository, OSIORestConnector connector) {
        super(taskRepository);
        this.connector = connector;
    }

    public Map<String, String> getOptions(@NonNull TaskAttribute attribute) {
        OSIORestTaskSchema taskSchema = OSIORestTaskSchema.getDefault();
        if (attribute.getId().equals(taskSchema.WORKITEM_TYPE.getKey()) || attribute.getId().equals(taskSchema.AREA.getKey()) || attribute.getId().equals(taskSchema.ASSIGNEES.getKey()) || attribute.getId().equals(taskSchema.STATUS.getKey()) || attribute.getId().equals(taskSchema.ITERATION.getKey())) {
            TaskAttribute spaceIdAttribute = attribute.getParentAttribute().getAttribute(OSIORestTaskSchema.getDefault().SPACE_ID.getKey());
            TaskAttribute spaceAttribute = attribute.getParentAttribute().getAttribute(OSIORestCreateTaskSchema.getDefault().SPACE.getKey());
            try {
                OSIORestConfiguration repositoryConfiguration = this.connector.getRepositoryConfiguration(this.getTaskRepository());
                if (repositoryConfiguration != null) {
                    if (spaceIdAttribute != null && !spaceIdAttribute.getValue().equals("")) {
                        attribute.clearOptions();
                        for (String spaceId : spaceIdAttribute.getValues()) {
                            Space actualSpace = this.connector.getClient(this.getTaskRepository()).getSpaceById(spaceId, this.getTaskRepository());
                            this.internalSetAttributeOptions4Space(attribute, actualSpace.getMapFor(attribute.getId()));
                        }
                    } else {
                        attribute.clearOptions();
                        for (String spaceName : spaceAttribute.getValues()) {
                            Space actualSpace = repositoryConfiguration.getSpaceWithName(spaceName);
                            this.internalSetAttributeOptions4Space(attribute, actualSpace.getMapFor(attribute.getId()));
                        }
                        if (attribute.getOptions().size() == 0 && attribute.getId().equals(taskSchema.ASSIGNEES.getKey())) {
                            String userName = repositoryConfiguration.getUserName();
                            attribute.putOption(userName, userName);
                        }
                    }
                }
            }
            catch (CoreException e) {
                StatusHandler.log((IStatus)new RepositoryStatus(this.getTaskRepository(), 4, "org.eclipse.linuxtools.mylyn.osio.rest.core", 0, "Failed to obtain repository configuration", (Throwable)e));
            }
        }
        return super.getOptions(attribute);
    }

    private void internalSetAttributeOptions4Space(TaskAttribute taskAttribute, Map<String, IdNamed> optionMap) {
        boolean found = false;
        String actualValue = taskAttribute.getValue();
        for (IdNamed entry : optionMap.values()) {
            taskAttribute.putOption(entry.getName(), entry.getName());
            found |= actualValue.equals(entry.getName());
        }
        if (!found) {
            taskAttribute.setValue("");
        }
    }

    public String mapToRepositoryKey(@NonNull TaskAttribute parent, @NonNull String key) {
        if (key.equals("task.common.key")) {
            return OSIORestTaskSchema.getDefault().ID.getKey();
        }
        if (key.equals("task.common.status")) {
            return OSIORestTaskSchema.getDefault().STATUS.getKey();
        }
        return super.mapToRepositoryKey(parent, key);
    }
}

