/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.mylyn.osio.rest.core;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestClient;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestConfiguration;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestConnector;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestCreateTaskSchema;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestException;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestTaskAttributeMapper;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestTaskSchema;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.SingleTaskDataCollector;
import org.eclipse.mylyn.commons.core.operations.IOperationMonitor;
import org.eclipse.mylyn.commons.core.operations.OperationUtil;
import org.eclipse.mylyn.commons.net.Policy;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.RepositoryResponse;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataCollector;

public class OSIORestTaskDataHandler
extends AbstractTaskDataHandler {
    protected final OSIORestConnector connector;

    public OSIORestTaskDataHandler(OSIORestConnector connector) {
        this.connector = connector;
    }

    public RepositoryResponse postTaskData(TaskRepository repository, TaskData taskData, Set<TaskAttribute> oldAttributes, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        try {
            monitor.beginTask("Submitting_task", -1);
            OSIORestClient client = this.connector.getClient(repository);
            try {
                IOperationMonitor progress = OperationUtil.convert((IProgressMonitor)monitor, (String)"post taskdata", (int)3);
                RepositoryResponse repositoryResponse = client.postTaskData(taskData, oldAttributes, repository, progress);
                return repositoryResponse;
            }
            catch (OSIORestException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.linuxtools.mylyn.osio.rest.core", 2, "Error post taskdata.\n\n" + e.getMessage(), (Throwable)e));
            }
        }
        finally {
            monitor.done();
        }
    }

    public boolean initializeTaskData(TaskRepository repository, TaskData data, ITaskMapping initializationData, IProgressMonitor monitor) throws CoreException {
        OSIORestConfiguration config;
        data.setVersion("0");
        if (data.isNew()) {
            OSIORestCreateTaskSchema.getDefault().initialize(data);
        } else {
            OSIORestTaskSchema.getDefault().initialize(data);
        }
        if (initializationData != null) {
            this.connector.getTaskMapping(data).merge(initializationData);
        }
        if ((config = this.connector.getRepositoryConfiguration(repository)) != null) {
            config.updateInitialTaskData(data);
        }
        return true;
    }

    public TaskAttributeMapper getAttributeMapper(TaskRepository repository) {
        return new OSIORestTaskAttributeMapper(repository, this.connector);
    }

    public TaskData getTaskData(TaskRepository repository, String taskId, IProgressMonitor monitor) throws CoreException {
        HashSet<String> taskIds = new HashSet<String>();
        taskIds.add(taskId);
        SingleTaskDataCollector singleTaskDataCollector = new SingleTaskDataCollector();
        this.getMultiTaskData(repository, taskIds, singleTaskDataCollector, monitor);
        if (singleTaskDataCollector.getTaskData() == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.linuxtools.mylyn.osio.rest.core", "Task data could not be retrieved. Please re-synchronize task"));
        }
        return singleTaskDataCollector.getTaskData();
    }

    public void getMultiTaskData(TaskRepository repository, Set<String> taskIds, TaskDataCollector collector, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        try {
            monitor.beginTask("retrive_task", -1);
            OSIORestClient client = this.connector.getClient(repository);
            try {
                IOperationMonitor progress = OperationUtil.convert((IProgressMonitor)monitor, (String)"post taskdata", (int)3);
                progress.addFlag(IOperationMonitor.OperationFlag.BACKGROUND);
                client.getTaskData(taskIds, repository, collector, progress);
            }
            catch (OSIORestException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.linuxtools.mylyn.osio.rest.core", 2, "Error get taskdata.\n\n" + e.getMessage(), (Throwable)e));
            }
        }
        finally {
            monitor.done();
        }
    }
}

