/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data;

import com.google.gson.annotations.SerializedName;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.Named;

public class IterationAttributes
implements Named {
    private String name;
    private String description;
    @SerializedName(value="created-at")
    private String created_at;
    @SerializedName(value="updated-at")
    private String updated_at;
    private String startAt;
    private String endAt;
    private String state;
    private boolean user_active;
    private boolean active_status;
    private String parent_path;
    private String resolved_parent_path;

    public IterationAttributes(String name, String description, String created_at, String updated_at, String startAt, String endAt, String state, boolean user_active, boolean active_status, String parent_path, String resolved_parent_path) {
        this.name = name;
        this.description = description;
        this.created_at = created_at;
        this.updated_at = updated_at;
        this.startAt = startAt;
        this.endAt = endAt;
        this.state = state;
        this.user_active = user_active;
        this.active_status = active_status;
        this.parent_path = parent_path;
        this.resolved_parent_path = resolved_parent_path;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Date getCreatedAt() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd-HH:mm:ss");
        Date d = null;
        try {
            d = sdf.parse(this.created_at.replace("Z", "").replace("T", "-"));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return d;
    }

    public Date getUpdatedAt() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd-HH:mm:ss");
        Date d = null;
        try {
            d = sdf.parse(this.updated_at.replace("Z", "").replace("T", "-"));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return d;
    }

    public Date getStartAt() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd-HH:mm:ss.SSSSSS");
        Date d = null;
        try {
            d = sdf.parse(this.startAt.replace("Z", "").replace("T", "-"));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return d;
    }

    public Date getEndAt() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd-HH:mm:ss.SSSSSS");
        Date d = null;
        try {
            d = sdf.parse(this.endAt.replace("Z", "").replace("T", "-"));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return d;
    }

    public String getState() {
        return this.state;
    }

    public boolean isUserActive() {
        return this.user_active;
    }

    public boolean isActiveStatus() {
        return this.active_status;
    }

    public String getParentPath() {
        return this.parent_path;
    }

    public String getResolvedParentPath() {
        return this.resolved_parent_path;
    }
}

