/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.Area;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.GenericLinksForSpace;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.IdNamed;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.Iteration;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.Label;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.SpaceAttributes;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.SpaceRelationships;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.User;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.WorkItemLinkTypeData;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.WorkItemTypeData;

public class Space
implements IdNamed {
    private String id;
    private String type;
    private SpaceAttributes attributes;
    private SpaceRelationships relationships;
    private GenericLinksForSpace links;
    private Map<String, WorkItemTypeData> workItemTypes;
    private Map<String, IdNamed> workItemTypesIdNamed;
    private Map<String, WorkItemLinkTypeData> workItemLinkTypes;
    private Map<String, Area> areas;
    private Map<String, IdNamed> areasIdNamed;
    private Map<String, Iteration> iterations;
    private Map<String, IdNamed> iterationsIdNamed;
    private Map<String, Label> labels;
    private Map<String, IdNamed> labelsIdNamed;
    private Map<String, User> users;
    private Map<String, IdNamed> usersIdNamed;
    private Map<String, IdNamed> statusNamed;

    public Space(String id, String type, SpaceAttributes attributes, SpaceRelationships relationships, GenericLinksForSpace links) {
        this.id = id;
        this.type = type;
        this.attributes = attributes;
        this.relationships = relationships;
        this.links = links;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public SpaceAttributes getAttributes() {
        return this.attributes;
    }

    @Override
    public String getName() {
        return this.attributes.getName();
    }

    public SpaceRelationships getRelationships() {
        return this.relationships;
    }

    public GenericLinksForSpace getLinks() {
        return this.links;
    }

    public void setWorkItemTypes(Map<String, WorkItemTypeData> workItemTypes) {
        this.workItemTypes = workItemTypes;
        this.workItemTypesIdNamed = new TreeMap<String, IdNamed>(workItemTypes.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (IdNamed)e.getValue())));
    }

    public Map<String, WorkItemTypeData> getWorkItemTypes() {
        return this.workItemTypes;
    }

    public void setWorkItemLinkTypes(Map<String, WorkItemLinkTypeData> workItemLinkTypes) {
        this.workItemLinkTypes = workItemLinkTypes;
    }

    public Map<String, WorkItemLinkTypeData> getWorkItemLinkTypes() {
        return this.workItemLinkTypes;
    }

    public void setUsers(Map<String, User> users) {
        this.users = users;
        this.usersIdNamed = users.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (IdNamed)e.getValue()));
    }

    public Map<String, User> getUsers() {
        return this.users;
    }

    public void setAreas(Map<String, Area> areas) {
        this.areas = areas;
        this.areasIdNamed = areas.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (IdNamed)e.getValue()));
    }

    public Map<String, Area> getAreas() {
        return this.areas;
    }

    public void setIterations(Map<String, Iteration> iterations) {
        this.iterations = iterations;
        this.iterationsIdNamed = iterations.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (IdNamed)e.getValue()));
    }

    public Map<String, Iteration> getIterations() {
        return this.iterations;
    }

    public void setLabels(Map<String, Label> labels) {
        this.labels = labels;
        this.labelsIdNamed = labels.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (IdNamed)e.getValue()));
    }

    public Map<String, Label> getLabels() {
        return this.labels;
    }

    public Map<String, IdNamed> getMapFor(String member) {
        if ("area".equals(member)) {
            return this.areasIdNamed;
        }
        if ("baseType".equals(member)) {
            return this.workItemTypesIdNamed;
        }
        if ("iteration".equals(member)) {
            return this.iterationsIdNamed;
        }
        if ("assignees".equals(member)) {
            return this.usersIdNamed;
        }
        if ("system.state".equals(member)) {
            if (this.statusNamed == null) {
                this.statusNamed = new LinkedHashMap<String, IdNamed>();
                this.statusNamed.put("new", new Status("new"));
                this.statusNamed.put("open", new Status("open"));
                this.statusNamed.put("in progress", new Status("in progress"));
                this.statusNamed.put("resolved", new Status("resolved"));
                this.statusNamed.put("closed", new Status("closed"));
            }
            return this.statusNamed;
        }
        if ("labels".equals(member)) {
            return this.labelsIdNamed;
        }
        return null;
    }

    private class Status
    implements IdNamed {
        private String name;

        public Status(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getId() {
            return "0";
        }
    }
}

