/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data;

import com.google.gson.annotations.SerializedName;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.Named;

public class WorkItemLinkTypeAttributes
implements Named {
    private String name;
    private String description;
    private int version;
    @SerializedName(value="created-at")
    private String created_at;
    @SerializedName(value="updated-at")
    private String updated_at;
    private String forward_name;
    private String reverse_name;
    private String topology;

    public WorkItemLinkTypeAttributes(String name, String description, int version, String created_at, String updated_at, String forward_name, String reverse_name, String topology) {
        this.name = name;
        this.description = description;
        this.version = version;
        this.created_at = created_at;
        this.updated_at = updated_at;
        this.forward_name = forward_name;
        this.reverse_name = reverse_name;
        this.topology = topology;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public int getVersion() {
        return this.version;
    }

    public String getCreated_at() {
        return this.created_at;
    }

    public String getUpdated_at() {
        return this.updated_at;
    }

    public Date getCreatedAt() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd-HH:mm:ss.SSSSSS");
        Date d = null;
        try {
            d = sdf.parse(this.created_at.replace("Z", "").replace("T", "-"));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return d;
    }

    public Date getUpdatedAt() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd-HH:mm:ss.SSSSSS");
        Date d = null;
        try {
            d = sdf.parse(this.updated_at.replace("Z", "").replace("T", "-"));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return d;
    }

    public String getForwardName() {
        return this.forward_name;
    }

    public String getReverseName() {
        return this.reverse_name;
    }

    public String getTopology() {
        return this.topology;
    }
}

