/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data;

import com.google.gson.annotations.SerializedName;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.WorkItemTypeField;

public class WorkItemTypeAttributes {
    private String name;
    private String description;
    private int version;
    private String extendedTypeName;
    @SerializedName(value="created-at")
    private String created_at;
    @SerializedName(value="updated-at")
    private String updated_at;
    private Map<String, WorkItemTypeField> fields;
    private String icon;

    public WorkItemTypeAttributes(String name, String description, int version, String extendedTypeName, String created_at, String updated_at, Map<String, WorkItemTypeField> fields) {
        this.name = name;
        this.description = description;
        this.version = version;
        this.extendedTypeName = extendedTypeName;
        this.created_at = created_at;
        this.updated_at = updated_at;
        this.fields = fields;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public int getVersion() {
        return this.version;
    }

    public String getExtendedTypeName() {
        return this.extendedTypeName;
    }

    public Date getCreatedAt() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd-HH:mm:ss.SSSSSS");
        Date d = null;
        try {
            d = sdf.parse(this.created_at.replace("Z", "").replace("T", "-"));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return d;
    }

    public Date getUpdatedAt() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd-HH:mm:ss.SSSSSS");
        Date d = null;
        try {
            d = sdf.parse(this.updated_at.replace("Z", "").replace("T", "-"));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return d;
    }

    public Map<String, WorkItemTypeField> getFields() {
        return this.fields;
    }

    public String getIcon() {
        return this.icon;
    }
}

