/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.mylyn.osio.rest.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestClient;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestConnector;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestTaskSchema;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.response.data.WorkItemResponse;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMetaData;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.mylyn.tasks.ui.editors.LayoutHint;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class OSIOAddLinksAttributeEditor
extends AbstractAttributeEditor {
    private Combo typeCombo;
    private Combo workitemCombo;
    private final AbstractRepositoryConnector connector;
    private final TaskRepository repository;
    private Map<String, String> linkTypes = new HashMap<String, String>();
    private Map<String, WorkItemResponse> workitems = new HashMap<String, WorkItemResponse>();
    private TaskAttribute attrAddLink;
    protected boolean suppressRefresh;

    public OSIOAddLinksAttributeEditor(TaskDataModel manager, AbstractRepositoryConnector connector, TaskAttribute taskAttribute) {
        super(manager, taskAttribute);
        this.connector = connector;
        this.repository = manager.getTaskRepository();
        this.setLayoutHint(new LayoutHint(LayoutHint.RowSpan.MULTIPLE, LayoutHint.ColumnSpan.MULTIPLE));
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(2, true));
        this.attrAddLink = this.getModel().getTaskData().getRoot().getMappedAttribute(OSIORestTaskSchema.getDefault().ADD_LINK.getKey());
        this.typeCombo = new Combo(comp, 12);
        toolkit.adapt((Control)this.typeCombo, true, true);
        this.typeCombo.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.typeCombo.setFont(JFaceResources.getDefaultFont());
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)this.typeCombo);
        this.typeCombo.setToolTipText(this.getDescription());
        this.typeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = OSIOAddLinksAttributeEditor.this.typeCombo.getSelectionIndex();
                String linkType = OSIOAddLinksAttributeEditor.this.typeCombo.getItem(index);
                TaskAttribute attr = OSIOAddLinksAttributeEditor.this.getTaskAttribute();
                attr.setValue(String.valueOf(linkType) + " " + OSIOAddLinksAttributeEditor.this.workitemCombo.getText());
                TaskAttributeMetaData metadata = attr.getMetaData();
                String linkid = OSIOAddLinksAttributeEditor.this.linkTypes.containsKey(linkType) ? (String)OSIOAddLinksAttributeEditor.this.linkTypes.get(linkType) : "";
                metadata.putValue("linkid", linkid);
                if (index % 2 == 1) {
                    metadata.putValue("direction", "forward");
                } else {
                    metadata.putValue("direction", "reverse");
                }
                OSIOAddLinksAttributeEditor.this.getModel().attributeChanged(OSIOAddLinksAttributeEditor.this.attrAddLink);
            }
        });
        this.workitemCombo = new Combo(comp, 12);
        toolkit.adapt((Control)this.workitemCombo, true, true);
        this.workitemCombo.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.workitemCombo.setFont(JFaceResources.getDefaultFont());
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)this.workitemCombo);
        this.workitemCombo.setToolTipText(this.getDescription());
        this.workitemCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = OSIOAddLinksAttributeEditor.this.workitemCombo.getSelectionIndex();
                String workitem = OSIOAddLinksAttributeEditor.this.workitemCombo.getItem(index);
                TaskAttribute attr = OSIOAddLinksAttributeEditor.this.getTaskAttribute();
                attr.setValue(String.valueOf(OSIOAddLinksAttributeEditor.this.typeCombo.getText()) + " " + workitem);
                TaskAttributeMetaData metadata = attr.getMetaData();
                metadata.putValue("targetWidName", workitem);
                metadata.putValue("targetWid", ((WorkItemResponse)OSIOAddLinksAttributeEditor.this.workitems.get(workitem)).getId());
                OSIOAddLinksAttributeEditor.this.getModel().attributeChanged(OSIOAddLinksAttributeEditor.this.attrAddLink);
            }
        });
        this.populateFromAttribute();
        this.setControl((Control)comp);
    }

    private void populateFromAttribute() {
        String spaceId = this.getTaskAttribute().getOption("space");
        try {
            OSIORestClient client = ((OSIORestConnector)this.connector).getClient(this.repository);
            this.linkTypes = client.getSpaceLinkTypes(spaceId, this.repository);
            this.workitems = client.getSpaceWorkItems(spaceId);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        this.typeCombo.setItems(this.linkTypes.keySet().toArray(new String[0]));
        this.typeCombo.add("", 0);
        String link = this.getTaskAttribute().getValue();
        int index = 0;
        if (link != null && !link.isEmpty()) {
            int i = 1;
            for (String linkType : this.linkTypes.keySet()) {
                if (link.startsWith(linkType)) {
                    index = i;
                }
                ++i;
            }
        }
        if (index >= 0) {
            this.typeCombo.select(index);
        }
        ArrayList<String> workitemsList = new ArrayList<String>();
        String sourceName = this.getModel().getTaskData().getRoot().getMappedAttribute(OSIORestTaskSchema.getDefault().SUMMARY.getKey()).getValue();
        for (String workitemName : this.workitems.keySet()) {
            if (workitemName.equals(sourceName)) continue;
            workitemsList.add(workitemName);
        }
        this.workitemCombo.setItems(workitemsList.toArray(new String[0]));
        index = -1;
        if (link != null && !link.isEmpty()) {
            int i = 0;
            for (String workitem : this.workitems.keySet()) {
                if (link.endsWith(workitem)) {
                    index = i;
                }
                ++i;
            }
        }
        if (index >= 0) {
            this.workitemCombo.select(index);
        }
    }

    public void refresh() {
        if (this.typeCombo != null && !this.typeCombo.isDisposed()) {
            this.typeCombo.removeAll();
            this.populateFromAttribute();
        }
    }

    public boolean shouldAutoRefresh() {
        return !this.suppressRefresh;
    }
}

