/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.mylyn.osio.rest.ui;

import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestTaskSchema;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.mylyn.tasks.ui.editors.LayoutHint;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class OSIOLabelAttributeEditor
extends AbstractAttributeEditor {
    private org.eclipse.swt.widgets.List list;
    private TaskAttribute attrRemoveLabel;
    protected boolean suppressRefresh;

    public OSIOLabelAttributeEditor(TaskDataModel manager, TaskAttribute taskAttribute) {
        super(manager, taskAttribute);
        this.setLayoutHint(new LayoutHint(LayoutHint.RowSpan.MULTIPLE, LayoutHint.ColumnSpan.MULTIPLE));
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        this.list = new org.eclipse.swt.widgets.List(parent, 0x800202);
        toolkit.adapt((Control)this.list, true, true);
        this.list.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.list.setFont(JFaceResources.getDefaultFont());
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)this.list);
        this.list.setToolTipText(this.getDescription());
        this.populateFromAttribute();
        this.attrRemoveLabel = this.getModel().getTaskData().getRoot().getMappedAttribute(OSIORestTaskSchema.getDefault().REMOVE_LABEL.getKey());
        this.selectValuesToRemove();
        this.list.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    OSIOLabelAttributeEditor.this.suppressRefresh = true;
                    String[] stringArray = OSIOLabelAttributeEditor.this.list.getItems();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String cc = stringArray[n2];
                        int index = OSIOLabelAttributeEditor.this.list.indexOf(cc);
                        if (OSIOLabelAttributeEditor.this.list.isSelected(index)) {
                            List remove = OSIOLabelAttributeEditor.this.attrRemoveLabel.getValues();
                            if (!remove.contains(cc)) {
                                OSIOLabelAttributeEditor.this.attrRemoveLabel.addValue(cc);
                            }
                        } else {
                            OSIOLabelAttributeEditor.this.attrRemoveLabel.removeValue(cc);
                        }
                        ++n2;
                    }
                    OSIOLabelAttributeEditor.this.getModel().attributeChanged(OSIOLabelAttributeEditor.this.attrRemoveLabel);
                }
                finally {
                    OSIOLabelAttributeEditor.this.suppressRefresh = false;
                }
            }
        });
        this.list.showSelection();
        this.setControl((Control)this.list);
    }

    private void populateFromAttribute() {
        TaskAttribute attrLabel = this.getTaskAttribute();
        if (attrLabel != null) {
            for (String value : attrLabel.getValues()) {
                this.list.add(value);
            }
        }
    }

    private void selectValuesToRemove() {
        for (String item : this.attrRemoveLabel.getValues()) {
            int i = this.list.indexOf(item);
            if (i == -1) continue;
            this.list.select(i);
        }
    }

    public void refresh() {
        if (this.list != null && !this.list.isDisposed()) {
            this.list.removeAll();
            this.populateFromAttribute();
            this.selectValuesToRemove();
        }
    }

    public boolean shouldAutoRefresh() {
        return !this.suppressRefresh;
    }
}

