/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.mylyn.osio.rest.ui;

import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestTaskSchema;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMetaData;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.mylyn.tasks.ui.editors.LayoutHint;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class OSIOLinksAttributeEditor
extends AbstractAttributeEditor {
    private org.eclipse.swt.widgets.List list;
    private TaskAttribute attrRemoveLinks;
    protected boolean suppressRefresh;

    public OSIOLinksAttributeEditor(TaskDataModel manager, TaskAttribute taskAttribute) {
        super(manager, taskAttribute);
        this.setLayoutHint(new LayoutHint(LayoutHint.RowSpan.MULTIPLE, LayoutHint.ColumnSpan.MULTIPLE));
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        this.list = new org.eclipse.swt.widgets.List(parent, 0x800202);
        toolkit.adapt((Control)this.list, true, true);
        this.list.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.list.setFont(JFaceResources.getDefaultFont());
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)this.list);
        this.list.setToolTipText(this.getDescription());
        this.populateFromAttribute();
        this.attrRemoveLinks = this.getModel().getTaskData().getRoot().getMappedAttribute(OSIORestTaskSchema.getDefault().REMOVE_LINKS.getKey());
        this.copyLinkMetaData();
        this.selectValuesToRemove();
        this.list.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    OSIOLinksAttributeEditor.this.suppressRefresh = true;
                    String[] stringArray = OSIOLinksAttributeEditor.this.list.getItems();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String cc = stringArray[n2];
                        int index = OSIOLinksAttributeEditor.this.list.indexOf(cc);
                        if (OSIOLinksAttributeEditor.this.list.isSelected(index)) {
                            List remove = OSIOLinksAttributeEditor.this.attrRemoveLinks.getValues();
                            if (!remove.contains(cc)) {
                                OSIOLinksAttributeEditor.this.attrRemoveLinks.addValue(cc);
                            }
                        } else {
                            OSIOLinksAttributeEditor.this.attrRemoveLinks.removeValue(cc);
                        }
                        ++n2;
                    }
                    OSIOLinksAttributeEditor.this.getModel().attributeChanged(OSIOLinksAttributeEditor.this.attrRemoveLinks);
                }
                finally {
                    OSIOLinksAttributeEditor.this.suppressRefresh = false;
                }
            }
        });
        this.list.showSelection();
        this.setControl((Control)this.list);
    }

    private void populateFromAttribute() {
        TaskAttribute attrLinks = this.getTaskAttribute();
        if (attrLinks != null) {
            for (String value : attrLinks.getValues()) {
                this.list.add(value);
            }
        }
    }

    private void copyLinkMetaData() {
        TaskAttribute attrLinks = this.getTaskAttribute();
        if (attrLinks != null) {
            TaskAttributeMetaData metadata = attrLinks.getMetaData();
            TaskAttributeMetaData removeMetaData = this.attrRemoveLinks.getMetaData();
            if (metadata != null) {
                for (String link : attrLinks.getValues()) {
                    String metaValue = metadata.getValue(link);
                    removeMetaData.putValue(link, metaValue);
                }
            }
        }
    }

    private void selectValuesToRemove() {
        for (String item : this.attrRemoveLinks.getValues()) {
            int i = this.list.indexOf(item);
            if (i == -1) continue;
            this.list.select(i);
        }
    }

    public void refresh() {
        if (this.list != null && !this.list.isDisposed()) {
            this.list.removeAll();
            this.populateFromAttribute();
            this.selectValuesToRemove();
        }
    }

    public boolean shouldAutoRefresh() {
        return !this.suppressRefresh;
    }
}

