/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.mylyn.osio.rest.ui;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.mylyn.commons.workbench.forms.CommonFormUtil;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.mylyn.tasks.ui.editors.LayoutHint;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class OSIOLongTextAttributeEditor
extends AbstractAttributeEditor {
    private Text text;
    private boolean suppressRefresh;

    public OSIOLongTextAttributeEditor(TaskDataModel manager, TaskAttribute taskAttribute) {
        super(manager, taskAttribute);
        this.setLayoutHint(new LayoutHint(LayoutHint.RowSpan.SINGLE, LayoutHint.ColumnSpan.MULTIPLE));
    }

    protected Text getText() {
        return this.text;
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        this.createControl(parent, toolkit, 0);
    }

    protected void createControl(Composite parent, FormToolkit toolkit, int style) {
        if (this.isReadOnly()) {
            this.text = new Text(parent, 0x800008);
            this.text.setFont(JFaceResources.getDefaultFont());
            this.text.setData("FormWidgetFactory.drawBorder", (Object)Boolean.FALSE);
            this.text.setToolTipText(this.getDescription());
            this.text.setText(this.getValue());
        } else {
            this.text = toolkit.createText(parent, this.getValue(), 0x800000 | style);
            this.text.setFont(JFaceResources.getDefaultFont());
            this.text.setData("FormWidgetFactory.drawBorder", (Object)"treeBorder");
            this.text.setToolTipText(this.getDescription());
            this.text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    try {
                        OSIOLongTextAttributeEditor.this.suppressRefresh = true;
                        OSIOLongTextAttributeEditor.this.setValue(OSIOLongTextAttributeEditor.this.text.getText());
                    }
                    finally {
                        OSIOLongTextAttributeEditor.this.suppressRefresh = false;
                    }
                    CommonFormUtil.ensureVisible((Control)OSIOLongTextAttributeEditor.this.text);
                }
            });
        }
        toolkit.adapt((Control)this.text, false, false);
        this.setControl((Control)this.text);
    }

    public String getValue() {
        return this.getAttributeMapper().getValue(this.getTaskAttribute());
    }

    public void setValue(String text) {
        this.getAttributeMapper().setValue(this.getTaskAttribute(), text);
        this.attributeChanged();
    }

    public void refresh() {
        if (this.text != null && !this.text.isDisposed()) {
            this.text.setText(this.getValue());
        }
    }

    public boolean shouldAutoRefresh() {
        return !this.suppressRefresh;
    }
}

