/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.mylyn.osio.rest.ui;

import com.google.common.base.Strings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.ui.Messages;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.wizards.AbstractRepositorySettingsPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class OSIORestRepositorySettingsPage
extends AbstractRepositorySettingsPage {
    private static final String DESCRIPTION = Messages.OSIORestRepositorySettingsPage_Description;
    private StyledText authToken;
    private Text userId;
    private Label authTokenLabel;
    private Label userIdLabel;

    public OSIORestRepositorySettingsPage(TaskRepository taskRepository, AbstractRepositoryConnector connector, AbstractRepositoryConnectorUi connectorUi) {
        super(Messages.OSIORestRepositorySettingsPage_RestRepositorySetting, DESCRIPTION, taskRepository, connector, connectorUi);
        this.setNeedsAnonymousLogin(true);
        this.setNeedsEncoding(false);
        this.setNeedsAdvanced(true);
        this.setNeedsValidateOnFinish(true);
    }

    public String getConnectorKind() {
        return "org.eclipse.linuxtools.mylyn.osio.rest";
    }

    protected void createAdditionalControls(Composite parent) {
        Composite authTokenContainer = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().margins(0, 0).numColumns(2).applyTo(authTokenContainer);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)authTokenContainer);
        this.userIdLabel = new Label(authTokenContainer, 0);
        this.userIdLabel.setText(Messages.OSIORestRepositorySettingsPage_auth_username);
        this.userId = new Text(authTokenContainer, 2048);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).hint(300, -1).applyTo((Control)this.userId);
        this.authTokenLabel = new Label(authTokenContainer, 0);
        this.authTokenLabel.setText(Messages.OSIORestRepositorySettingsPage_auth_token);
        this.authToken = new StyledText(authTokenContainer, 0x400840);
        this.authToken.setEnabled(true);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 0x1000000).hint(300, 600).applyTo((Control)this.authToken);
        if (this.repository != null) {
            String apiKeyValue = this.repository.getProperty("osio.rest.authtoken");
            this.authToken.setText(Strings.nullToEmpty((String)apiKeyValue));
            this.authToken.setEnabled(true);
        }
        this.updateURLInformation();
        this.serverUrlCombo.add("https://openshift.io/api");
        this.serverUrlCombo.select(0);
        this.serverUrlCombo.setEnabled(false);
        this.serverUrlCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                OSIORestRepositorySettingsPage.this.updateURLInformation();
            }
        });
        this.serverUrlCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OSIORestRepositorySettingsPage.this.updateURLInformation();
            }
        });
    }

    protected void updateURLInformation() {
        this.authTokenLabel.setToolTipText(NLS.bind((String)Messages.OSIORestRepositorySettingsPage_Please_copy_the_Auth_Token_from, null));
    }

    public void applyTo(TaskRepository repository) {
        repository.setProperty("osio.rest.authtoken", this.authToken.getText());
        repository.setProperty("osio.rest.userid", this.userId.getText());
        repository.setCategory("org.eclipse.mylyn.category.tasks");
        super.applyTo(repository);
    }
}

