/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.mylyn.osio.rest.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.mylyn.internal.tasks.ui.editors.EditorUtil;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorAttributePart;
import org.eclipse.mylyn.internal.tasks.ui.notifications.TaskDiffUtil;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.mylyn.tasks.ui.editors.LayoutHint;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class OSIORestTaskEditorAttributePart
extends TaskEditorAttributePart {
    private static final int LABEL_WIDTH = 220;
    private static final int COLUMN_WIDTH = 280;
    private static final int COLUMN_GAP = 40;
    private static final int MULTI_COLUMN_WIDTH = 830;
    private static final int MULTI_ROW_HEIGHT = 55;
    private boolean hasIncoming;
    private List<AbstractAttributeEditor> attributeEditors;
    private Composite attributesComposite;

    public void createControl(Composite parent, FormToolkit toolkit) {
        this.initialize();
        super.createControl(parent, toolkit);
    }

    public boolean hasIncoming() {
        return this.hasIncoming;
    }

    private void initialize() {
        this.attributeEditors = new ArrayList<AbstractAttributeEditor>();
        this.hasIncoming = false;
        Collection attributes = this.getAttributes();
        for (TaskAttribute attribute : attributes) {
            AbstractAttributeEditor attributeEditor = this.createAttributeEditor(attribute);
            if (attributeEditor == null) continue;
            this.attributeEditors.add(attributeEditor);
            if (!this.getModel().hasIncomingChanges(attribute)) continue;
            this.hasIncoming = true;
        }
        Comparator attributeSorter = this.createAttributeEditorSorter();
        if (attributeSorter != null) {
            Collections.sort(this.attributeEditors, attributeSorter);
        }
    }

    protected Control createContent(FormToolkit toolkit, Composite parent) {
        this.attributesComposite = toolkit.createComposite(parent);
        this.attributesComposite.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Control focus = event.display.getFocusControl();
                if (focus instanceof Text && !((Text)focus).getEditable()) {
                    OSIORestTaskEditorAttributePart.this.getManagedForm().getForm().setFocus();
                }
            }
        });
        GridLayout attributesLayout = EditorUtil.createSectionClientLayout();
        attributesLayout.numColumns = 4;
        attributesLayout.horizontalSpacing = 9;
        attributesLayout.verticalSpacing = 6;
        this.attributesComposite.setLayout((Layout)attributesLayout);
        GridData attributesData = new GridData(1808);
        attributesData.horizontalSpan = 1;
        attributesData.grabExcessHorizontalSpace = true;
        attributesData.grabExcessVerticalSpace = false;
        this.attributesComposite.setLayoutData((Object)attributesData);
        this.createAttributeControls(this.attributesComposite, toolkit, attributesLayout.numColumns);
        toolkit.paintBordersFor(this.attributesComposite);
        return this.attributesComposite;
    }

    private void createAttributeControls(Composite attributesComposite, FormToolkit toolkit, int columnCount) {
        int currentColumn = 1;
        int currentPriority = 0;
        for (AbstractAttributeEditor attributeEditor : this.attributeEditors) {
            int priority;
            int n = priority = attributeEditor.getLayoutHint() != null ? attributeEditor.getLayoutHint().getPriority() : 10;
            if (priority != currentPriority) {
                currentPriority = priority;
                if (currentColumn > 1) {
                    while (currentColumn <= columnCount) {
                        this.getManagedForm().getToolkit().createLabel(attributesComposite, "");
                        ++currentColumn;
                    }
                    currentColumn = 1;
                }
            }
            if (attributeEditor.hasLabel()) {
                attributeEditor.createLabelControl(attributesComposite, toolkit);
                Label label = attributeEditor.getLabelControl();
                String text = label.getText();
                String shortenText = TaskDiffUtil.shortenText((Drawable)label, (String)text, (int)220);
                label.setText(shortenText);
                if (!text.equals(shortenText)) {
                    label.setToolTipText(text);
                }
                GridData gd = GridDataFactory.fillDefaults().align(131072, 0x1000000).hint(220, -1).create();
                if (currentColumn > 1) {
                    gd.horizontalIndent = 40;
                    gd.widthHint = 260;
                }
                label.setLayoutData((Object)gd);
                ++currentColumn;
            }
            attributeEditor.createControl(attributesComposite, toolkit);
            LayoutHint layoutHint = attributeEditor.getLayoutHint();
            GridData gd = new GridData(4, 0x1000000, false, false);
            LayoutHint.RowSpan rowSpan = layoutHint != null && layoutHint.rowSpan != null ? layoutHint.rowSpan : LayoutHint.RowSpan.SINGLE;
            LayoutHint.ColumnSpan columnSpan = layoutHint != null && layoutHint.columnSpan != null ? layoutHint.columnSpan : LayoutHint.ColumnSpan.SINGLE;
            gd.horizontalIndent = 1;
            if (rowSpan == LayoutHint.RowSpan.SINGLE && columnSpan == LayoutHint.ColumnSpan.SINGLE) {
                gd.widthHint = 280;
                gd.horizontalSpan = 1;
            } else {
                if (rowSpan == LayoutHint.RowSpan.MULTIPLE) {
                    gd.heightHint = 55;
                }
                if (columnSpan == LayoutHint.ColumnSpan.SINGLE) {
                    gd.widthHint = 280;
                    gd.horizontalSpan = 1;
                } else {
                    gd.widthHint = 830;
                    gd.horizontalSpan = columnCount - currentColumn + 1;
                }
            }
            attributeEditor.getControl().setLayoutData((Object)gd);
            this.getTaskEditorPage().getAttributeEditorToolkit().adapt(attributeEditor);
            currentColumn += gd.horizontalSpan;
            currentColumn %= columnCount;
        }
    }

    protected boolean shouldExpandOnCreate() {
        return this.getTaskData().isNew() || this.hasIncoming;
    }
}

