/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.mylyn.osio.rest.ui;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.commons.ui.FillWidthLayout;
import org.eclipse.mylyn.commons.ui.SelectionProviderAdapter;
import org.eclipse.mylyn.commons.ui.compatibility.CommonColors;
import org.eclipse.mylyn.commons.workbench.forms.CommonFormUtil;
import org.eclipse.mylyn.commons.workbench.forms.ScalingHyperlink;
import org.eclipse.mylyn.internal.tasks.core.TaskComment;
import org.eclipse.mylyn.internal.tasks.ui.actions.CommentActionGroup;
import org.eclipse.mylyn.internal.tasks.ui.editors.AbstractReplyToCommentAction;
import org.eclipse.mylyn.internal.tasks.ui.editors.CommentGroupStrategy;
import org.eclipse.mylyn.internal.tasks.ui.editors.EditorUtil;
import org.eclipse.mylyn.internal.tasks.ui.editors.RichTextAttributeEditor;
import org.eclipse.mylyn.internal.tasks.ui.editors.UserAttributeEditor;
import org.eclipse.mylyn.tasks.core.IRepositoryPerson;
import org.eclipse.mylyn.tasks.core.ITaskComment;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPage;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPart;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class OSIOWorkitemLinkAttributeEditor
extends AbstractTaskEditorPart {
    private static final String ID_POPUP_MENU = "org.eclipse.mylyn.tasks.ui.editor.menu.comments";
    private static final int INDENT = -6;
    private static final String KEY_EDITOR = "viewer";
    private List<TaskAttribute> commentAttributes;
    private CommentGroupStrategy commentGroupStrategy = new CommentGroupStrategy(){

        protected boolean hasIncomingChanges(ITaskComment taskComment) {
            return OSIOWorkitemLinkAttributeEditor.this.getModel().hasIncomingChanges(taskComment.getTaskAttribute());
        }
    };
    private List<CommentGroupViewer> commentGroupViewers;
    private boolean expandAllInProgress;
    private boolean hasIncoming;
    private boolean reflow = true;
    protected Section section;
    private SelectionProviderAdapter selectionProvider;
    private CommentViewer currentViewer;
    private Menu commentMenu;
    private CommentActionGroup actionGroup;
    private boolean suppressExpandViewers;

    public OSIOWorkitemLinkAttributeEditor() {
        this.setPartName("fixme");
    }

    protected void addActionsToToolbarButton(ToolBarManager toolBarManager, TaskComment taskComment, CommentViewer commentViewer) {
        ReplyToCommentActionWithMenu replyAction = new ReplyToCommentActionWithMenu(commentViewer);
        replyAction.setImageDescriptor(TasksUiImages.COMMENT_REPLY_SMALL);
        toolBarManager.add((IAction)replyAction);
    }

    protected void addActionsToToolbarTitle(ToolBarManager toolBarManager, TaskComment taskComment, CommentViewer commentViewer) {
    }

    private void collapseAllComments() {
        try {
            this.getTaskEditorPage().setReflow(false);
            boolean collapsed = false;
            List<CommentGroupViewer> viewers = this.getCommentGroupViewers();
            int i = 0;
            while (i < viewers.size()) {
                if (viewers.get(i).isExpanded()) {
                    viewers.get(i).setFullyExpanded(false);
                    collapsed = viewers.get(i).isRenderedInSubSection();
                }
                ++i;
            }
        }
        finally {
            this.getTaskEditorPage().setReflow(true);
        }
        this.reflow();
    }

    private TaskComment convertToTaskComment(TaskDataModel taskDataModel, TaskAttribute commentAttribute) {
        TaskComment taskComment = new TaskComment(taskDataModel.getTaskRepository(), taskDataModel.getTask(), commentAttribute);
        taskDataModel.getTaskData().getAttributeMapper().updateTaskComment((ITaskComment)taskComment, commentAttribute);
        return taskComment;
    }

    public void createControl(Composite parent, final FormToolkit toolkit) {
        this.initialize();
        this.selectionProvider = new SelectionProviderAdapter();
        this.actionGroup = new CommentActionGroup();
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                RichTextAttributeEditor editor;
                ISelection selection = OSIOWorkitemLinkAttributeEditor.this.selectionProvider.getSelection();
                if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
                    ReplyToCommentAction replyAction = new ReplyToCommentAction(OSIOWorkitemLinkAttributeEditor.this.currentViewer);
                    manager.add((IAction)replyAction);
                }
                OSIOWorkitemLinkAttributeEditor.this.actionGroup.setContext(new ActionContext(OSIOWorkitemLinkAttributeEditor.this.selectionProvider.getSelection()));
                OSIOWorkitemLinkAttributeEditor.this.actionGroup.fillContextMenu(manager);
                if (OSIOWorkitemLinkAttributeEditor.this.currentViewer != null && OSIOWorkitemLinkAttributeEditor.this.currentViewer.getEditor() instanceof RichTextAttributeEditor && (editor = (RichTextAttributeEditor)OSIOWorkitemLinkAttributeEditor.this.currentViewer.getEditor()).getViewSourceAction().isEnabled()) {
                    manager.add((IContributionItem)new Separator("planning"));
                    manager.add(editor.getViewSourceAction());
                }
            }
        });
        this.getTaskEditorPage().getEditorSite().registerContextMenu(ID_POPUP_MENU, menuManager, (ISelectionProvider)this.selectionProvider, false);
        this.commentMenu = menuManager.createContextMenu((Control)parent);
        this.section = this.createSection(parent, toolkit, this.hasIncoming);
        this.section.setText(String.valueOf(this.section.getText()) + " (" + this.commentAttributes.size() + ")");
        if (this.commentAttributes.isEmpty()) {
            this.section.setEnabled(false);
        } else if (this.hasIncoming) {
            this.expandSection(toolkit, this.section);
        } else {
            this.section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

                public void expansionStateChanged(ExpansionEvent event) {
                    if (OSIOWorkitemLinkAttributeEditor.this.section.getClient() == null) {
                        try {
                            OSIOWorkitemLinkAttributeEditor.this.expandAllInProgress = true;
                            OSIOWorkitemLinkAttributeEditor.this.getTaskEditorPage().setReflow(false);
                            OSIOWorkitemLinkAttributeEditor.this.expandSection(toolkit, OSIOWorkitemLinkAttributeEditor.this.section);
                        }
                        finally {
                            OSIOWorkitemLinkAttributeEditor.this.expandAllInProgress = false;
                            OSIOWorkitemLinkAttributeEditor.this.getTaskEditorPage().setReflow(true);
                        }
                        OSIOWorkitemLinkAttributeEditor.this.reflow();
                    }
                }
            });
        }
        this.setSection(toolkit, this.section);
    }

    public void dispose() {
        super.dispose();
        if (this.actionGroup != null) {
            this.actionGroup.dispose();
        }
    }

    public void expandAllComments(boolean expandViewers) {
        try {
            this.expandAllInProgress = true;
            this.suppressExpandViewers = !expandViewers;
            this.getTaskEditorPage().setReflow(false);
            if (this.section != null) {
                CommonFormUtil.setExpanded((ExpandableComposite)this.section, (boolean)true);
                if (expandViewers) {
                    List<CommentGroupViewer> groupViewers = this.getCommentGroupViewers();
                    int i = groupViewers.size() - 1;
                    while (i >= 0) {
                        if (!groupViewers.get(i).isFullyExpanded()) {
                            groupViewers.get(i).setFullyExpanded(true);
                        }
                        --i;
                    }
                }
            }
        }
        finally {
            this.expandAllInProgress = false;
            this.suppressExpandViewers = false;
            this.getTaskEditorPage().setReflow(true);
        }
        this.reflow();
    }

    private void expandSection(FormToolkit toolkit, Section section) {
        Composite composite = toolkit.createComposite((Composite)section);
        section.setClient((Control)composite);
        composite.setLayout((Layout)EditorUtil.createSectionClientLayout());
        List<CommentGroupViewer> viewers = this.getCommentGroupViewers();
        for (CommentGroupViewer viewer : viewers) {
            Control control = viewer.createControl(composite, toolkit);
            if (viewer.isRenderedInSubSection()) {
                GridDataFactory.fillDefaults().grab(true, false).indent(-12, 0).applyTo(control);
                continue;
            }
            GridDataFactory.fillDefaults().grab(true, false).indent(-6, 0).applyTo(control);
        }
    }

    protected void fillToolBar(ToolBarManager barManager) {
        Action collapseAllAction = new Action(""){

            public void run() {
                OSIOWorkitemLinkAttributeEditor.this.collapseAllComments();
            }
        };
        collapseAllAction.setImageDescriptor(CommonImages.COLLAPSE_ALL_SMALL);
        collapseAllAction.setToolTipText("fixme");
        barManager.add((IAction)collapseAllAction);
        Action expandAllAction = new Action(""){

            public void run() {
                OSIOWorkitemLinkAttributeEditor.this.expandAllComments(true);
            }
        };
        expandAllAction.setImageDescriptor(CommonImages.EXPAND_ALL_SMALL);
        expandAllAction.setToolTipText("fixme");
        barManager.add((IAction)expandAllAction);
        if (this.commentAttributes.isEmpty()) {
            collapseAllAction.setEnabled(false);
            expandAllAction.setEnabled(false);
        }
    }

    public CommentGroupStrategy getCommentGroupStrategy() {
        return this.commentGroupStrategy;
    }

    public void setCommentGroupStrategy(CommentGroupStrategy commentGroupStrategy) {
        this.commentGroupStrategy = commentGroupStrategy;
    }

    public List<CommentGroupViewer> getCommentGroupViewers() {
        if (this.commentGroupViewers != null) {
            return this.commentGroupViewers;
        }
        ArrayList<TaskComment> comments = new ArrayList<TaskComment>();
        for (TaskAttribute commentAttribute : this.commentAttributes) {
            comments.add(this.convertToTaskComment(this.getModel(), commentAttribute));
        }
        String currentPersonId = this.getModel().getTaskRepository().getUserName();
        List commentGroups = this.getCommentGroupStrategy().groupComments(comments, currentPersonId);
        this.commentGroupViewers = new ArrayList<CommentGroupViewer>(commentGroups.size());
        if (commentGroups.size() > 0) {
            int i = 0;
            while (i < commentGroups.size()) {
                CommentGroupViewer viewer = new CommentGroupViewer((CommentGroupStrategy.CommentGroup)commentGroups.get(i));
                boolean isLastGroup = i == commentGroups.size() - 1;
                viewer.setRenderedInSubSection(!isLastGroup);
                this.commentGroupViewers.add(viewer);
                ++i;
            }
        }
        return this.commentGroupViewers;
    }

    private void initialize() {
        this.commentAttributes = this.getTaskData().getAttributeMapper().getAttributesByType(this.getTaskData(), "comment");
        if (this.commentAttributes.size() > 0) {
            for (TaskAttribute commentAttribute : this.commentAttributes) {
                if (!this.getModel().hasIncomingChanges(commentAttribute)) continue;
                this.hasIncoming = true;
                break;
            }
        }
    }

    public boolean setFormInput(Object input) {
        if (input instanceof String) {
            String text = (String)input;
            if (this.commentAttributes != null) {
                for (TaskAttribute commentAttribute : this.commentAttributes) {
                    if (!text.equals(commentAttribute.getId())) continue;
                    this.selectReveal(commentAttribute);
                }
            }
        }
        return super.setFormInput(input);
    }

    public CommentViewer selectReveal(TaskAttribute commentAttribute) {
        if (commentAttribute == null) {
            return null;
        }
        this.expandAllComments(false);
        List<CommentGroupViewer> groupViewers = this.getCommentGroupViewers();
        for (CommentGroupViewer groupViewer : groupViewers) {
            for (CommentViewer viewer : groupViewer.getCommentViewers()) {
                if (!viewer.getTaskAttribute().equals((Object)commentAttribute)) continue;
                groupViewer.setExpanded(true);
                EditorUtil.reveal((ScrolledForm)this.getTaskEditorPage().getManagedForm().getForm(), (String)commentAttribute.getId());
                return viewer;
            }
        }
        return null;
    }

    public boolean isCommentSectionExpanded() {
        return this.section != null && this.section.isExpanded();
    }

    public void reflow() {
        if (this.reflow) {
            this.getTaskEditorPage().reflow();
        }
    }

    public void setReflow(boolean reflow) {
        this.reflow = reflow;
    }

    public class CommentGroupViewer {
        private final CommentGroupStrategy.CommentGroup commentGroup;
        private ArrayList<CommentViewer> commentViewers;
        private Section groupSection;
        private boolean renderedInSubSection;

        public CommentGroupViewer(CommentGroupStrategy.CommentGroup commentGroup) {
            this.commentGroup = commentGroup;
        }

        private Composite createCommentViewers(Composite parent, FormToolkit toolkit) {
            List<CommentViewer> viewers = this.getCommentViewers();
            Composite composite = toolkit.createComposite(parent);
            GridLayout contentLayout = new GridLayout();
            contentLayout.marginHeight = 0;
            contentLayout.marginWidth = 0;
            composite.setLayout((Layout)contentLayout);
            for (CommentViewer commentViewer : viewers) {
                Control control = commentViewer.createControl(composite, toolkit);
                GridDataFactory.fillDefaults().grab(true, false).applyTo(control);
            }
            return composite;
        }

        private Control createControl(Composite parent, FormToolkit toolkit) {
            if (this.renderedInSubSection) {
                return this.createSection(parent, toolkit);
            }
            if (OSIOWorkitemLinkAttributeEditor.this.commentAttributes.size() >= 12) {
                final Canvas separator = new Canvas(parent, 0){

                    public Point computeSize(int wHint, int hHint, boolean changed) {
                        return new Point(wHint == -1 ? 1 : wHint, 1);
                    }
                };
                separator.addPaintListener(new PaintListener(){

                    public void paintControl(PaintEvent e) {
                        e.gc.setForeground(separator.getForeground());
                        e.gc.drawLine(0, 0, separator.getSize().x, 0);
                    }
                });
                separator.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TB_BORDER"));
                GridDataFactory.fillDefaults().grab(true, false).indent(-12, 0).applyTo((Control)separator);
            }
            return this.createCommentViewers(parent, toolkit);
        }

        private Section createSection(Composite parent, final FormToolkit toolkit) {
            int style = 8706;
            this.groupSection = toolkit.createSection(parent, style);
            this.groupSection.clientVerticalSpacing = 0;
            if (this.commentGroup.hasIncoming()) {
                this.groupSection.setBackground(OSIOWorkitemLinkAttributeEditor.this.getTaskEditorPage().getAttributeEditorToolkit().getColorIncoming());
            }
            this.groupSection.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
            this.groupSection.setText(String.valueOf(this.commentGroup.getGroupName()) + "fixme" + this.commentGroup.getCommentAttributes().size() + "fixme");
            if (this.groupSection.isExpanded()) {
                Composite composite = this.createCommentViewers((Composite)this.groupSection, toolkit);
                this.groupSection.setClient((Control)composite);
            } else {
                this.groupSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

                    public void expansionStateChanged(ExpansionEvent e) {
                        if (CommentGroupViewer.this.commentGroup.hasIncoming()) {
                            if (e.getState()) {
                                CommentGroupViewer.this.groupSection.setBackground(null);
                            } else {
                                CommentGroupViewer.this.groupSection.setBackground(OSIOWorkitemLinkAttributeEditor.this.getTaskEditorPage().getAttributeEditorToolkit().getColorIncoming());
                            }
                        }
                        if (CommentGroupViewer.this.groupSection.getClient() == null) {
                            try {
                                OSIOWorkitemLinkAttributeEditor.this.getTaskEditorPage().setReflow(false);
                                Composite composite = CommentGroupViewer.this.createCommentViewers((Composite)CommentGroupViewer.this.groupSection, toolkit);
                                CommentGroupViewer.this.groupSection.setClient((Control)composite);
                            }
                            finally {
                                OSIOWorkitemLinkAttributeEditor.this.getTaskEditorPage().setReflow(true);
                            }
                            OSIOWorkitemLinkAttributeEditor.this.reflow();
                        }
                    }
                });
            }
            return this.groupSection;
        }

        public List<CommentViewer> getCommentViewers() {
            if (this.commentViewers != null) {
                return this.commentViewers;
            }
            this.commentViewers = new ArrayList(this.commentGroup.getCommentAttributes().size());
            for (TaskAttribute commentAttribute : this.commentGroup.getCommentAttributes()) {
                CommentViewer commentViewer = new CommentViewer(commentAttribute);
                this.commentViewers.add(commentViewer);
            }
            return this.commentViewers;
        }

        public boolean isExpanded() {
            if (this.groupSection != null) {
                return this.groupSection.isExpanded();
            }
            if (this.commentViewers != null) {
                for (CommentViewer commentViewer : this.commentViewers) {
                    if (!commentViewer.isExpanded()) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean isFullyExpanded() {
            if (this.groupSection != null && !this.groupSection.isExpanded()) {
                return false;
            }
            if (this.commentViewers != null) {
                for (CommentViewer commentViewer : this.commentViewers) {
                    if (commentViewer.isExpanded()) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public boolean isRenderedInSubSection() {
            return this.renderedInSubSection;
        }

        public void setExpanded(boolean expanded) {
            if (this.groupSection != null && this.groupSection.isExpanded() != expanded) {
                CommonFormUtil.setExpanded((ExpandableComposite)this.groupSection, (boolean)expanded);
            }
        }

        public void setFullyExpanded(boolean expanded) {
            if (this.groupSection != null && this.groupSection.isExpanded() != expanded) {
                CommonFormUtil.setExpanded((ExpandableComposite)this.groupSection, (boolean)expanded);
            }
            if (this.commentViewers != null) {
                for (CommentViewer commentViewer : this.commentViewers) {
                    commentViewer.setExpanded(expanded);
                }
            }
        }

        public void setRenderedInSubSection(boolean renderedInSubSection) {
            this.renderedInSubSection = renderedInSubSection;
        }

        public void createSectionHyperlink(String message, HyperlinkAdapter listener) {
            if (this.groupSection != null) {
                ScalingHyperlink resultLink = new ScalingHyperlink((Composite)this.groupSection, 8);
                resultLink.setForeground(CommonColors.HYPERLINK_WIDGET);
                resultLink.setUnderlined(true);
                resultLink.setText(message);
                this.groupSection.setTextClient((Control)resultLink);
                resultLink.getParent().layout(true, true);
                resultLink.addHyperlinkListener((IHyperlinkListener)listener);
            }
        }

        public void clearSectionHyperlink() {
            if (this.groupSection != null) {
                this.groupSection.setTextClient(null);
            }
        }
    }

    public class CommentViewer {
        private Composite buttonComposite;
        private final TaskAttribute commentAttribute;
        private ExpandableComposite commentComposite;
        private final TaskComment taskComment;
        private Composite commentViewer;
        private Composite userImageComposite;
        private AbstractAttributeEditor commentTextEditor;
        private boolean suppressSelectionChanged;

        public CommentViewer(TaskAttribute commentAttribute) {
            this.commentAttribute = commentAttribute;
            this.taskComment = new TaskComment(OSIOWorkitemLinkAttributeEditor.this.getModel().getTaskRepository(), OSIOWorkitemLinkAttributeEditor.this.getModel().getTask(), commentAttribute);
        }

        public Control createControl(Composite composite, final FormToolkit toolkit) {
            boolean hasIncomingChanges = OSIOWorkitemLinkAttributeEditor.this.getModel().hasIncomingChanges(this.commentAttribute);
            OSIOWorkitemLinkAttributeEditor.this.getTaskData().getAttributeMapper().updateTaskComment((ITaskComment)this.taskComment, this.commentAttribute);
            int style = 8228;
            if (hasIncomingChanges || OSIOWorkitemLinkAttributeEditor.this.expandAllInProgress && !OSIOWorkitemLinkAttributeEditor.this.suppressExpandViewers) {
                style |= 0x40;
            }
            this.commentComposite = toolkit.createExpandableComposite(composite, style);
            this.commentComposite.clientVerticalSpacing = 0;
            this.commentComposite.setLayout((Layout)new GridLayout());
            this.commentComposite.setLayoutData((Object)new GridData(768));
            this.commentComposite.setTitleBarForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
            this.buttonComposite = this.createTitle(this.commentComposite, toolkit);
            final Composite commentViewerComposite = toolkit.createComposite((Composite)this.commentComposite);
            this.commentComposite.setClient((Control)commentViewerComposite);
            commentViewerComposite.setLayout((Layout)new FillWidthLayout(EditorUtil.getLayoutAdvisor((AbstractTaskEditorPage)OSIOWorkitemLinkAttributeEditor.this.getTaskEditorPage()), 15, 0, 0, 3));
            this.commentComposite.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

                public void expansionStateChanged(ExpansionEvent event) {
                    CommentViewer.this.expandComment(toolkit, commentViewerComposite, event.getState());
                }
            });
            if (hasIncomingChanges) {
                this.commentComposite.setBackground(OSIOWorkitemLinkAttributeEditor.this.getTaskEditorPage().getAttributeEditorToolkit().getColorIncoming());
            }
            if (this.commentComposite.isExpanded()) {
                this.expandComment(toolkit, commentViewerComposite, true);
            }
            EditorUtil.setMarker((Widget)this.commentComposite, (String)this.commentAttribute.getId());
            return this.commentComposite;
        }

        private Composite createTitle(final ExpandableComposite commentComposite, FormToolkit toolkit) {
            Composite titleComposite = toolkit.createComposite((Composite)commentComposite);
            commentComposite.setTextClient((Control)titleComposite);
            RowLayout rowLayout = new RowLayout();
            rowLayout.pack = true;
            rowLayout.marginLeft = 0;
            rowLayout.marginBottom = 0;
            rowLayout.marginTop = 0;
            rowLayout.center = true;
            titleComposite.setLayout((Layout)rowLayout);
            titleComposite.setBackground(null);
            ImageHyperlink expandCommentHyperlink = this.createTitleHyperLink(toolkit, titleComposite, (ITaskComment)this.taskComment);
            expandCommentHyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    CommonFormUtil.setExpanded((ExpandableComposite)commentComposite, (!commentComposite.isExpanded() ? 1 : 0) != 0);
                }
            });
            ToolBarManager toolBarManagerTitle = new ToolBarManager(0x800000);
            OSIOWorkitemLinkAttributeEditor.this.addActionsToToolbarTitle(toolBarManagerTitle, this.taskComment, this);
            toolBarManagerTitle.createControl(titleComposite);
            Composite buttonComposite = toolkit.createComposite(titleComposite);
            RowLayout buttonCompLayout = new RowLayout();
            buttonCompLayout.marginBottom = 0;
            buttonCompLayout.marginTop = 0;
            buttonComposite.setLayout((Layout)buttonCompLayout);
            buttonComposite.setBackground(null);
            buttonComposite.setVisible(commentComposite.isExpanded());
            ToolBarManager toolBarManagerButton = new ToolBarManager(0x800000);
            OSIOWorkitemLinkAttributeEditor.this.addActionsToToolbarButton(toolBarManagerButton, this.taskComment, this);
            toolBarManagerButton.createControl(buttonComposite);
            return buttonComposite;
        }

        private ImageHyperlink createTitleHyperLink(FormToolkit toolkit, Composite toolbarComp, ITaskComment taskComment) {
            ImageHyperlink formHyperlink = toolkit.createImageHyperlink(toolbarComp, 0);
            formHyperlink.setBackground(null);
            formHyperlink.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
            IRepositoryPerson author = taskComment.getAuthor();
            if (author != null && author.matchesUsername(OSIOWorkitemLinkAttributeEditor.this.getTaskEditorPage().getTaskRepository().getUserName())) {
                formHyperlink.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.PERSON_ME_NARROW));
            } else {
                formHyperlink.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.PERSON_NARROW));
            }
            StringBuilder sb = new StringBuilder();
            if (taskComment.getNumber() >= 0) {
                sb.append(taskComment.getNumber());
                sb.append(": ");
            }
            String toolTipText = "";
            if (author != null) {
                if (author.getName() != null) {
                    sb.append(author.getName());
                    toolTipText = author.getPersonId();
                } else {
                    sb.append(author.getPersonId());
                }
            }
            if (taskComment.getCreationDate() != null) {
                sb.append(", ");
                sb.append(taskComment.getCreationDate());
            }
            formHyperlink.setFont(this.commentComposite.getFont());
            formHyperlink.setToolTipText(toolTipText);
            formHyperlink.setText(sb.toString());
            formHyperlink.setEnabled(true);
            formHyperlink.setUnderlined(false);
            return formHyperlink;
        }

        private void expandComment(FormToolkit toolkit, Composite composite, boolean expanded) {
            this.buttonComposite.setVisible(expanded);
            if (expanded && composite.getData(OSIOWorkitemLinkAttributeEditor.KEY_EDITOR) == null) {
                String commentAuthor;
                TaskAttribute userImageAttribute;
                this.commentViewer = toolkit.createComposite(composite);
                this.commentViewer.setLayout((Layout)new GridLayout(2, false));
                this.commentViewer.setLayoutData((Object)new GridData(2));
                boolean showAvatar = Boolean.parseBoolean(OSIOWorkitemLinkAttributeEditor.this.getModel().getTaskRepository().getProperty("avatarSupport"));
                if (showAvatar && (userImageAttribute = this.commentAttribute.getAttribute(commentAuthor = OSIOWorkitemLinkAttributeEditor.this.getTaskData().getAttributeMapper().mapToRepositoryKey(this.commentAttribute, "task.common.comment.author"))) != null) {
                    this.userImageComposite = toolkit.createComposite(this.commentViewer);
                    this.userImageComposite.setLayout((Layout)new GridLayout(1, false));
                    GridDataFactory.swtDefaults().align(16384, 1).applyTo((Control)this.userImageComposite);
                    toolkit.paintBordersFor(this.userImageComposite);
                    UserAttributeEditor userImage = new UserAttributeEditor(OSIOWorkitemLinkAttributeEditor.this.getModel(), userImageAttribute, 30);
                    userImage.createControl(this.userImageComposite, toolkit);
                    userImage.refresh();
                }
                TaskAttribute textAttribute = OSIOWorkitemLinkAttributeEditor.this.getTaskData().getAttributeMapper().getAssoctiatedAttribute(this.taskComment.getTaskAttribute());
                this.commentTextEditor = OSIOWorkitemLinkAttributeEditor.this.createAttributeEditor(textAttribute);
                if (this.commentTextEditor != null) {
                    this.commentTextEditor.setDecorationEnabled(false);
                    this.commentTextEditor.createControl(this.commentViewer, toolkit);
                    GridData commentGridData = new GridData(768);
                    commentGridData.verticalAlignment = 1;
                    this.commentTextEditor.getControl().setLayoutData((Object)commentGridData);
                    this.commentTextEditor.getControl().addMouseListener((MouseListener)new MouseAdapter(){

                        public void mouseDown(MouseEvent e) {
                            OSIOWorkitemLinkAttributeEditor.this.getTaskEditorPage().selectionChanged((Object)CommentViewer.this.taskComment);
                        }
                    });
                    composite.setData(OSIOWorkitemLinkAttributeEditor.KEY_EDITOR, (Object)this.commentTextEditor);
                    OSIOWorkitemLinkAttributeEditor.this.getTaskEditorPage().getAttributeEditorToolkit().adapt(this.commentTextEditor);
                    OSIOWorkitemLinkAttributeEditor.this.reflow();
                }
            } else if (!expanded && composite.getData(OSIOWorkitemLinkAttributeEditor.KEY_EDITOR) != null) {
                this.commentTextEditor.getControl().setMenu(null);
                this.commentTextEditor.getControl().dispose();
                if (this.userImageComposite != null) {
                    this.userImageComposite.setMenu(null);
                    this.userImageComposite.dispose();
                }
                if (this.commentViewer != null) {
                    this.commentViewer.setMenu(null);
                    this.commentViewer.dispose();
                }
                composite.setData(OSIOWorkitemLinkAttributeEditor.KEY_EDITOR, null);
                OSIOWorkitemLinkAttributeEditor.this.reflow();
            }
            if (!this.suppressSelectionChanged) {
                OSIOWorkitemLinkAttributeEditor.this.getTaskEditorPage().selectionChanged((Object)this.taskComment);
            }
        }

        public boolean isExpanded() {
            return this.commentComposite != null && this.commentComposite.isExpanded();
        }

        public void setExpanded(boolean expanded) {
            if (this.commentComposite != null && this.commentComposite.isExpanded() != expanded) {
                CommonFormUtil.setExpanded((ExpandableComposite)this.commentComposite, (boolean)expanded);
            }
        }

        public AbstractAttributeEditor getEditor() {
            return this.commentTextEditor;
        }

        public TaskAttribute getTaskAttribute() {
            return this.commentAttribute;
        }

        public TaskComment getTaskComment() {
            return this.taskComment;
        }

        public Control getControl() {
            return this.commentComposite;
        }

        public void suppressSelectionChanged(boolean value) {
            this.suppressSelectionChanged = value;
        }

        public String getReplyToText() {
            Control textControl;
            String selectedText;
            String replyText = this.taskComment.getText();
            if (this.hasTextControl() && !Strings.isNullOrEmpty((String)(selectedText = this.getSelectedText(textControl = this.commentTextEditor.getControl())))) {
                replyText = selectedText;
            }
            return replyText;
        }

        private String getSelectedText(Control control) {
            if (control instanceof StyledText) {
                return ((StyledText)control).getSelectionText();
            }
            if (control instanceof Composite) {
                Control[] controlArray = ((Composite)control).getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control child = controlArray[n2];
                    String selectedText = this.getSelectedText(child);
                    if (!Strings.isNullOrEmpty((String)selectedText)) {
                        return selectedText;
                    }
                    ++n2;
                }
            }
            return null;
        }

        private boolean hasTextControl() {
            return this.commentTextEditor != null && this.commentTextEditor.getControl() != null && !this.commentTextEditor.getControl().isDisposed();
        }
    }

    private class ReplyToCommentAction
    extends AbstractReplyToCommentAction {
        private final CommentViewer commentViewer;

        public ReplyToCommentAction(CommentViewer commentViewer) {
            super(OSIOWorkitemLinkAttributeEditor.this.getTaskEditorPage(), (ITaskComment)commentViewer.getTaskComment());
            this.commentViewer = commentViewer;
        }

        protected String getReplyText() {
            return this.commentViewer.getReplyToText();
        }

        protected CommentViewer getCommentViewer() {
            return this.commentViewer;
        }

        public void dispose() {
        }
    }

    private class ReplyToCommentActionWithMenu
    extends ReplyToCommentAction
    implements IMenuCreator {
        public ReplyToCommentActionWithMenu(CommentViewer commentViewer) {
            super(commentViewer);
            this.setMenuCreator(this);
        }

        public Menu getMenu(Control parent) {
            OSIOWorkitemLinkAttributeEditor.this.currentViewer = this.getCommentViewer();
            OSIOWorkitemLinkAttributeEditor.this.selectionProvider.setSelection((ISelection)new StructuredSelection((Object)OSIOWorkitemLinkAttributeEditor.this.currentViewer.getTaskComment()));
            return OSIOWorkitemLinkAttributeEditor.this.commentMenu;
        }

        public Menu getMenu(Menu parent) {
            OSIOWorkitemLinkAttributeEditor.this.selectionProvider.setSelection((ISelection)new StructuredSelection((Object)this.getCommentViewer().getTaskComment()));
            return OSIOWorkitemLinkAttributeEditor.this.commentMenu;
        }
    }
}

