/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.mylyn.osio.rest.ui.provisional;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestConfiguration;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestConnector;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.ui.provisional.AbstractQueryPageSchema;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.ui.provisional.Messages;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.ui.provisional.QueryPageDetails;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.ui.provisional.RepositoryQuerySchemaPage;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.osgi.util.NLS;

public class OSIORestSearchQueryPage
extends RepositoryQuerySchemaPage {
    public OSIORestSearchQueryPage(String pageName, TaskRepository repository, IRepositoryQuery query, AbstractQueryPageSchema schema, TaskData data, QueryPageDetails pageDetails) {
        super(pageName, repository, query, schema, data, pageDetails);
        if (query != null) {
            this.setTitle(NLS.bind((String)Messages.OSIORestSearchQueryPage_PropertiesForQuery, (Object)query.getSummary()));
        } else {
            this.setTitle(Messages.OSIORestSearchQueryPage_PropertiesForNewQuery);
        }
    }

    @Override
    protected void doRefreshControls() {
        try {
            OSIORestConnector connectorREST = (OSIORestConnector)this.getConnector();
            connectorREST.getRepositoryConfiguration(this.getTaskRepository()).updateSpaceOptions(this.getTargetTaskData());
            for (Map.Entry entry : this.editorMap.entrySet()) {
                ((AbstractAttributeEditor)entry.getValue()).refresh();
            }
        }
        catch (CoreException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.linuxtools.mylyn.osio.rest.ui", "OSIORestSearchQueryPage could not refresh!", (Throwable)e));
        }
    }

    @Override
    protected boolean hasRepositoryConfiguration() {
        return this.getRepositoryConfiguration() != null;
    }

    private OSIORestConfiguration getRepositoryConfiguration() {
        try {
            return ((OSIORestConnector)this.getConnector()).getRepositoryConfiguration(this.getTaskRepository());
        }
        catch (CoreException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.linuxtools.mylyn.osio.rest.ui", "OSIORestSearchQueryPage could get the RepositoryConfiguration!", (Throwable)e));
            return null;
        }
    }

    @Override
    protected boolean restoreState(IRepositoryQuery query) {
        if (query != null) {
            try {
                this.restoreStateFromUrl(query.getUrl());
                this.doRefreshControls();
                return true;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return false;
    }

    private void restoreStateFromUrl(String queryUrl) throws UnsupportedEncodingException {
        String[] options;
        queryUrl = queryUrl.substring(queryUrl.indexOf("?") + 1);
        String[] stringArray = options = queryUrl.split("&");
        int n = options.length;
        int n2 = 0;
        while (n2 < n) {
            String option = stringArray[n2];
            int endindex = option.indexOf("=");
            String key = endindex == -1 ? null : option.substring(0, option.indexOf("="));
            if (key != null && !key.equals("order")) {
                String value = URLDecoder.decode(option.substring(option.indexOf("=") + 1), this.getTaskRepository().getCharacterEncoding());
                TaskAttribute attr = this.getTargetTaskData().getRoot().getAttribute(key);
                if (attr != null) {
                    if (this.getTargetTaskData().getRoot().getAttribute(key).getValue().equals("")) {
                        this.getTargetTaskData().getRoot().getAttribute(key).setValue(value);
                    } else {
                        this.getTargetTaskData().getRoot().getAttribute(key).addValue(value);
                    }
                }
            }
            ++n2;
        }
    }

    @Override
    protected String getQueryUrl(String repositoryUrl) {
        return this.getQueryURL(repositoryUrl, this.getQueryParameters());
    }

    private StringBuilder getQueryParameters() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : this.editorMap.entrySet()) {
            TaskAttribute attrib = this.getTargetTaskData().getRoot().getAttribute((String)entry.getKey());
            for (String string : attrib.getValues()) {
                if (string == null || string.equals("")) continue;
                try {
                    this.appendToBuffer(sb, String.valueOf((String)entry.getKey()) + "=", URLEncoder.encode(string.replaceAll(" ", "%20"), this.getTaskRepository().getCharacterEncoding()).replaceAll("%2520", "%20"));
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
        }
        return sb;
    }

    private String getQueryURL(String repositoryUrl, StringBuilder params) {
        StringBuilder url = new StringBuilder(this.getQueryURLStart(repositoryUrl));
        url.append((CharSequence)params);
        return url.toString();
    }

    private String getQueryURLStart(String repositoryUrl) {
        return String.valueOf(repositoryUrl) + (repositoryUrl.endsWith("/") ? "" : "/") + "/search?";
    }

    private void appendToBuffer(StringBuilder sb, String key, String value) {
        if (sb.length() > 0) {
            sb.append('&');
        }
        sb.append(key);
        sb.append(value);
    }
}

