/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.mylyn.osio.rest.ui.provisional;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestConfiguration;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.core.OSIORestConnector;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.ui.provisional.Messages;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.ui.provisional.OSIORestSearchQueryPage;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.ui.provisional.OSIORestSearchQueryPageSchema;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.ui.provisional.QueryPageDetails;
import org.eclipse.linuxtools.internal.mylyn.osio.rest.ui.provisional.SimpleURLQueryPageSchema;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskData;

public class OSIORestUIUtil {
    protected static OSIORestSearchQueryPage createSimpleURLQueryPage(TaskData taskData, OSIORestConnector connectorREST, TaskRepository repository) {
        try {
            SimpleURLQueryPageSchema.getInstance().initialize(taskData);
            OSIORestConfiguration config = connectorREST.getRepositoryConfiguration(repository);
            if (config != null) {
                config.updateSpaceOptions(taskData);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return new OSIORestSearchQueryPage(Messages.OSIORestUiUtil_CreateQueryFromURL, repository, null, SimpleURLQueryPageSchema.getInstance(), taskData, new QueryPageDetails(true, "buglist.cgi?", Messages.OSIORestUiUtil_EnterQueryParameter, Messages.OSIORestUiUtil_EnterTitleAndURL, "([a-zA-Z][a-zA-Z+.-]{0,10}://[a-zA-Z0-9%._~!$&?#'()*+,;:@/=-]+)", "SimpleURLQueryPage"));
    }

    protected static OSIORestSearchQueryPage createOSIORestSearchQueryPage(TaskData taskData, OSIORestConnector connectorREST, TaskRepository repository) {
        try {
            OSIORestSearchQueryPageSchema.getInstance().initialize(taskData);
            OSIORestConfiguration config = connectorREST.getRepositoryConfiguration(repository);
            if (config != null) {
                config.updateSpaceOptions(taskData);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return new OSIORestSearchQueryPage(Messages.OSIORestUiUtil_CreateQueryFromForm, repository, null, OSIORestSearchQueryPageSchema.getInstance(), taskData, new QueryPageDetails(true, "buglist.cgi?", Messages.OSIORestUiUtil_FillForm, Messages.OSIORestUiUtil_enterTitleAndFillForm, "([a-zA-Z][a-zA-Z+.-]{0,10}://[a-zA-Z0-9%._~!$&?#'()*+,;:@/=-]+)", null));
    }

    public static OSIORestSearchQueryPage createOSIORestSearchPage(boolean simplePage, boolean updateMode, TaskData taskData, OSIORestConnector connectorREST, TaskRepository repository, IRepositoryQuery query) {
        OSIORestSearchQueryPage result = null;
        if (simplePage && !updateMode) {
            result = OSIORestUIUtil.createSimpleURLQueryPage(taskData, connectorREST, repository);
        }
        if (!simplePage && !updateMode) {
            result = OSIORestUIUtil.createOSIORestSearchQueryPage(taskData, connectorREST, repository);
        }
        if (simplePage && updateMode) {
            result = OSIORestUIUtil.updateSimpleURLQueryPage(taskData, connectorREST, repository, query);
        }
        if (!simplePage && updateMode) {
            result = OSIORestUIUtil.updateOSIORestSearchQueryPage(taskData, connectorREST, repository, query);
        }
        return result;
    }

    protected static OSIORestSearchQueryPage updateSimpleURLQueryPage(TaskData taskData, OSIORestConnector connectorREST, TaskRepository repository, IRepositoryQuery query) {
        try {
            SimpleURLQueryPageSchema.getInstance().initialize(taskData);
            connectorREST.getRepositoryConfiguration(repository).updateSpaceOptions(taskData);
            OSIORestSearchQueryPageSchema.getInstance().initialize(taskData);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return new OSIORestSearchQueryPage(Messages.OSIORestUiUtil_CreateQueryFromURL, repository, query, SimpleURLQueryPageSchema.getInstance(), taskData, new QueryPageDetails(true, "buglist.cgi?", Messages.OSIORestUiUtil_EnterQueryParameters, Messages.OSIORestUiUtil_EnterTitleAndURL1, "([a-zA-Z][a-zA-Z+.-]{0,10}://[a-zA-Z0-9%._~!$&?#'()*+,;:@/=-]+)", "SimpleURLQueryPage"));
    }

    protected static OSIORestSearchQueryPage updateOSIORestSearchQueryPage(TaskData taskData, OSIORestConnector connectorREST, TaskRepository repository, IRepositoryQuery query) {
        try {
            OSIORestSearchQueryPageSchema.getInstance().initialize(taskData);
            connectorREST.getTaskDataHandler().initializeTaskData(repository, taskData, null, (IProgressMonitor)new NullProgressMonitor());
            OSIORestSearchQueryPageSchema.getInstance().initialize(taskData);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return new OSIORestSearchQueryPage(Messages.OSIORestUiUtil_CreateQueryFromForm, repository, query, OSIORestSearchQueryPageSchema.getInstance(), taskData, new QueryPageDetails(true, "buglist.cgi?", Messages.OSIORestUiUtil_fillForm, Messages.OSIORestUiUtil_EnterTitleAndFillForm, "([a-zA-Z][a-zA-Z+.-]{0,10}://[a-zA-Z0-9%._~!$&?#'()*+,;:@/=-]+)", null));
    }
}

