/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.mylyn.osio.rest.ui.provisional;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.mylyn.tasks.ui.editors.LayoutHint;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class RepositoryQueryAttributeEditor
extends AbstractAttributeEditor {
    private String[] allValues;
    private Text text;
    private List list;
    protected boolean suppressRefresh;

    public RepositoryQueryAttributeEditor(TaskDataModel manager, TaskAttribute taskAttribute) {
        super(manager, taskAttribute);
        if (this.isReadOnly()) {
            this.setLayoutHint(new LayoutHint(LayoutHint.RowSpan.SINGLE, LayoutHint.ColumnSpan.SINGLE));
        } else {
            this.setLayoutHint(new LayoutHint(LayoutHint.RowSpan.MULTIPLE, LayoutHint.ColumnSpan.SINGLE));
        }
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        if (this.isReadOnly()) {
            this.text = new Text(parent, 0x800048);
            this.text.setFont(JFaceResources.getDefaultFont());
            toolkit.adapt((Control)this.text, false, false);
            this.text.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
            this.select(this.getValues(), this.getValuesLabels());
            this.text.setToolTipText(this.getDescription());
            this.setControl((Control)this.text);
        } else {
            this.list = new List(parent, 8391170);
            toolkit.adapt((Control)this.list, false, false);
            this.list.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
            this.list.setFont(JFaceResources.getDefaultFont());
            this.list.setToolTipText(this.getDescription());
            this.updateListWithOptions();
            this.select(this.getValues(), this.getValuesLabels());
            if (this.allValues != null) {
                this.list.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Assert.isNotNull((Object)RepositoryQueryAttributeEditor.this.allValues);
                        int[] indices = RepositoryQueryAttributeEditor.this.list.getSelectionIndices();
                        String[] selectedValues = new String[indices.length];
                        int i = 0;
                        while (i < indices.length) {
                            int index = indices[i];
                            Assert.isLegal((index >= 0 && index <= RepositoryQueryAttributeEditor.this.allValues.length - 1 ? 1 : 0) != 0);
                            selectedValues[i] = RepositoryQueryAttributeEditor.this.allValues[index];
                            ++i;
                        }
                        try {
                            RepositoryQueryAttributeEditor.this.suppressRefresh = true;
                            RepositoryQueryAttributeEditor.this.setValues(selectedValues);
                        }
                        finally {
                            RepositoryQueryAttributeEditor.this.suppressRefresh = false;
                        }
                    }
                });
                this.list.showSelection();
            }
            this.setControl((Control)this.list);
        }
    }

    private void updateListWithOptions() {
        Map labelByValue;
        if (this.list != null && !this.list.isDisposed() && (labelByValue = this.getAttributeMapper().getOptions(this.getTaskAttribute())) != null) {
            int topIndex = this.list.getTopIndex();
            this.list.removeAll();
            String[] stringArray = this.allValues = labelByValue.keySet().toArray(new String[0]);
            int n = this.allValues.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                this.list.add((String)labelByValue.get(value));
                ++n2;
            }
            if (topIndex > 0) {
                this.list.setTopIndex(topIndex);
            }
        }
    }

    public String[] getValues() {
        return this.getAttributeMapper().getValues(this.getTaskAttribute()).toArray(new String[0]);
    }

    public String[] getValuesLabels() {
        return this.getAttributeMapper().getValueLabels(this.getTaskAttribute()).toArray(new String[0]);
    }

    private void select(String[] values, String[] labels) {
        if (this.text != null && !this.text.isDisposed()) {
            StringBuilder valueString = new StringBuilder();
            if (labels != null) {
                int i = 0;
                while (i < labels.length) {
                    valueString.append(labels[i]);
                    if (i != labels.length - 1) {
                        valueString.append(", ");
                    }
                    ++i;
                }
            }
            this.text.setText(valueString.toString());
        } else if (this.list != null && !this.list.isDisposed()) {
            if (values != null) {
                this.list.deselectAll();
                HashSet<String> selectedValues = new HashSet<String>(Arrays.asList(values));
                int i = 0;
                while (i < this.allValues.length) {
                    if (selectedValues.contains(this.allValues[i])) {
                        this.list.select(i);
                    }
                    ++i;
                }
            } else {
                this.list.setItems(labels);
                this.list.setSelection(labels);
            }
        }
    }

    public void setValues(String[] values) {
        this.getAttributeMapper().setValues(this.getTaskAttribute(), Arrays.asList(values));
        this.attributeChanged();
    }

    public void refresh() {
        this.updateListWithOptions();
        this.select(this.getValues(), this.getValuesLabels());
    }

    public boolean shouldAutoRefresh() {
        return !this.suppressRefresh;
    }
}

