/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.docker.reddeer.utils;

import org.eclipse.reddeer.common.condition.AbstractWaitCondition;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.matcher.RegexMatcher;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.reddeer.eclipse.ui.browser.BrowserEditor;
import org.eclipse.reddeer.eclipse.ui.browser.WebBrowserView;
import org.eclipse.reddeer.eclipse.ui.console.ConsoleView;
import org.eclipse.reddeer.workbench.core.condition.JobIsRunning;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class BrowserContentsCheck {
    protected static void closeBrowser() {
        try {
            BrowserEditor browser = new BrowserEditor((Matcher)new RegexMatcher(".*"));
            while (browser != null) {
                browser.close();
                try {
                    browser = new BrowserEditor((Matcher)new RegexMatcher(".*"));
                }
                catch (CoreLayerException ex) {
                    browser = null;
                }
            }
        }
        catch (CoreLayerException ex) {
            return;
        }
    }

    public static void checkBrowserForErrorPage(BrowserEditor browserEditor) {
        BrowserContentsCheck.evaluateBrowserPage(browserEditor.getText());
    }

    public static void checkBrowserForErrorPage(WebBrowserView browserView, String url) {
        if (browserView.getText().contains("Unable") || browserView.getText().contains("404")) {
            if (url == null) {
                browserView.refreshPage();
            } else {
                browserView.openPageURL(url);
            }
        }
        new WaitWhile((WaitCondition)new JobIsRunning());
        BrowserContentsCheck.evaluateBrowserPage(browserView.getText());
    }

    private static void evaluateBrowserPage(String browserPage) {
        ConsoleView consoleView = new ConsoleView();
        consoleView.open();
        Assert.assertFalse((String)("Browser contains text 'Status 404'\n Console output:\n" + consoleView.getConsoleText() + System.getProperty("line.separator") + "Browser contents:" + browserPage), (browserPage.contains("Status 404") || browserPage.contains("404 - Not Found") ? 1 : 0) != 0);
        Assert.assertFalse((String)("Browser contains text 'Error processing request'\n Console output:\n" + consoleView.getConsoleText() + System.getProperty("line.separator") + "Browser contents:" + browserPage), (boolean)browserPage.contains("Error processing request"));
        Assert.assertFalse((String)("Browser contains text 'Forbidden'\n Console output:\n" + consoleView.getConsoleText() + System.getProperty("line.separator") + "Browser contents:" + browserPage), (boolean)browserPage.contains("Forbidden"));
    }

    class BrowserIsNotEmpty
    extends AbstractWaitCondition {
        BrowserEditor browser;

        public BrowserIsNotEmpty(BrowserEditor browser) {
            this.browser = browser;
        }

        public boolean test() {
            return !this.browser.getText().equals("");
        }

        public String description() {
            return "Browser is empty!";
        }
    }
}

