/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.docker.integration.tests.container;

import org.eclipse.linuxtools.docker.integration.tests.image.AbstractImageBotTest;
import org.eclipse.linuxtools.docker.integration.tests.mock.MockUtils;
import org.eclipse.linuxtools.docker.reddeer.core.ui.wizards.ImageRunSelectionPage;
import org.eclipse.linuxtools.docker.reddeer.ui.DockerExplorerView;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.condition.ConsoleHasNoChange;
import org.eclipse.reddeer.workbench.core.condition.JobIsRunning;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DockerContainerTest
extends AbstractImageBotTest {
    private static final String IMAGE_NAME = "busybox";
    private static final String CONTAINER_NAME = "test_run";

    @Before
    public void before() {
        this.clearConsole();
        DockerContainerTest.deleteAllConnections();
        this.getConnection();
        this.pullImage(IMAGE_NAME);
    }

    @Test
    public void testRunDockerContainer() {
        new WaitWhile((WaitCondition)new JobIsRunning(), TimePeriod.LONG);
        Assert.assertTrue((String)"Image has not been found!", (boolean)this.imageIsDeployed(this.getCompleteImageName(IMAGE_NAME)));
        DockerExplorerView explorer = new DockerExplorerView();
        explorer.open();
        this.getConnection().getImage(this.getCompleteImageName(IMAGE_NAME)).run();
        ImageRunSelectionPage firstPage = new ImageRunSelectionPage((ReferencedComposite)explorer);
        firstPage.setContainerName(CONTAINER_NAME);
        firstPage.finish();
        if (this.mockitoIsUsed()) {
            MockUtils.runContainer("default", IMAGE_NAME, "latest", CONTAINER_NAME);
        }
        new WaitWhile((WaitCondition)new JobIsRunning(), TimePeriod.DEFAULT);
        new WaitWhile((WaitCondition)new ConsoleHasNoChange());
        Assert.assertTrue((String)"Container does not exists!", (boolean)this.containerIsDeployed(CONTAINER_NAME));
    }

    @Override
    @After
    public void after() {
        this.deleteImageContainerAfter(CONTAINER_NAME);
    }
}

