/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.docker.integration.tests.container;

import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.exceptions.DockerException;
import com.spotify.docker.client.messages.Container;
import com.spotify.docker.client.messages.ContainerInfo;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.integration.tests.image.AbstractImageBotTest;
import org.eclipse.linuxtools.docker.integration.tests.mock.MockDockerConnectionManager;
import org.eclipse.linuxtools.docker.reddeer.condition.ContainerIsDeployedCondition;
import org.eclipse.linuxtools.docker.reddeer.core.ui.wizards.ImageRunNetworkPage;
import org.eclipse.linuxtools.docker.reddeer.core.ui.wizards.ImageRunResourceVolumesVariablesPage;
import org.eclipse.linuxtools.docker.reddeer.core.ui.wizards.ImageRunSelectionPage;
import org.eclipse.linuxtools.docker.reddeer.ui.DockerExplorerView;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockContainerFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockContainerInfoFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockDockerClientFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockDockerConnectionFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockImageFactory;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.reddeer.workbench.core.condition.JobIsRunning;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NetworkModeTest
extends AbstractImageBotTest {
    private static final String IMAGE_NAME = "docker.io/busybox";
    private static final String IMAGE_TAG = "latest";
    private static final String CONTAINER_NAME = "test_run_busybox";
    private static final String NETWORK_MODE_DEFAULT = "default";
    private static final String NETWORK_MODE_BRIDGE = "bridge";
    private static final String NETWORK_MODE_HOST = "host";
    private static final String NETWORK_MODE_NONE = "none";
    ImageRunSelectionPage firstPage;

    @Before
    public void before() throws DockerException, InterruptedException {
        NetworkModeTest.deleteAllConnections();
        this.getConnection();
        this.pullImage(IMAGE_NAME, IMAGE_TAG);
        new WaitWhile((WaitCondition)new JobIsRunning());
        DockerExplorerView explorer = new DockerExplorerView();
        explorer.open();
        this.getConnection().getImage(IMAGE_NAME).run();
        this.firstPage = new ImageRunSelectionPage((ReferencedComposite)explorer);
        this.firstPage.setContainerName(CONTAINER_NAME);
        this.firstPage.setAllocatePseudoTTY();
        this.firstPage.setKeepSTDINOpen();
        this.firstPage.next();
        ImageRunResourceVolumesVariablesPage variablesPage = new ImageRunResourceVolumesVariablesPage((ReferencedComposite)this.firstPage);
        variablesPage.next();
    }

    @Test
    public void testDefaultMode() {
        ImageRunNetworkPage networkPage = new ImageRunNetworkPage((ReferencedComposite)this.firstPage);
        networkPage.setDefaultNetworkMode();
        networkPage.finish();
        this.checkNetworkMode(NETWORK_MODE_DEFAULT);
    }

    @Test
    public void testBridgeMode() {
        ImageRunNetworkPage networkPage = new ImageRunNetworkPage((ReferencedComposite)this.firstPage);
        networkPage.setBridgeNetworkMode();
        networkPage.finish();
        this.checkNetworkMode(NETWORK_MODE_BRIDGE);
    }

    @Test
    public void testHostMode() {
        ImageRunNetworkPage networkPage = new ImageRunNetworkPage((ReferencedComposite)this.firstPage);
        networkPage.setHostNetworkMode();
        networkPage.finish();
        this.checkNetworkMode(NETWORK_MODE_HOST);
    }

    @Test
    public void testNoneMode() {
        ImageRunNetworkPage networkPage = new ImageRunNetworkPage((ReferencedComposite)this.firstPage);
        networkPage.setNoneNetworkMode();
        networkPage.finish();
        this.checkNetworkMode(NETWORK_MODE_NONE);
    }

    @Override
    @After
    public void after() {
        this.deleteContainerIfExists(CONTAINER_NAME);
    }

    private void runContainer(String networkMode) {
        DockerClient client = MockDockerClientFactory.container((Container)MockContainerFactory.name((String)CONTAINER_NAME, (String[])new String[0]).status("Stopped").build(), (ContainerInfo)MockContainerInfoFactory.link((String)"docker.io/busybox:latest").networkMode(networkMode).id("TestTestTestTestTest").ipAddress("127.0.0.1").build()).image(MockImageFactory.id((String)"987654321abcde").name("fnichol/uhttpd:latest", new String[0]).build()).build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from((String)NETWORK_MODE_DEFAULT, (DockerClient)client).withDefaultTCPConnectionSettings();
        MockDockerConnectionManager.configureConnectionManager(new IDockerConnection[]{dockerConnection});
    }

    private void checkNetworkMode(String networkMode) {
        if (this.mockitoIsUsed()) {
            this.runContainer(networkMode);
            this.getConnection().refresh();
            new WaitUntil((WaitCondition)new ContainerIsDeployedCondition(CONTAINER_NAME, this.getConnection()));
        }
        new WaitWhile((WaitCondition)new JobIsRunning());
        PropertySheet propertiesView = this.openPropertiesTabForContainer("Inspect", CONTAINER_NAME);
        String networkProp = propertiesView.getProperty(new String[]{"HostConfig", "NetworkMode"}).getPropertyValue();
        Assert.assertTrue((String)("Container is not running in " + networkMode + " network mode!"), (boolean)networkProp.equals(networkMode));
    }
}

