/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.docker.integration.tests.container;

import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.exceptions.DockerException;
import com.spotify.docker.client.messages.Container;
import com.spotify.docker.client.messages.ContainerInfo;
import com.spotify.docker.client.messages.Image;
import com.spotify.docker.client.messages.ImageInfo;
import java.util.Arrays;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.integration.tests.image.AbstractImageBotTest;
import org.eclipse.linuxtools.docker.integration.tests.mock.MockDockerConnectionManager;
import org.eclipse.linuxtools.docker.integration.tests.mock.MockUtils;
import org.eclipse.linuxtools.docker.reddeer.core.ui.wizards.ImageRunResourceVolumesVariablesPage;
import org.eclipse.linuxtools.docker.reddeer.core.ui.wizards.ImageRunSelectionPage;
import org.eclipse.linuxtools.docker.reddeer.ui.DockerImagesTab;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockContainerFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockContainerInfoFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockDockerClientFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockDockerConnectionFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockImageFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockImageInfoFactory;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.workbench.core.condition.JobIsRunning;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class VariablesTest
extends AbstractImageBotTest {
    private static final String IMAGE_NAME = "test_variables";
    private static final String CONTAINER_NAME = "run_test_variables";
    private DockerClient client;
    private Container createdContainer;
    private ContainerInfo containerInfo;

    @Before
    public void before() throws DockerException, InterruptedException {
        if (this.mockitoIsUsed()) {
            this.setUpForMockito();
        }
    }

    @Test
    public void testVariables() {
        this.getConnection();
        DockerImagesTab imagesTab = this.openDockerImagesTab();
        this.buildImage(IMAGE_NAME, "resources/test-variables", imagesTab);
        if (this.mockitoIsUsed()) {
            MockUtils.pullImage("default", IMAGE_NAME, "latest");
        }
        this.assertConsoleSuccess();
        imagesTab.activate();
        imagesTab.refresh();
        new WaitWhile((WaitCondition)new JobIsRunning());
        imagesTab.runImage(IMAGE_NAME);
        ImageRunSelectionPage firstPage = new ImageRunSelectionPage((ReferencedComposite)imagesTab);
        firstPage.setContainerName(CONTAINER_NAME);
        firstPage.next();
        ImageRunResourceVolumesVariablesPage secondPage = new ImageRunResourceVolumesVariablesPage((ReferencedComposite)firstPage);
        secondPage.addEnviromentVariable("FOO", "barbarbar");
        if (this.mockitoIsUsed()) {
            MockDockerClientFactory.addContainer((DockerClient)this.client, (Container)this.createdContainer, (ContainerInfo)this.containerInfo);
        }
        secondPage.finish();
        new WaitWhile((WaitCondition)new JobIsRunning());
        this.assertConsoleContains("FOO is barbarbar");
    }

    @Override
    @After
    public void after() {
        this.deleteContainerIfExists(CONTAINER_NAME);
        this.deleteImageIfExists(IMAGE_NAME);
    }

    private void setUpForMockito() throws DockerException, InterruptedException {
        Image image = MockImageFactory.id((String)"1a2b3c4d5e6f7g").name("fnichol/uhttpd:latest", new String[0]).build();
        ImageInfo imageInfo = MockImageInfoFactory.volume((String)"/foo/bar").command(Arrays.asList("the", "command")).entrypoint(Arrays.asList("the", "entrypoint")).env(Arrays.asList("FOO", "barbarbar")).build();
        this.createdContainer = MockContainerFactory.id((String)"1MockContainer").name(CONTAINER_NAME, new String[0]).imageName("1a2b3c4d5e6f7g").status("Started 1 second ago").build();
        this.containerInfo = MockContainerInfoFactory.privilegedMode((boolean)true).id("TestTestTestTestTest").ipAddress("127.0.0.1").build();
        this.client = MockDockerClientFactory.image((Image)image, (ImageInfo)imageInfo).build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from((String)"default", (DockerClient)this.client).withDefaultTCPConnectionSettings();
        MockDockerConnectionManager.configureConnectionManager(new IDockerConnection[]{dockerConnection});
    }
}

