/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.docker.integration.tests.image;

import org.eclipse.linuxtools.docker.integration.tests.image.AbstractImageBotTest;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.workbench.core.condition.JobIsRunning;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PullImageTest
extends AbstractImageBotTest {
    @Before
    public void before() {
        PullImageTest.deleteAllConnections();
        this.getConnection();
        this.deleteImageIfExists("alpine:3.3");
        this.deleteImageIfExists("busybox:latest");
    }

    @Test
    public void testPullImageWithTag() {
        this.clearConsole();
        this.pullImage("alpine", "3.3", null);
        new WaitWhile((WaitCondition)new JobIsRunning());
        Assert.assertTrue((String)"Image has not been deployed!", (boolean)this.imageIsDeployed("alpine:3.3"));
    }

    @Test
    public void testPullImageWithoutTag() {
        this.clearConsole();
        this.pullImage("busybox");
        new WaitWhile((WaitCondition)new JobIsRunning());
        Assert.assertTrue((String)"Image has not been deployed!", (boolean)this.imageIsDeployed("busybox:latest"));
        Assert.assertTrue((String)"Multiple tags of the same image has been deployed, not only latest tag!", (this.deployedImagesCount("busybox") == 1 ? 1 : 0) != 0);
    }

    @Override
    @After
    public void after() {
        for (String imageName : this.getConnection().getImagesNames(true)) {
            if (!imageName.contains("busybox")) continue;
            this.deleteImageContainer(imageName);
        }
        this.cleanUpWorkspace();
    }
}

