/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.docker.integration.tests.mock;

import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.messages.Container;
import com.spotify.docker.client.messages.ContainerInfo;
import com.spotify.docker.client.messages.Image;
import java.io.File;
import java.io.IOException;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.integration.tests.mock.MockBrowserView;
import org.eclipse.linuxtools.docker.integration.tests.mock.MockConsoleView;
import org.eclipse.linuxtools.docker.integration.tests.mock.MockDockerConnectionManager;
import org.eclipse.linuxtools.docker.reddeer.ui.DockerExplorerView;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockContainerFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockContainerInfoFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockDockerClientFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockDockerConnectionFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockDockerConnectionSettingsFinder;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockImageFactory;
import org.eclipse.reddeer.eclipse.ui.browser.WebBrowserView;
import org.eclipse.reddeer.eclipse.ui.console.ConsoleView;
import org.junit.Assert;

public class MockUtils {
    public static void createDockerMockConnection(String connectionName) {
        DockerExplorerView de = new DockerExplorerView();
        de.open();
        File dockerSocketTmpFile = null;
        try {
            dockerSocketTmpFile = File.createTempFile("dockerMock", ".sock");
        }
        catch (IOException e) {
            new Exception("Cannot create mocked Docker connection!");
            e.printStackTrace();
        }
        MockDockerConnectionSettingsFinder.validUnixSocketConnectionAvailable((String)connectionName, (String)("unix://" + dockerSocketTmpFile.getAbsolutePath()));
        de.createDockerConnectionUnix(new IDockerConnection[]{MockUtils.configureUnixSocketConnection(connectionName, "unix://" + dockerSocketTmpFile.getAbsolutePath())});
        Assert.assertTrue((String)"Docker connection does not exist! ", (boolean)de.connectionExistForName(connectionName));
    }

    private static IDockerConnection configureUnixSocketConnection(String connectionName, String pathToSocket) {
        DockerClient client = MockDockerClientFactory.build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from((String)connectionName, (DockerClient)client).withUnixSocketConnectionSettings(pathToSocket);
        DockerExplorerView de = new DockerExplorerView();
        de.open();
        de.createDockerConnectionUnix(new IDockerConnection[]{dockerConnection});
        MockDockerConnectionManager.configureConnectionManager(new IDockerConnection[]{dockerConnection});
        return dockerConnection;
    }

    public static void pullImage(String connectionName, String imageName, String imageTag) {
        DockerClient client = MockDockerClientFactory.image((Image)MockImageFactory.id((String)"987654321abcde").name(String.valueOf(imageName) + ":" + imageTag, new String[0]).build()).build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from((String)connectionName, (DockerClient)client).withDefaultTCPConnectionSettings();
        MockDockerConnectionManager.configureConnectionManager(new IDockerConnection[]{dockerConnection});
    }

    public static void removeImage(String connectionName, String imageName, String imageTag) {
        DockerClient client = MockDockerClientFactory.build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from((String)connectionName, (DockerClient)client).withDefaultTCPConnectionSettings();
        MockDockerConnectionManager.configureConnectionManager(new IDockerConnection[]{dockerConnection});
    }

    public static void runContainer(String connectionName, String imageName, String imageTag, String containerName) {
        DockerClient client = MockDockerClientFactory.container((Container)MockContainerFactory.name((String)containerName, (String[])new String[0]).status("Stopped").build()).image(MockImageFactory.id((String)"987654321abcde").name(String.valueOf(imageName) + ":" + imageTag, new String[0]).build()).build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from((String)connectionName, (DockerClient)client).withDefaultTCPConnectionSettings();
        MockDockerConnectionManager.configureConnectionManager(new IDockerConnection[]{dockerConnection});
    }

    public static void runContainer(String connectionName, String imageName, String imageTag, String containerName, ContainerInfo containerInfo) {
        DockerClient client = MockDockerClientFactory.container((Container)MockContainerFactory.name((String)containerName, (String[])new String[0]).status("Stopped").build(), (ContainerInfo)MockContainerInfoFactory.link((String)"alpine").volume("resources/test-volumes/index.html").id("TestTestTestTestTest").ipAddress("127.0.0.1").build()).image(MockImageFactory.id((String)"987654321abcde").name(String.valueOf(imageName) + ":" + imageTag, new String[0]).build()).build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from((String)connectionName, (DockerClient)client).withDefaultTCPConnectionSettings();
        MockDockerConnectionManager.configureConnectionManager(new IDockerConnection[]{dockerConnection});
    }

    public static ConsoleView getConsoleViewText(String msg) {
        ConsoleView cv = MockConsoleView.msg(msg).build();
        return cv;
    }

    public static WebBrowserView getBrowserView(String url, String text) {
        WebBrowserView browser = MockBrowserView.openPageURL(url).setText(text).build();
        return browser;
    }
}

